/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.util.resources.IProjectFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class ProjectSelectionDialog
extends Dialog {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private String dialogTitle;
    private String dialogMessage;
    private IProjectFilter filter;
    private IProject selectedProject;
    private Label label;
    private TableViewer table;

    public ProjectSelectionDialog(Shell shell, IProjectFilter filter, String dialogTitle, String dialogMessage) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.filter = filter;
        this.selectedProject = null;
        this.dialogTitle = dialogTitle != null ? dialogTitle : Resources.defaultDialogTitle;
        this.dialogMessage = dialogMessage != null ? dialogMessage : Resources.defaultDialogMessage;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    protected Control createDialogArea(Composite parent) {
        String clname;
        IDialogSettings settings;
        IDialogSettings root = CommonUiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings = settings = root.getSection(clname = ((Object)((Object)this)).getClass().getName()) != null ? root.getSection(clname) : root.addNewSection(clname);
        if (settings.get(WIDTH) == null) {
            settings.put(WIDTH, 300);
        }
        if (settings.get(HEIGHT) == null) {
            settings.put(HEIGHT, 150);
        }
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        int width = settings.getInt(WIDTH);
        int height = settings.getInt(HEIGHT);
        composite.setLayoutData((Object)SwtUtil.gdhhint(SwtUtil.gdwhint(SwtUtil.gdfill(), width), height));
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = composite.getSize();
                settings.put(ProjectSelectionDialog.WIDTH, size.x);
                settings.put(ProjectSelectionDialog.HEIGHT, size.y);
            }
        });
        this.label = new Label(composite, 0);
        this.label.setText(this.dialogMessage);
        this.label.setLayoutData((Object)SwtUtil.gdhfill());
        this.table = new TableViewer(composite);
        this.table.getTable().setLayoutData((Object)SwtUtil.gdfill());
        this.table.setContentProvider((IContentProvider)new ContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.table.setSorter((ViewerSorter)new Sorter());
        this.table.setInput((Object)ResourcesPlugin.getWorkspace());
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.handleSelectionChanged(event);
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        IProject firstProject = (IProject)this.table.getElementAt(0);
        if (firstProject != null) {
            this.table.setSelection((ISelection)new StructuredSelection((Object)firstProject));
        }
        this.setOkButtonEnabled(firstProject != null);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected void cancelPressed() {
        this.selectedProject = null;
        super.cancelPressed();
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
        this.selectedProject = (IProject)ssel.getFirstElement();
    }

    private void setOkButtonEnabled(final boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        } else {
            final Display display = Display.getCurrent();
            Thread t = new Thread(){

                @Override
                public void run() {
                    Button b = ProjectSelectionDialog.this.getButton(0);
                    while (b == null) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        b = ProjectSelectionDialog.this.getButton(0);
                    }
                    final Button finalButton = b;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            finalButton.setEnabled(enabled);
                        }
                    });
                }
            };
            t.start();
        }
    }

    private final class ContentProvider
    implements IStructuredContentProvider {
        private IProject[] projects = null;

        private ContentProvider() {
        }

        public Object[] getElements(Object input) {
            return this.projects;
        }

        public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                IProjectFilter filter = ProjectSelectionDialog.this.filter;
                IWorkspace ws = (IWorkspace)newInput;
                ArrayList<IProject> projectsList = new ArrayList<IProject>();
                IProject[] iProjectArray = ws.getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isAccessible() && (filter == null || filter.check(project))) {
                        projectsList.add(project);
                    }
                    ++n2;
                }
                this.projects = projectsList.toArray(new IProject[projectsList.size()]);
            } else {
                this.projects = null;
            }
        }

        public void dispose() {
        }
    }

    private static final class LabelProvider
    extends DecoratingLabelProvider {
        public LabelProvider() {
            super((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultDialogTitle;
        public static String defaultDialogMessage;

        static {
            Resources.initializeMessages((String)ProjectSelectionDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            String aName = ((IProject)a).getName();
            String bName = ((IProject)b).getName();
            return aName.compareTo(bName);
        }
    }
}

