/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;

public class XPathSelectionDialog
extends SelectionStatusDialog {
    private Text schemaLocationTxt;
    private TreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerComparator fComparator;
    private boolean fAllowMultiple = true;
    private boolean fDoubleClickSelects = true;
    private String fEmptyListMessage = WorkbenchMessages.ElementTreeSelectionDialog_nothing_available;
    private IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private Text pathText = null;
    private String xpath = "";
    private String xsdUri = null;
    private CMDocument xsdDoc = null;
    private String initialNodePath = "";

    public XPathSelectionDialog(Shell parent, String uri) {
        super(parent);
        this.setTitle(Resources.dlgTitle);
        this.fLabelProvider = new XSDLabelProvider();
        this.fContentProvider = new XSDContentProvider();
        this.xsdUri = uri;
        this.setInput(Resources.loadingSchema);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (XPathSelectionDialog.this.pathText.getText().length() == 0) {
                    return new Status(4, "oracle.eclipse.tools.common.ui", Resources.selectXPathErrorMsg);
                }
                return new Status(0, "oracle.eclipse.tools.common.ui", "");
            }
        });
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
    }

    private void loadXsdDocument() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.setTaskName(Resources.loadingSchema);
                try {
                    ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
                    String uri = catalog.resolveURI(XPathSelectionDialog.this.xsdUri);
                    if (uri == null) {
                        uri = catalog.resolveSystem(XPathSelectionDialog.this.xsdUri);
                    }
                    if (uri == null) {
                        uri = XPathSelectionDialog.this.xsdUri;
                    }
                    XPathSelectionDialog.this.xsdDoc = ContentModelManager.getInstance().createCMDocument(uri, null);
                    if (XPathSelectionDialog.this.xsdDoc != null) {
                        XPathSelectionDialog.this.setInput(XPathSelectionDialog.this.xsdDoc);
                        XPathSelectionDialog.this.schemaLocationTxt.setText(XPathSelectionDialog.this.xsdUri);
                    } else {
                        XPathSelectionDialog.this.setInput(Resources.descriptorNotFoundErrorMsg);
                    }
                    XPathSelectionDialog.this.fViewer.setInput(XPathSelectionDialog.this.fInput);
                    XPathSelectionDialog.this.revealInitiaNode();
                    XPathSelectionDialog.this.fViewer.getControl().forceFocus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                monitor.done();
            }
        };
        try {
            dialog.run(false, false, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setInitialNodePath(String initialNodePath) {
        this.initialNodePath = initialNodePath;
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.fAllowMultiple = allowMultiple;
    }

    public void setDoubleClickSelects(boolean doubleClickSelects) {
        this.fDoubleClickSelects = doubleClickSelects;
    }

    public void setSorter(ViewerSorter sorter) {
        this.fComparator = sorter;
    }

    public void setComparator(ViewerComparator comparator) {
        this.fComparator = comparator;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(filter);
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.getResult());
                this.updateStatus(this.fCurrStatus);
            } else {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        super.open();
        return this.getReturnCode();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.xpath = this.pathText.getText();
        this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
    }

    public String getXPath() {
        return this.xpath;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label schemaLocation = new Label(composite, 0);
        schemaLocation.setText(Resources.schemaLocation);
        this.schemaLocationTxt = new Text(composite, 2056);
        GridData gd1 = new GridData(768);
        gd1.widthHint = 400;
        this.schemaLocationTxt.setLayoutData((Object)gd1);
        Label schemaTreeLabel = new Label(composite, 0);
        schemaTreeLabel.setLayoutData((Object)new GridData(768));
        schemaTreeLabel.setText(Resources.selectXPath);
        TreeViewer treeViewer = this.createTreeViewer(composite);
        Tree treeWidget = treeViewer.getTree();
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        gd.heightHint = 200;
        gd.widthHint = 400;
        treeWidget.setLayoutData((Object)gd);
        treeWidget.setFont(parent.getFont());
        this.fViewer.setInput(this.fInput);
        this.createPathText(composite);
        Point size = treeWidget.getSize();
        if (size.y > 400) {
            treeWidget.setSize(new Point(size.x, 400));
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection treeSelection = (TreeSelection)XPathSelectionDialog.this.fViewer.getSelection();
                TreePath[] path = treeSelection.getPaths();
                if (path.length > 0) {
                    TreePath p = path[0];
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < p.getSegmentCount()) {
                        if (p.getSegment(i) instanceof CMNode) {
                            CMNode node = (CMNode)p.getSegment(i);
                            if (node.getNodeType() == 2) {
                                sb.append("@");
                            } else {
                                sb.append("/");
                            }
                            sb.append(node.getNodeName());
                        }
                        ++i;
                    }
                    XPathSelectionDialog.this.pathText.setText(sb.toString());
                    XPathSelectionDialog.this.pathText.setFocus();
                    XPathSelectionDialog.this.updateOKStatus();
                }
            }
        });
        this.loadXsdDocument();
        this.updateOKStatus();
        return composite;
    }

    private void createPathText(Composite composite) {
        this.pathText = new Text(composite, 2114);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        this.pathText.setLayoutData((Object)data);
        this.pathText.setText("");
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPathSelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        int style = 0x800 | (this.fAllowMultiple ? 2 : 4);
        this.fViewer = this.doCreateTreeViewer(parent, style);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XPathSelectionDialog.this.access$setResult(((IStructuredSelection)event.getSelection()).toList());
                XPathSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setComparator(this.fComparator);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(i));
                ++i;
            }
        }
        if (this.fDoubleClickSelects) {
            Tree tree = this.fViewer.getTree();
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    XPathSelectionDialog.this.updateOKStatus();
                    if (XPathSelectionDialog.this.fCurrStatus.isOK()) {
                        XPathSelectionDialog.this.access$superButtonPressed(0);
                    }
                }
            });
        }
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection;
                XPathSelectionDialog.this.updateOKStatus();
                if (!(XPathSelectionDialog.this.fDoubleClickSelects && XPathSelectionDialog.this.fCurrStatus.isOK() || !((selection = event.getSelection()) instanceof IStructuredSelection))) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (XPathSelectionDialog.this.fViewer.getExpandedState(item)) {
                        XPathSelectionDialog.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        XPathSelectionDialog.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        return this.fViewer;
    }

    private void revealInitiaNode() {
        String selector;
        String[] pair;
        if (this.initialNodePath == null || this.initialNodePath.length() == 0) {
            return;
        }
        this.pathText.setText(this.initialNodePath);
        CMDocument foundNode = this.xsdDoc;
        String nodePath = this.initialNodePath.substring(1);
        int start = nodePath.indexOf(91);
        int end = nodePath.indexOf(93);
        if (start < end && (pair = (selector = nodePath.substring(start + 1, end - 1)).split("=")).length == 2) {
            nodePath = String.valueOf(nodePath.substring(0, start - 1)) + nodePath.substring(end + 1);
        }
        String[] path = nodePath.split("/");
        this.fViewer.expandToLevel(path.length);
        this.fViewer.collapseAll();
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            boolean found = false;
            CMNamedNodeMap map = null;
            map = foundNode instanceof CMDocument ? foundNode.getElements() : ((CMElementDeclaration)foundNode).getLocalElements();
            for (CMNode node : map) {
                String nodeName = node.getNodeName();
                if (!nodeName.equals(segment)) continue;
                foundNode = node;
                found = true;
                break;
            }
            if (!found) break;
            ++n2;
        }
        if (foundNode != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)foundNode), true);
        }
        this.updateOKStatus();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new TreeViewer(new Tree(parent, style));
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    private boolean evaluateIfTreeEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            int i = 0;
            while (i < this.fFilters.size()) {
                ViewerFilter curr = (ViewerFilter)this.fFilters.get(i);
                elements = curr.filter((Viewer)this.fViewer, input, elements);
                ++i;
            }
        }
        return elements.length == 0;
    }

    protected void access$superButtonPressed(int id) {
        super.buttonPressed(id);
    }

    protected void access$setResult(List result) {
        super.setResult(result);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        if (this.getReturnCode() == 1) {
            this.setResult(null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String selectXPath;
        public static String schemaLocation;
        public static String descriptorNotFoundErrorMsg;
        public static String selectXPathErrorMsg;
        public static String dlgTitle;
        public static String loadingSchema;

        static {
            Resources.initializeMessages((String)XPathSelectionDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    class XSDContentProvider
    implements ITreeContentProvider {
        XSDContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CMElementDeclaration) {
                CMElementDeclaration node = (CMElementDeclaration)parentElement;
                ArrayList<CMNode> ret = new ArrayList<CMNode>();
                CMNamedNodeMap attributes = node.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    if (!attributes.item(i).getNodeName().equals("id")) {
                        ret.add(attributes.item(i));
                    }
                    ++i;
                }
                CMNamedNodeMap map = node.getLocalElements();
                int i2 = 0;
                while (i2 < map.getLength()) {
                    ret.add(map.item(i2));
                    ++i2;
                }
                return ret.toArray(new Object[1]);
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CMElementDeclaration) {
                CMElementDeclaration elm = (CMElementDeclaration)element;
                int n = elm.getLocalElements().getLength();
                return n > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CMDocument) {
                CMDocument xsdDoc = (CMDocument)inputElement;
                CMNamedNodeMap elementMap = xsdDoc.getElements();
                ArrayList rootElements = new ArrayList();
                Iterator it = elementMap.iterator();
                while (it.hasNext()) {
                    rootElements.add(it.next());
                }
                return rootElements.toArray();
            }
            return new Object[]{inputElement};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class XSDLabelProvider
    implements ILabelProvider {
        XSDLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CMNode) {
                CMNode node = (CMNode)element;
                if (node.getNodeType() == 5) {
                    return CommonImages.createImage(CommonImages.DESC_ELEMENT_ICON);
                }
                return CommonImages.createImage(CommonImages.DESC_ATTRIBUTE_ICON);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CMNode) {
                CMNode node = (CMNode)element;
                if (node.getNodeType() == 5) {
                    return node.getNodeName();
                }
                if (node.getNodeType() == 2) {
                    return "@" + node.getNodeName();
                }
                return node.getNodeName();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

