/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PrintModeDialog
extends Dialog {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(PrintModeDialog.class);
    private Button tile;
    private Button fitPage;
    private Button fitWidth;
    private Button fitHeight;
    private int printMode;

    public PrintModeDialog(Shell shell) {
        this(shell, 1);
    }

    public PrintModeDialog(Shell shell, int printMode) {
        super(shell);
        this.printMode = printMode;
    }

    protected void cancelPressed() {
        this.setReturnCode(-1);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(_resourceLoader.resource("dlg-title", new Object[0]));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tile = new Button(composite, 16);
        this.tile.setText(_resourceLoader.resource("tile", new Object[0]));
        this.fitPage = new Button(composite, 16);
        this.fitPage.setText(_resourceLoader.resource("fit-page", new Object[0]));
        this.fitWidth = new Button(composite, 16);
        this.fitWidth.setText(_resourceLoader.resource("fit-width", new Object[0]));
        this.fitHeight = new Button(composite, 16);
        this.fitHeight.setText(_resourceLoader.resource("fit-height", new Object[0]));
        switch (this.printMode) {
            case 1: {
                this.tile.setSelection(true);
                break;
            }
            case 2: {
                this.fitPage.setSelection(true);
                break;
            }
            case 4: {
                this.fitHeight.setSelection(true);
                break;
            }
            case 3: {
                this.fitWidth.setSelection(true);
                break;
            }
            default: {
                assert (false) : "Wrong print mode: " + this.printMode;
                break;
            }
        }
        composite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27) {
                    PrintModeDialog.this.cancelPressed();
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        int returnCode = -1;
        if (this.tile.getSelection()) {
            returnCode = 1;
        } else if (this.fitPage.getSelection()) {
            returnCode = 2;
        } else if (this.fitHeight.getSelection()) {
            returnCode = 4;
        } else if (this.fitWidth.getSelection()) {
            returnCode = 3;
        }
        this.setReturnCode(returnCode);
        this.close();
    }
}

