/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import java.util.concurrent.atomic.AtomicReference;
import oracle.eclipse.tools.common.operations.CompoundOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperation;
import oracle.eclipse.tools.common.operations.ICompoundOperationConfigurator;
import oracle.eclipse.tools.common.operations.IOperation;
import oracle.eclipse.tools.common.operations.NullOperation;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.ui.dialogs.IOperationLabelProvider;
import oracle.eclipse.tools.common.ui.dialogs.OperationSelectionDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class OperationDialogConfigurator
implements ICompoundOperationConfigurator {
    public ICompoundOperation configure(ICompoundOperation compoundOperation) {
        if (OperationUtil.areDialogsEnabled()) {
            return this.openDialog(compoundOperation.getLabel(), Strings.dialogMessage, compoundOperation);
        }
        return compoundOperation;
    }

    private ICompoundOperation openDialog(final String title, final String description, final ICompoundOperation compoundOperation) {
        final AtomicReference selectedOperationsCompositeRef = new AtomicReference();
        Runnable dialogRunnable = new Runnable(){

            @Override
            public void run() {
                OperationSelectionDialog dialog = new OperationSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), compoundOperation, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new IOperationLabelProvider(), "");
                dialog.setTitle(title);
                dialog.setMessage(description);
                switch (dialog.open()) {
                    case 0: {
                        selectedOperationsCompositeRef.set(new CompoundOperation(title, dialog.getResult()));
                        break;
                    }
                    default: {
                        CompoundOperation operation = new CompoundOperation("");
                        operation.add((IOperation)new NullOperation());
                        selectedOperationsCompositeRef.set(operation);
                    }
                }
            }
        };
        Display display = Display.getCurrent();
        if (display != null) {
            dialogRunnable.run();
        } else {
            display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(dialogRunnable);
        }
        return (ICompoundOperation)selectedOperationsCompositeRef.get();
    }

    private static final class Strings
    extends NLS {
        public static String dialogMessage;

        static {
            Strings.initializeMessages((String)OperationDialogConfigurator.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

