/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.routers;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.routers.DoublePoint;
import oracle.eclipse.tools.common.ui.diagram.routers.Edge;
import oracle.eclipse.tools.common.ui.diagram.routers.PathUtil;
import oracle.eclipse.tools.common.ui.diagram.routers.Solver;

public class SplineRoute {
    public static double EPSILON1 = 1.0E-6;
    public static double EPSILON2 = 1.0E-6;
    private List<DoublePoint> ops = new ArrayList<DoublePoint>();

    public List<DoublePoint> routespline(List<Edge> edges, List<DoublePoint> points, DoublePoint slope0, DoublePoint slope1) {
        slope0 = PathUtil.normv(slope0);
        slope1 = PathUtil.normv(slope1);
        this.ops.add(new DoublePoint(points.get(0)));
        this.reallyroutespline(edges, points, slope0, slope1);
        return this.ops;
    }

    public int reallyroutespline(List<Edge> edges, List<DoublePoint> points, DoublePoint slope0, DoublePoint slope1) {
        DoublePoint v2;
        DoublePoint p2;
        DoublePoint v1;
        int inpn = points.size();
        tna_t[] tnas = new tna_t[inpn];
        int i = 0;
        while (i < inpn) {
            tnas[i] = new tna_t();
            ++i;
        }
        tnas[0].t = 0.0;
        i = 1;
        while (i < inpn) {
            tnas[i].t = tnas[i - 1].t + PathUtil.dist(points.get(i), points.get(i - 1));
            ++i;
        }
        i = 1;
        while (i < inpn) {
            tnas[i].t /= tnas[inpn - 1].t;
            ++i;
        }
        i = 0;
        while (i < inpn) {
            tnas[i].a[0] = PathUtil.scale(slope0, PathUtil.B1(tnas[i].t));
            tnas[i].a[1] = PathUtil.scale(slope1, PathUtil.B2(tnas[i].t));
            ++i;
        }
        List<DoublePoint> splinePoints = SplineRoute.mkspline(points, tnas, slope0, slope1);
        DoublePoint p1 = splinePoints.get(0);
        if (this.splinefits(edges, p1, v1 = splinePoints.get(1), p2 = splinePoints.get(2), v2 = splinePoints.get(3), inpn == 2)) {
            return 0;
        }
        DoublePoint cp1 = PathUtil.add(p1, PathUtil.scale(v1, 0.3333333333333333));
        DoublePoint cp2 = PathUtil.sub(p2, PathUtil.scale(v2, 0.3333333333333333));
        DoublePoint p = new DoublePoint();
        double maxd = -1.0;
        int maxi = -1;
        i = 1;
        while (i < inpn - 1) {
            double t = tnas[i].t;
            p.x = PathUtil.B0(t) * p1.x + PathUtil.B1(t) * cp1.x + PathUtil.B2(t) * cp2.x + PathUtil.B3(t) * p2.x;
            p.y = PathUtil.B0(t) * p1.y + PathUtil.B1(t) * cp1.y + PathUtil.B2(t) * cp2.y + PathUtil.B3(t) * p2.y;
            double d = PathUtil.dist(p, points.get(i));
            if (d > maxd) {
                maxd = d;
                maxi = i;
            }
            ++i;
        }
        int spliti = maxi;
        DoublePoint splitv1 = PathUtil.normv(PathUtil.sub(points.get(spliti), points.get(spliti - 1)));
        DoublePoint splitv2 = PathUtil.normv(PathUtil.sub(points.get(spliti + 1), points.get(spliti)));
        DoublePoint splitv = PathUtil.normv(PathUtil.add(splitv1, splitv2));
        ArrayList<DoublePoint> leftpts = new ArrayList<DoublePoint>(spliti + 1);
        ArrayList<DoublePoint> rightpts = new ArrayList<DoublePoint>(inpn - spliti);
        i = 0;
        while (i < spliti + 1) {
            leftpts.add(points.get(i));
            ++i;
        }
        i = spliti;
        while (i < inpn) {
            rightpts.add(points.get(i));
            ++i;
        }
        this.reallyroutespline(edges, leftpts, slope0, splitv);
        this.reallyroutespline(edges, rightpts, splitv, slope1);
        return 0;
    }

    public static List<DoublePoint> mkspline(List<DoublePoint> points, tna_t[] tnas, DoublePoint slope0, DoublePoint slope1) {
        ArrayList<DoublePoint> splinePoints = new ArrayList<DoublePoint>();
        double[][] c = new double[2][2];
        double[] x = new double[2];
        int inpn = points.size();
        double scale3 = 0.0;
        double scale0 = 0.0;
        c[1][1] = 0.0;
        c[1][0] = 0.0;
        c[0][1] = 0.0;
        c[0][0] = 0.0;
        x[1] = 0.0;
        x[0] = 0.0;
        DoublePoint startp = points.get(0);
        DoublePoint endp = points.get(inpn - 1);
        int i = 0;
        while (i < inpn) {
            double[] dArray = c[0];
            dArray[0] = dArray[0] + PathUtil.dot(tnas[i].a[0], tnas[i].a[0]);
            double[] dArray2 = c[0];
            dArray2[1] = dArray2[1] + PathUtil.dot(tnas[i].a[0], tnas[i].a[1]);
            c[1][0] = c[0][1];
            double[] dArray3 = c[1];
            dArray3[1] = dArray3[1] + PathUtil.dot(tnas[i].a[1], tnas[i].a[1]);
            DoublePoint tmp = PathUtil.sub(points.get(i), PathUtil.add(PathUtil.scale(startp, PathUtil.B01(tnas[i].t)), PathUtil.scale(endp, PathUtil.B23(tnas[i].t))));
            x[0] = x[0] + PathUtil.dot(tnas[i].a[0], tmp);
            x[1] = x[1] + PathUtil.dot(tnas[i].a[1], tmp);
            ++i;
        }
        double det01 = c[0][0] * c[1][1] - c[1][0] * c[0][1];
        double det0X = c[0][0] * x[1] - c[0][1] * x[0];
        double detX1 = x[0] * c[1][1] - x[1] * c[0][1];
        if (det01 != 0.0) {
            scale0 = detX1 / det01;
            scale3 = det0X / det01;
        }
        if (Math.abs(det01) < EPSILON1 || scale0 <= 0.0 || scale3 <= 0.0) {
            double d01;
            scale0 = d01 = PathUtil.dist(startp, endp) / 3.0;
            scale3 = d01;
        }
        DoublePoint sp0 = new DoublePoint(startp);
        DoublePoint sv0 = new DoublePoint(PathUtil.scale(slope0, scale0));
        DoublePoint sp1 = new DoublePoint(endp);
        DoublePoint sv1 = new DoublePoint(PathUtil.scale(slope1, scale3));
        splinePoints.add(sp0);
        splinePoints.add(sv0);
        splinePoints.add(sp1);
        splinePoints.add(sv1);
        return splinePoints;
    }

    private boolean splinefits(List<Edge> edges, DoublePoint pa, DoublePoint va, DoublePoint pb, DoublePoint vb, boolean forceflag) {
        DoublePoint[] sps = new DoublePoint[4];
        double b = 4.0;
        double a = 4.0;
        while (true) {
            sps[0] = pa;
            sps[1] = new DoublePoint(pa.x + a * va.x / 3.0, pa.y + a * va.y / 3.0);
            sps[2] = new DoublePoint(pb.x - b * vb.x / 3.0, pb.y - b * vb.y / 3.0);
            sps[3] = pb;
            if (this.splineisinside(edges, sps)) {
                int pi = 1;
                while (pi < 4) {
                    this.ops.add(new DoublePoint(sps[pi]));
                    ++pi;
                }
                return true;
            }
            if (a == 0.0 && b == 0.0) {
                if (!forceflag) break;
                int pi = 1;
                while (pi < 4) {
                    this.ops.add(new DoublePoint(sps[pi]));
                    ++pi;
                }
                return true;
            }
            if (a > 0.01) {
                a /= 2.0;
                b /= 2.0;
                continue;
            }
            b = 0.0;
            a = 0.0;
        }
        return false;
    }

    private boolean splineisinside(List<Edge> edges, DoublePoint[] sps) {
        double[] roots = new double[4];
        DoublePoint[] lps = new DoublePoint[2];
        int edgen = edges.size();
        int ei = 0;
        while (ei < edgen) {
            Edge edge = edges.get(ei);
            lps[0] = new DoublePoint(edge.a);
            lps[1] = new DoublePoint(edge.b);
            int rootn = this.splineintersectsline(sps, lps, roots);
            if (rootn != 4) {
                int rooti = 0;
                while (rooti < rootn) {
                    double y;
                    double td;
                    double tc;
                    double tb;
                    double t;
                    double ta;
                    double x;
                    DoublePoint ip;
                    if (!(roots[rooti] < EPSILON2 || roots[rooti] > 1.0 - EPSILON2 || this.DISTSQ(ip = new DoublePoint(x = (ta = (1.0 - (t = roots[rooti])) * (1.0 - t) * (1.0 - t)) * sps[0].x + (tb = 3.0 * t * (1.0 - t) * (1.0 - t)) * sps[1].x + (tc = 3.0 * t * t * (1.0 - t)) * sps[2].x + (td = t * t * t) * sps[3].x, y = ta * sps[0].y + tb * sps[1].y + tc * sps[2].y + td * sps[3].y), lps[0]) < EPSILON1 || this.DISTSQ(ip, lps[1]) < EPSILON1)) {
                        return false;
                    }
                    ++rooti;
                }
            }
            ++ei;
        }
        return true;
    }

    private int splineintersectsline(DoublePoint[] sps, DoublePoint[] lps, double[] roots) {
        double[] scoeff = new double[4];
        double[] xcoeff = new double[2];
        double[] ycoeff = new double[2];
        double[] xroots = new double[3];
        double[] yroots = new double[3];
        xcoeff[0] = lps[0].x;
        xcoeff[1] = lps[1].x - lps[0].x;
        ycoeff[0] = lps[0].y;
        ycoeff[1] = lps[1].y - lps[0].y;
        int rootn = 0;
        if (xcoeff[1] == 0.0) {
            if (ycoeff[1] == 0.0) {
                this.points2coeff(sps[0].x, sps[1].x, sps[2].x, sps[3].x, scoeff);
                scoeff[0] = scoeff[0] - xcoeff[0];
                int xrootn = Solver.solve3(scoeff, xroots);
                this.points2coeff(sps[0].y, sps[1].y, sps[2].y, sps[3].y, scoeff);
                scoeff[0] = scoeff[0] - ycoeff[0];
                int yrootn = Solver.solve3(scoeff, yroots);
                if (xrootn == 4) {
                    if (yrootn == 4) {
                        return 4;
                    }
                    int j = 0;
                    while (j < yrootn) {
                        rootn = this.addroot(yroots[j], roots, rootn);
                        ++j;
                    }
                } else if (yrootn == 4) {
                    int i = 0;
                    while (i < xrootn) {
                        rootn = this.addroot(xroots[i], roots, rootn);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < xrootn) {
                        int j = 0;
                        while (j < yrootn) {
                            if (xroots[i] == yroots[j]) {
                                rootn = this.addroot(xroots[i], roots, rootn);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                return rootn;
            }
            this.points2coeff(sps[0].x, sps[1].x, sps[2].x, sps[3].x, scoeff);
            scoeff[0] = scoeff[0] - xcoeff[0];
            int xrootn = Solver.solve3(scoeff, xroots);
            if (xrootn == 4) {
                return 4;
            }
            int i = 0;
            while (i < xrootn) {
                double tv = xroots[i];
                if (tv >= 0.0 && tv <= 1.0) {
                    this.points2coeff(sps[0].y, sps[1].y, sps[2].y, sps[3].y, scoeff);
                    double sv = scoeff[0] + tv * (scoeff[1] + tv * (scoeff[2] + tv * scoeff[3]));
                    sv = (sv - ycoeff[0]) / ycoeff[1];
                    if (0.0 <= sv && sv <= 1.0) {
                        rootn = this.addroot(tv, roots, rootn);
                    }
                }
                ++i;
            }
            return rootn;
        }
        double rat = ycoeff[1] / xcoeff[1];
        this.points2coeff(sps[0].y - rat * sps[0].x, sps[1].y - rat * sps[1].x, sps[2].y - rat * sps[2].x, sps[3].y - rat * sps[3].x, scoeff);
        scoeff[0] = scoeff[0] + (rat * xcoeff[0] - ycoeff[0]);
        int xrootn = Solver.solve3(scoeff, xroots);
        if (xrootn == 4) {
            return 4;
        }
        int i = 0;
        while (i < xrootn) {
            double tv = xroots[i];
            if (tv >= 0.0 && tv <= 1.0) {
                this.points2coeff(sps[0].x, sps[1].x, sps[2].x, sps[3].x, scoeff);
                double sv = scoeff[0] + tv * (scoeff[1] + tv * (scoeff[2] + tv * scoeff[3]));
                sv = (sv - xcoeff[0]) / xcoeff[1];
                if (0.0 <= sv && sv <= 1.0) {
                    rootn = this.addroot(tv, roots, rootn);
                }
            }
            ++i;
        }
        return rootn;
    }

    private double DISTSQ(DoublePoint a, DoublePoint b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
    }

    private void points2coeff(double v0, double v1, double v2, double v3, double[] coeff) {
        coeff[3] = v3 + 3.0 * v1 - (v0 + 3.0 * v2);
        coeff[2] = 3.0 * v0 + 3.0 * v2 - 6.0 * v1;
        coeff[1] = 3.0 * (v1 - v0);
        coeff[0] = v0;
    }

    private int addroot(double root, double[] roots, int nroots) {
        if (root >= 0.0 && root <= 1.0) {
            roots[nroots] = root;
            ++nroots;
        }
        return nroots;
    }

    public static class tna_t {
        public double t;
        public DoublePoint[] a = new DoublePoint[2];
    }
}

