/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.routers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeRelationshipFigure;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.model.NodeRelationship;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import oracle.eclipse.tools.common.ui.diagram.routers.DoublePoint;
import oracle.eclipse.tools.common.ui.diagram.routers.Edge;
import oracle.eclipse.tools.common.ui.diagram.routers.PathUtil;
import oracle.eclipse.tools.common.ui.diagram.routers.SplineRoute;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;

public class SplineConnectionRouter
extends BendpointConnectionRouter {
    protected static Insets padding = new Insets(24, 24, 24, 24);
    protected static Insets innerpadding = new Insets(0, 0, 0, 0);

    public void route(Connection conn) {
        Point ref2;
        Point ref1;
        PointList points = conn.getPoints();
        points.removeAllPoints();
        List bendpoints = (List)this.getConstraint(conn);
        if (bendpoints == null) {
            bendpoints = Collections.EMPTY_LIST;
        }
        if (bendpoints.isEmpty()) {
            ref1 = conn.getTargetAnchor().getReferencePoint();
            ref2 = conn.getSourceAnchor().getReferencePoint();
        } else {
            ref1 = new Point(((Bendpoint)bendpoints.get(0)).getLocation());
            conn.translateToAbsolute((Translatable)ref1);
            ref2 = new Point(((Bendpoint)bendpoints.get(bendpoints.size() - 1)).getLocation());
            conn.translateToAbsolute((Translatable)ref2);
        }
        PrecisionPoint startPoint = new PrecisionPoint(conn.getSourceAnchor().getLocation(ref1));
        conn.translateToRelative((Translatable)startPoint);
        PrecisionPoint endPoint = new PrecisionPoint(conn.getTargetAnchor().getLocation(ref2));
        conn.translateToRelative((Translatable)endPoint);
        if (bendpoints.size() == 0) {
            points.addPoint((Point)startPoint);
            points.addPoint((Point)endPoint);
            conn.setPoints(points);
            return;
        }
        PrecisionPoint startPoint1 = new PrecisionPoint(startPoint.preciseX + 2.0, startPoint.preciseY);
        PrecisionPoint endPoint1 = new PrecisionPoint(endPoint.preciseX - 2.0, endPoint.preciseY);
        List<Point> convertedBPs = this.convertBendPoint(bendpoints);
        DoublePoint slope0 = null;
        DoublePoint slope1 = null;
        ArrayList<DoublePoint> polyline = new ArrayList<DoublePoint>();
        polyline.add(new DoublePoint(startPoint1));
        int i = 0;
        while (i < convertedBPs.size()) {
            PrecisionPoint curBP = new PrecisionPoint(convertedBPs.get(i));
            polyline.add(new DoublePoint(curBP));
            if (i == 0) {
                slope0 = new DoublePoint(curBP.preciseX - startPoint1.preciseX, curBP.preciseY - startPoint1.preciseY);
            }
            if (i == convertedBPs.size() - 1) {
                slope1 = new DoublePoint(endPoint1.preciseX - curBP.preciseX, endPoint1.preciseY - curBP.preciseY);
            }
            ++i;
        }
        polyline.add(new DoublePoint(endPoint1));
        List<Edge> edges = this.getSplineObstacles(conn);
        List<DoublePoint> splinePoints = new SplineRoute().routespline(edges, polyline, slope0, slope1);
        ArrayList<Double> doubles = new ArrayList<Double>();
        int depth = 4;
        int nCurves = (splinePoints.size() - 1) / 3;
        int i2 = 0;
        while (i2 < nCurves) {
            int pIndex = i2 * 3;
            DoublePoint p1 = splinePoints.get(pIndex);
            DoublePoint p2 = splinePoints.get(pIndex + 1);
            DoublePoint p3 = splinePoints.get(pIndex + 2);
            DoublePoint p4 = splinePoints.get(pIndex + 3);
            if (p1.equals(p2) && p3.equals(p4)) {
                doubles.add(p1.x);
                doubles.add(p1.y);
                doubles.add(p3.x);
                doubles.add(p3.y);
            } else {
                PathUtil.recursiveBezier(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y, depth, doubles);
            }
            ++i2;
        }
        points.addPoint((Point)startPoint);
        i2 = 2;
        while (i2 < doubles.size() - 2) {
            PrecisionPoint p = new PrecisionPoint(((Double)doubles.get(i2)).doubleValue(), ((Double)doubles.get(i2 + 1)).doubleValue());
            points.addPoint((Point)p);
            i2 += 2;
        }
        points.addPoint((Point)endPoint);
        conn.setPoints(points);
    }

    private List<Point> convertBendPoint(List bendpoints) {
        ArrayList<Point> convertedPts = new ArrayList<Point>();
        Point prevP = null;
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            Point p = bp.getLocation();
            if (prevP == null) {
                convertedPts.add(p);
            } else if (i == bendpoints.size() - 1) {
                convertedPts.add(p);
            } else if (prevP.y != p.y) {
                convertedPts.add(p);
            } else {
                Bendpoint nextBP = (Bendpoint)bendpoints.get(i + 1);
                Point nextP = nextBP.getLocation();
                if (nextP.y != p.y) {
                    convertedPts.add(p);
                }
            }
            prevP = p;
            ++i;
        }
        return convertedPts;
    }

    protected NodeDiagramPart getDiagramPart(Connection conn) {
        NodeRelationshipFigure relationFig = (NodeRelationshipFigure)conn;
        NodeRelationshipPart relationPart = relationFig.getRelationshipPart();
        NodeRelationship relation = (NodeRelationship)relationPart.getModel();
        NodeDiagramModel diagramModel = relation.getNodeDiagramModel();
        Map partRegistry = relationPart.getViewer().getEditPartRegistry();
        NodeDiagramPart diagramPart = (NodeDiagramPart)((Object)partRegistry.get(diagramModel));
        return diagramPart;
    }

    protected List<Edge> getSplineObstacles(Connection conn) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        NodeDiagramPart diagramPart = this.getDiagramPart(conn);
        List parts = diagramPart.getChildren();
        for (GraphicalEditPart part : parts) {
            IFigure fig = part.getFigure();
            if (fig == null) continue;
            Rectangle o = fig.getBounds().getCopy();
            o.width += SplineConnectionRouter.innerpadding.right + SplineConnectionRouter.innerpadding.left;
            o.x -= SplineConnectionRouter.innerpadding.left;
            o.height += SplineConnectionRouter.innerpadding.top + SplineConnectionRouter.innerpadding.bottom;
            o.y -= SplineConnectionRouter.innerpadding.top;
            PathUtil.convertRectangleToBarrier(o, edges);
        }
        return edges;
    }
}

