/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.routers;

public class Solver {
    public static int solve3(double[] coeff, double[] roots) {
        int rootn;
        double a = coeff[3];
        double b = coeff[2];
        double c = coeff[1];
        double d = coeff[0];
        if (Solver.AEQ0(a)) {
            return Solver.solve2(coeff, roots);
        }
        double b_over_3a = b / (3.0 * a);
        double c_over_a = c / a;
        double d_over_a = d / a;
        double p = b_over_3a * b_over_3a;
        double q = 2.0 * b_over_3a * p - b_over_3a * c_over_a + d_over_a;
        double disc = q * q + 4.0 * (p = c_over_a / 3.0 - p) * p * p;
        if (disc < 0.0) {
            double r = 0.5 * Math.sqrt(-disc + q * q);
            double theta = Math.atan2(Math.sqrt(-disc), -q);
            double temp = 2.0 * Math.cbrt(r);
            roots[0] = temp * Math.cos(theta / 3.0);
            roots[1] = temp * Math.cos((theta + Math.PI + Math.PI) / 3.0);
            roots[2] = temp * Math.cos((theta - Math.PI - Math.PI) / 3.0);
            rootn = 3;
        } else {
            double alpha = 0.5 * (Math.sqrt(disc) - q);
            double beta = -q - alpha;
            roots[0] = Math.cbrt(alpha) + Math.cbrt(beta);
            if (disc > 0.0) {
                rootn = 1;
            } else {
                roots[1] = roots[2] = -0.5 * roots[0];
                rootn = 3;
            }
        }
        int i = 0;
        while (i < rootn) {
            int n = i++;
            roots[n] = roots[n] - b_over_3a;
        }
        return rootn;
    }

    public static int solve2(double[] coeff, double[] roots) {
        double a = coeff[2];
        double b = coeff[1];
        double c = coeff[0];
        if (Solver.AEQ0(a)) {
            return Solver.solve1(coeff, roots);
        }
        double b_over_2a = b / (2.0 * a);
        double c_over_a = c / a;
        double disc = b_over_2a * b_over_2a - c_over_a;
        if (disc < 0.0) {
            return 0;
        }
        if (disc == 0.0) {
            roots[0] = -b_over_2a;
            return 1;
        }
        roots[0] = -b_over_2a + Math.sqrt(disc);
        roots[1] = -2.0 * b_over_2a - roots[0];
        return 2;
    }

    public static int solve1(double[] coeff, double[] roots) {
        double a = coeff[1];
        double b = coeff[0];
        if (Solver.AEQ0(a)) {
            if (Solver.AEQ0(b)) {
                return 4;
            }
            return 0;
        }
        roots[0] = -b / a;
        return 1;
    }

    private static boolean AEQ0(double x) {
        return x < 1.0E-7 && x > -1.0E-7;
    }
}

