/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.ui.diagram.model.ChildNode;
import oracle.eclipse.tools.common.ui.diagram.model.RootNode;
import oracle.eclipse.tools.common.ui.diagram.parts.ChildNodePart;
import oracle.eclipse.tools.common.ui.diagram.parts.LeftAnchor;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import oracle.eclipse.tools.common.ui.diagram.parts.RightAnchor;
import oracle.eclipse.tools.common.ui.diagram.parts.RootNodePart;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class CompoundDirectedGraphLayoutVisitor {
    static final Insets PADDING = new Insets(8, 6, 8, 6);
    static final Insets INNER_PADDING = new Insets(0);
    private Map<AbstractGraphicalEditPart, Object> _partToNodesMap;
    private CompoundDirectedGraph _graph;
    private Subgraph _parentSubGraph;

    public void layoutDiagram(NodeDiagramPart diagram) {
        this._graph = new CompoundDirectedGraph();
        this._graph.setDirection(16);
        this._graph.setDefaultPadding(new Insets(8, 16, 8, 16));
        this._graph.setMargin(new Insets(32, 32, 32, 32));
        this._partToNodesMap = new HashMap<AbstractGraphicalEditPart, Object>();
        this.addNodes(diagram);
        if (this._graph.nodes.size() > 0) {
            this.addEdges(diagram);
            new CompoundDirectedGraphLayout().visit((DirectedGraph)this._graph);
            this.applyResults(diagram);
        }
    }

    public DirectedGraph getGraph() {
        return this._graph;
    }

    protected void addNodes(NodeDiagramPart diagram) {
        this._parentSubGraph = new Subgraph((Object)diagram, null);
        this._parentSubGraph.outgoingOffset = 5;
        this._parentSubGraph.incomingOffset = 5;
        this._parentSubGraph.innerPadding = INNER_PADDING;
        this._parentSubGraph.setPadding(PADDING);
        this._partToNodesMap.put(diagram, this._parentSubGraph);
        this._graph.nodes.add((Object)this._parentSubGraph);
        List childParts = diagram.getChildren();
        int i = 0;
        while (i < childParts.size()) {
            Object childPart = childParts.get(i);
            if (childPart instanceof RootNodePart) {
                RootNodePart rp = (RootNodePart)((Object)childPart);
                this.addNodes(rp);
            }
            ++i;
        }
    }

    protected void addNodes(RootNodePart nodePart) {
        Node n = nodePart.newNodeForEditPart(this._parentSubGraph);
        this._partToNodesMap.put(nodePart, n);
        this._graph.nodes.add((Object)n);
    }

    protected void addEdges(NodeDiagramPart diagram) {
        List children = diagram.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object childPart = children.get(i);
            if (childPart instanceof RootNodePart) {
                RootNodePart rnPart = (RootNodePart)((Object)childPart);
                this.addEdges(rnPart);
            }
            ++i;
        }
    }

    protected void addEdges(RootNodePart rnPart) {
        List outgoing = rnPart.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            NodeRelationshipPart relationshipPart = (NodeRelationshipPart)((Object)outgoing.get(i));
            this.addEdges(relationshipPart);
            ++i;
        }
        List childOutgoings = rnPart.getChildrenSourceConnections();
        int i2 = 0;
        while (i2 < childOutgoings.size()) {
            NodeRelationshipPart relationshipPart = (NodeRelationshipPart)((Object)childOutgoings.get(i2));
            this.addEdges(relationshipPart);
            ++i2;
        }
    }

    protected void addEdges(NodeRelationshipPart relationshipPart) {
        EditPart targetPart;
        EditPart sourcePart = relationshipPart.getSource();
        int sourceOffset = -1;
        int targetOffset = -1;
        if (sourcePart instanceof ChildNodePart) {
            ChildNode srcNode = (ChildNode)sourcePart.getModel();
            RootNode parentNode = (RootNode)srcNode.getParent();
            int index = parentNode.indexOf(srcNode);
            int h = ((ChildNodePart)sourcePart).getFigure().getPreferredSize().height;
            sourceOffset = (index + 1) * h;
            sourcePart = sourcePart.getParent();
        }
        if ((targetPart = relationshipPart.getTarget()) instanceof ChildNodePart) {
            ChildNode targetNode = (ChildNode)targetPart.getModel();
            RootNode parentNode = (RootNode)targetNode.getParent();
            int index = parentNode.indexOf(targetNode);
            int h = ((ChildNodePart)targetPart).getFigure().getPreferredSize().height;
            targetOffset = (index + 1) * h;
            targetPart = targetPart.getParent();
        }
        if (sourcePart == targetPart) {
            return;
        }
        Node source = (Node)this._partToNodesMap.get(sourcePart);
        Node target = (Node)this._partToNodesMap.get(targetPart);
        Edge e = new Edge((Object)relationshipPart, source, target);
        e.weight = 2;
        if (sourceOffset != -1) {
            e.setSourceOffset(sourceOffset);
        }
        if (targetOffset != -1) {
            e.setTargetOffset(targetOffset);
        }
        this._graph.edges.add((Object)e);
        this._partToNodesMap.put((AbstractGraphicalEditPart)relationshipPart, e);
    }

    protected void applyResults(NodeDiagramPart diagram) {
        this.applyChildrenResults(diagram);
    }

    protected void applyChildrenResults(NodeDiagramPart diagram) {
        List children = diagram.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object childPart = children.get(i);
            if (childPart instanceof RootNodePart) {
                this.applyResults((RootNodePart)((Object)childPart));
            }
            ++i;
        }
    }

    public void applyResults(RootNodePart rnPart) {
        NodeRelationshipPart relationship;
        Node n = (Node)this._partToNodesMap.get((Object)rnPart);
        IFigure rnFigure = rnPart.getFigure();
        Rectangle bounds = new Rectangle(n.x, n.y, n.width, n.height);
        rnFigure.setBounds(bounds);
        rnPart.updateConstraints();
        int i = 0;
        while (i < rnPart.getSourceConnections().size()) {
            relationship = (NodeRelationshipPart)((Object)rnPart.getSourceConnections().get(i));
            this.applyResults(relationship);
            ++i;
        }
        i = 0;
        while (i < rnPart.getChildrenSourceConnections().size()) {
            relationship = (NodeRelationshipPart)((Object)rnPart.getChildrenSourceConnections().get(i));
            this.applyResults(relationship);
            ++i;
        }
    }

    protected void applyResults(NodeRelationshipPart relationshipPart) {
        Edge e = (Edge)this._partToNodesMap.get((Object)relationshipPart);
        if (e == null) {
            return;
        }
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)relationshipPart.getConnectionFigure();
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                bends.add(new AbsoluteBendpoint(x, y));
                bends.add(new AbsoluteBendpoint(x + vn.width, y));
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else if (e.isFeedback() && conn.getTargetAnchor().getReferencePoint().x != 0) {
            ConnectionAnchor srcAnchor = conn.getSourceAnchor();
            ConnectionAnchor targetAnchor = conn.getTargetAnchor();
            if (srcAnchor instanceof RightAnchor && targetAnchor instanceof LeftAnchor) {
                conn.setSourceAnchor((ConnectionAnchor)new LeftAnchor(srcAnchor.getOwner()));
                conn.setTargetAnchor((ConnectionAnchor)new RightAnchor(targetAnchor.getOwner()));
            }
        }
    }
}

