/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.figures;

import oracle.eclipse.tools.common.ui.diagram.figures.INodeFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import oracle.eclipse.tools.common.ui.diagram.model.NodeRelationship;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import oracle.eclipse.tools.common.ui.diagram.routers.SplineConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;

public class NodeRelationshipFigure
extends PolylineConnection
implements INodeFigure {
    private NodeRelationshipPart relationPart;
    private boolean selected;
    PolygonDecoration targetDecoration;
    PolygonDecoration srcDecoration;

    public NodeRelationshipFigure(NodeRelationshipPart relationPart) {
        this.relationPart = relationPart;
        NodeRelationship relation = relationPart.getNodeRelaionship();
        this.setConnectionRouter(this.createConnectionRouter());
        this.targetDecoration = new SmoothPolygonDecoration();
        this.setTargetDecoration((RotatableDecoration)this.targetDecoration);
        if (relation.isBidirectional()) {
            this.srcDecoration = new SmoothPolygonDecoration();
            this.setSourceDecoration((RotatableDecoration)this.srcDecoration);
        }
        this.setForegroundColor(NodeDiagramStyleSheets.LINK_COLOR);
        if (relation.getTooltip() != null) {
            Label tooltip = new Label(relation.getTooltip());
            tooltip.setBorder(TOOL_TIP_BORDER);
            this.setToolTip((IFigure)tooltip);
        }
        this.createLinkLabels();
        this.addListeners();
    }

    protected ConnectionRouter createConnectionRouter() {
        return new SplineConnectionRouter();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setFocus(boolean b) {
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
        if (this.selected) {
            this.setLineWidth(2);
        } else {
            this.setLineWidth(1);
        }
    }

    public void setMouseOver(boolean mouseOver) {
        if (mouseOver) {
            this.setLineWidth(2);
            this.setForegroundColor(NodeDiagramStyleSheets.LINK_MOUSE_OVER_COLOR);
        } else {
            this.setForegroundColor(NodeDiagramStyleSheets.LINK_COLOR);
            this.setSelected(this.selected);
        }
    }

    private void createLinkLabels() {
        NodeRelationship relation = this.relationPart.getNodeRelaionship();
        if (relation.getSrcLabel() != null) {
            ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator((Connection)this, false);
            sourceEndpointLocator.setUDistance(10);
            Label sourceMultiplicityLabel = new Label(relation.getSrcLabel());
            this.add((IFigure)sourceMultiplicityLabel, sourceEndpointLocator);
        }
        if (relation.getTargetLabel() != null) {
            ConnectionEndpointLocator targetEndpointLocator = new ConnectionEndpointLocator((Connection)this, true);
            targetEndpointLocator.setUDistance(10);
            Label targetMultiplicityLabel = new Label(relation.getTargetLabel());
            this.add((IFigure)targetMultiplicityLabel, targetEndpointLocator);
        }
    }

    private void addListeners() {
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                NodeRelationshipFigure.this.setMouseOver(true);
            }

            public void mouseExited(MouseEvent me) {
                NodeRelationshipFigure.this.setMouseOver(false);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    public NodeRelationshipPart getRelationshipPart() {
        return this.relationPart;
    }

    public class SmoothPolygonDecoration
    extends PolygonDecoration {
        public void paintFigure(Graphics graphics) {
            int savedAntialias = graphics.getAntialias();
            graphics.setAntialias(1);
            super.paintFigure(graphics);
            graphics.setAntialias(savedAntialias);
        }
    }
}

