/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class For
extends stmtType {
    public exprType target;
    public exprType iter;
    public stmtType[] body;
    public stmtType[] orelse;

    public For(exprType target, exprType iter, stmtType[] body, stmtType[] orelse) {
        this.target = target;
        this.iter = iter;
        this.body = body;
        this.orelse = orelse;
    }

    public For(exprType target, exprType iter, stmtType[] body, stmtType[] orelse, SimpleNode parent) {
        this(target, iter, body, orelse);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("For[");
        sb.append("target=");
        sb.append(this.dumpThis(this.target));
        sb.append(", ");
        sb.append("iter=");
        sb.append(this.dumpThis(this.iter));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("orelse=");
        sb.append(this.dumpThis(this.orelse));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(13, ostream);
        this.pickleThis(this.target, ostream);
        this.pickleThis(this.iter, ostream);
        this.pickleThis(this.body, ostream);
        this.pickleThis(this.orelse, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFor(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.target != null) {
            this.target.accept(visitor);
        }
        if (this.iter != null) {
            this.iter.accept(visitor);
        }
        if (this.body != null) {
            i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.orelse != null) {
            i = 0;
            while (i < this.orelse.length) {
                if (this.orelse[i] != null) {
                    this.orelse[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

