/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class ClassDef
extends stmtType {
    public String name;
    public exprType[] bases;
    public stmtType[] body;

    public ClassDef(String name, exprType[] bases, stmtType[] body) {
        this.name = name;
        this.bases = bases;
        this.body = body;
    }

    public ClassDef(String name, exprType[] bases, stmtType[] body, SimpleNode parent) {
        this(name, bases, body);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClassDef[");
        sb.append("name=");
        sb.append(this.dumpThis(this.name));
        sb.append(", ");
        sb.append("bases=");
        sb.append(this.dumpThis(this.bases));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(6, ostream);
        this.pickleThis(this.name, ostream);
        this.pickleThis(this.bases, ostream);
        this.pickleThis(this.body, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitClassDef(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.bases != null) {
            i = 0;
            while (i < this.bases.length) {
                if (this.bases[i] != null) {
                    this.bases[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.body != null) {
            i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

