/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class binascii {
    public static String __doc__ = "Conversion between binary data and ASCII";
    public static final PyString Error = new PyString("binascii.Error");
    public static final PyString Incomplete = new PyString("binascii.Incomplete");
    private static char RUNCHAR = (char)144;
    private static short DONE = (short)127;
    private static short SKIP = (short)126;
    private static short FAIL = (short)125;
    private static short[] table_a2b_hqx;
    private static byte[] table_b2a_hqx;
    private static short[] table_a2b_base64;
    private static char BASE64_PAD;
    private static int BASE64_MAXBIN;
    private static byte[] table_b2a_base64;
    private static int[] crctab_hqx;
    public static PyString __doc__a2b_uu;
    public static PyString __doc__b2a_uu;
    public static PyString __doc__a2b_base64;
    public static PyString __doc__b2a_base64;
    public static PyString __doc__a2b_hqx;
    public static PyString __doc__rlecode_hqx;
    public static PyString __doc__b2a_hqx;
    public static PyString __doc__rledecode_hqx;
    public static PyString __doc__crc_hqx;
    static long[] crc_32_tab;
    private static char[] hexdigit;
    public static PyString __doc__b2a_hex;
    public static PyString a2b_hex$doc;

    static {
        short[] sArray = new short[256];
        sArray[0] = FAIL;
        sArray[1] = FAIL;
        sArray[2] = FAIL;
        sArray[3] = FAIL;
        sArray[4] = FAIL;
        sArray[5] = FAIL;
        sArray[6] = FAIL;
        sArray[7] = FAIL;
        sArray[8] = FAIL;
        sArray[9] = FAIL;
        sArray[10] = SKIP;
        sArray[11] = FAIL;
        sArray[12] = FAIL;
        sArray[13] = SKIP;
        sArray[14] = FAIL;
        sArray[15] = FAIL;
        sArray[16] = FAIL;
        sArray[17] = FAIL;
        sArray[18] = FAIL;
        sArray[19] = FAIL;
        sArray[20] = FAIL;
        sArray[21] = FAIL;
        sArray[22] = FAIL;
        sArray[23] = FAIL;
        sArray[24] = FAIL;
        sArray[25] = FAIL;
        sArray[26] = FAIL;
        sArray[27] = FAIL;
        sArray[28] = FAIL;
        sArray[29] = FAIL;
        sArray[30] = FAIL;
        sArray[31] = FAIL;
        sArray[32] = FAIL;
        sArray[34] = 1;
        sArray[35] = 2;
        sArray[36] = 3;
        sArray[37] = 4;
        sArray[38] = 5;
        sArray[39] = 6;
        sArray[40] = 7;
        sArray[41] = 8;
        sArray[42] = 9;
        sArray[43] = 10;
        sArray[44] = 11;
        sArray[45] = 12;
        sArray[46] = FAIL;
        sArray[47] = FAIL;
        sArray[48] = 13;
        sArray[49] = 14;
        sArray[50] = 15;
        sArray[51] = 16;
        sArray[52] = 17;
        sArray[53] = 18;
        sArray[54] = 19;
        sArray[55] = FAIL;
        sArray[56] = 20;
        sArray[57] = 21;
        sArray[58] = DONE;
        sArray[59] = FAIL;
        sArray[60] = FAIL;
        sArray[61] = FAIL;
        sArray[62] = FAIL;
        sArray[63] = FAIL;
        sArray[64] = 22;
        sArray[65] = 23;
        sArray[66] = 24;
        sArray[67] = 25;
        sArray[68] = 26;
        sArray[69] = 27;
        sArray[70] = 28;
        sArray[71] = 29;
        sArray[72] = 30;
        sArray[73] = 31;
        sArray[74] = 32;
        sArray[75] = 33;
        sArray[76] = 34;
        sArray[77] = 35;
        sArray[78] = 36;
        sArray[79] = FAIL;
        sArray[80] = 37;
        sArray[81] = 38;
        sArray[82] = 39;
        sArray[83] = 40;
        sArray[84] = 41;
        sArray[85] = 42;
        sArray[86] = 43;
        sArray[87] = FAIL;
        sArray[88] = 44;
        sArray[89] = 45;
        sArray[90] = 46;
        sArray[91] = 47;
        sArray[92] = FAIL;
        sArray[93] = FAIL;
        sArray[94] = FAIL;
        sArray[95] = FAIL;
        sArray[96] = 48;
        sArray[97] = 49;
        sArray[98] = 50;
        sArray[99] = 51;
        sArray[100] = 52;
        sArray[101] = 53;
        sArray[102] = 54;
        sArray[103] = FAIL;
        sArray[104] = 55;
        sArray[105] = 56;
        sArray[106] = 57;
        sArray[107] = 58;
        sArray[108] = 59;
        sArray[109] = 60;
        sArray[110] = FAIL;
        sArray[111] = FAIL;
        sArray[112] = 61;
        sArray[113] = 62;
        sArray[114] = 63;
        sArray[115] = FAIL;
        sArray[116] = FAIL;
        sArray[117] = FAIL;
        sArray[118] = FAIL;
        sArray[119] = FAIL;
        sArray[120] = FAIL;
        sArray[121] = FAIL;
        sArray[122] = FAIL;
        sArray[123] = FAIL;
        sArray[124] = FAIL;
        sArray[125] = FAIL;
        sArray[126] = FAIL;
        sArray[127] = FAIL;
        sArray[128] = FAIL;
        sArray[129] = FAIL;
        sArray[130] = FAIL;
        sArray[131] = FAIL;
        sArray[132] = FAIL;
        sArray[133] = FAIL;
        sArray[134] = FAIL;
        sArray[135] = FAIL;
        sArray[136] = FAIL;
        sArray[137] = FAIL;
        sArray[138] = FAIL;
        sArray[139] = FAIL;
        sArray[140] = FAIL;
        sArray[141] = FAIL;
        sArray[142] = FAIL;
        sArray[143] = FAIL;
        sArray[144] = FAIL;
        sArray[145] = FAIL;
        sArray[146] = FAIL;
        sArray[147] = FAIL;
        sArray[148] = FAIL;
        sArray[149] = FAIL;
        sArray[150] = FAIL;
        sArray[151] = FAIL;
        sArray[152] = FAIL;
        sArray[153] = FAIL;
        sArray[154] = FAIL;
        sArray[155] = FAIL;
        sArray[156] = FAIL;
        sArray[157] = FAIL;
        sArray[158] = FAIL;
        sArray[159] = FAIL;
        sArray[160] = FAIL;
        sArray[161] = FAIL;
        sArray[162] = FAIL;
        sArray[163] = FAIL;
        sArray[164] = FAIL;
        sArray[165] = FAIL;
        sArray[166] = FAIL;
        sArray[167] = FAIL;
        sArray[168] = FAIL;
        sArray[169] = FAIL;
        sArray[170] = FAIL;
        sArray[171] = FAIL;
        sArray[172] = FAIL;
        sArray[173] = FAIL;
        sArray[174] = FAIL;
        sArray[175] = FAIL;
        sArray[176] = FAIL;
        sArray[177] = FAIL;
        sArray[178] = FAIL;
        sArray[179] = FAIL;
        sArray[180] = FAIL;
        sArray[181] = FAIL;
        sArray[182] = FAIL;
        sArray[183] = FAIL;
        sArray[184] = FAIL;
        sArray[185] = FAIL;
        sArray[186] = FAIL;
        sArray[187] = FAIL;
        sArray[188] = FAIL;
        sArray[189] = FAIL;
        sArray[190] = FAIL;
        sArray[191] = FAIL;
        sArray[192] = FAIL;
        sArray[193] = FAIL;
        sArray[194] = FAIL;
        sArray[195] = FAIL;
        sArray[196] = FAIL;
        sArray[197] = FAIL;
        sArray[198] = FAIL;
        sArray[199] = FAIL;
        sArray[200] = FAIL;
        sArray[201] = FAIL;
        sArray[202] = FAIL;
        sArray[203] = FAIL;
        sArray[204] = FAIL;
        sArray[205] = FAIL;
        sArray[206] = FAIL;
        sArray[207] = FAIL;
        sArray[208] = FAIL;
        sArray[209] = FAIL;
        sArray[210] = FAIL;
        sArray[211] = FAIL;
        sArray[212] = FAIL;
        sArray[213] = FAIL;
        sArray[214] = FAIL;
        sArray[215] = FAIL;
        sArray[216] = FAIL;
        sArray[217] = FAIL;
        sArray[218] = FAIL;
        sArray[219] = FAIL;
        sArray[220] = FAIL;
        sArray[221] = FAIL;
        sArray[222] = FAIL;
        sArray[223] = FAIL;
        sArray[224] = FAIL;
        sArray[225] = FAIL;
        sArray[226] = FAIL;
        sArray[227] = FAIL;
        sArray[228] = FAIL;
        sArray[229] = FAIL;
        sArray[230] = FAIL;
        sArray[231] = FAIL;
        sArray[232] = FAIL;
        sArray[233] = FAIL;
        sArray[234] = FAIL;
        sArray[235] = FAIL;
        sArray[236] = FAIL;
        sArray[237] = FAIL;
        sArray[238] = FAIL;
        sArray[239] = FAIL;
        sArray[240] = FAIL;
        sArray[241] = FAIL;
        sArray[242] = FAIL;
        sArray[243] = FAIL;
        sArray[244] = FAIL;
        sArray[245] = FAIL;
        sArray[246] = FAIL;
        sArray[247] = FAIL;
        sArray[248] = FAIL;
        sArray[249] = FAIL;
        sArray[250] = FAIL;
        sArray[251] = FAIL;
        sArray[252] = FAIL;
        sArray[253] = FAIL;
        sArray[254] = FAIL;
        sArray[255] = FAIL;
        table_a2b_hqx = sArray;
        table_b2a_hqx = PyString.to_bytes("!\"#$%&'()*+,-012345689@ABCDEFGHIJKLMNPQRSTUVXYZ[`abcdefhijklmpqr");
        short[] sArray2 = new short[128];
        sArray2[0] = -1;
        sArray2[1] = -1;
        sArray2[2] = -1;
        sArray2[3] = -1;
        sArray2[4] = -1;
        sArray2[5] = -1;
        sArray2[6] = -1;
        sArray2[7] = -1;
        sArray2[8] = -1;
        sArray2[9] = -1;
        sArray2[10] = -1;
        sArray2[11] = -1;
        sArray2[12] = -1;
        sArray2[13] = -1;
        sArray2[14] = -1;
        sArray2[15] = -1;
        sArray2[16] = -1;
        sArray2[17] = -1;
        sArray2[18] = -1;
        sArray2[19] = -1;
        sArray2[20] = -1;
        sArray2[21] = -1;
        sArray2[22] = -1;
        sArray2[23] = -1;
        sArray2[24] = -1;
        sArray2[25] = -1;
        sArray2[26] = -1;
        sArray2[27] = -1;
        sArray2[28] = -1;
        sArray2[29] = -1;
        sArray2[30] = -1;
        sArray2[31] = -1;
        sArray2[32] = -1;
        sArray2[33] = -1;
        sArray2[34] = -1;
        sArray2[35] = -1;
        sArray2[36] = -1;
        sArray2[37] = -1;
        sArray2[38] = -1;
        sArray2[39] = -1;
        sArray2[40] = -1;
        sArray2[41] = -1;
        sArray2[42] = -1;
        sArray2[43] = 62;
        sArray2[44] = -1;
        sArray2[45] = -1;
        sArray2[46] = -1;
        sArray2[47] = 63;
        sArray2[48] = 52;
        sArray2[49] = 53;
        sArray2[50] = 54;
        sArray2[51] = 55;
        sArray2[52] = 56;
        sArray2[53] = 57;
        sArray2[54] = 58;
        sArray2[55] = 59;
        sArray2[56] = 60;
        sArray2[57] = 61;
        sArray2[58] = -1;
        sArray2[59] = -1;
        sArray2[60] = -1;
        sArray2[62] = -1;
        sArray2[63] = -1;
        sArray2[64] = -1;
        sArray2[66] = 1;
        sArray2[67] = 2;
        sArray2[68] = 3;
        sArray2[69] = 4;
        sArray2[70] = 5;
        sArray2[71] = 6;
        sArray2[72] = 7;
        sArray2[73] = 8;
        sArray2[74] = 9;
        sArray2[75] = 10;
        sArray2[76] = 11;
        sArray2[77] = 12;
        sArray2[78] = 13;
        sArray2[79] = 14;
        sArray2[80] = 15;
        sArray2[81] = 16;
        sArray2[82] = 17;
        sArray2[83] = 18;
        sArray2[84] = 19;
        sArray2[85] = 20;
        sArray2[86] = 21;
        sArray2[87] = 22;
        sArray2[88] = 23;
        sArray2[89] = 24;
        sArray2[90] = 25;
        sArray2[91] = -1;
        sArray2[92] = -1;
        sArray2[93] = -1;
        sArray2[94] = -1;
        sArray2[95] = -1;
        sArray2[96] = -1;
        sArray2[97] = 26;
        sArray2[98] = 27;
        sArray2[99] = 28;
        sArray2[100] = 29;
        sArray2[101] = 30;
        sArray2[102] = 31;
        sArray2[103] = 32;
        sArray2[104] = 33;
        sArray2[105] = 34;
        sArray2[106] = 35;
        sArray2[107] = 36;
        sArray2[108] = 37;
        sArray2[109] = 38;
        sArray2[110] = 39;
        sArray2[111] = 40;
        sArray2[112] = 41;
        sArray2[113] = 42;
        sArray2[114] = 43;
        sArray2[115] = 44;
        sArray2[116] = 45;
        sArray2[117] = 46;
        sArray2[118] = 47;
        sArray2[119] = 48;
        sArray2[120] = 49;
        sArray2[121] = 50;
        sArray2[122] = 51;
        sArray2[123] = -1;
        sArray2[124] = -1;
        sArray2[125] = -1;
        sArray2[126] = -1;
        sArray2[127] = -1;
        table_a2b_base64 = sArray2;
        BASE64_PAD = (char)61;
        BASE64_MAXBIN = 57;
        table_b2a_base64 = PyString.to_bytes("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        int[] nArray = new int[256];
        nArray[1] = 4129;
        nArray[2] = 8258;
        nArray[3] = 12387;
        nArray[4] = 16516;
        nArray[5] = 20645;
        nArray[6] = 24774;
        nArray[7] = 28903;
        nArray[8] = 33032;
        nArray[9] = 37161;
        nArray[10] = 41290;
        nArray[11] = 45419;
        nArray[12] = 49548;
        nArray[13] = 53677;
        nArray[14] = 57806;
        nArray[15] = 61935;
        nArray[16] = 4657;
        nArray[17] = 528;
        nArray[18] = 12915;
        nArray[19] = 8786;
        nArray[20] = 21173;
        nArray[21] = 17044;
        nArray[22] = 29431;
        nArray[23] = 25302;
        nArray[24] = 37689;
        nArray[25] = 33560;
        nArray[26] = 45947;
        nArray[27] = 41818;
        nArray[28] = 54205;
        nArray[29] = 50076;
        nArray[30] = 62463;
        nArray[31] = 58334;
        nArray[32] = 9314;
        nArray[33] = 13379;
        nArray[34] = 1056;
        nArray[35] = 5121;
        nArray[36] = 25830;
        nArray[37] = 29895;
        nArray[38] = 17572;
        nArray[39] = 21637;
        nArray[40] = 42346;
        nArray[41] = 46411;
        nArray[42] = 34088;
        nArray[43] = 38153;
        nArray[44] = 58862;
        nArray[45] = 62927;
        nArray[46] = 50604;
        nArray[47] = 54669;
        nArray[48] = 13907;
        nArray[49] = 9842;
        nArray[50] = 5649;
        nArray[51] = 1584;
        nArray[52] = 30423;
        nArray[53] = 26358;
        nArray[54] = 22165;
        nArray[55] = 18100;
        nArray[56] = 46939;
        nArray[57] = 42874;
        nArray[58] = 38681;
        nArray[59] = 34616;
        nArray[60] = 63455;
        nArray[61] = 59390;
        nArray[62] = 55197;
        nArray[63] = 51132;
        nArray[64] = 18628;
        nArray[65] = 22757;
        nArray[66] = 26758;
        nArray[67] = 30887;
        nArray[68] = 2112;
        nArray[69] = 6241;
        nArray[70] = 10242;
        nArray[71] = 14371;
        nArray[72] = 51660;
        nArray[73] = 55789;
        nArray[74] = 59790;
        nArray[75] = 63919;
        nArray[76] = 35144;
        nArray[77] = 39273;
        nArray[78] = 43274;
        nArray[79] = 47403;
        nArray[80] = 23285;
        nArray[81] = 19156;
        nArray[82] = 31415;
        nArray[83] = 27286;
        nArray[84] = 6769;
        nArray[85] = 2640;
        nArray[86] = 14899;
        nArray[87] = 10770;
        nArray[88] = 56317;
        nArray[89] = 52188;
        nArray[90] = 64447;
        nArray[91] = 60318;
        nArray[92] = 39801;
        nArray[93] = 35672;
        nArray[94] = 47931;
        nArray[95] = 43802;
        nArray[96] = 27814;
        nArray[97] = 31879;
        nArray[98] = 19684;
        nArray[99] = 23749;
        nArray[100] = 11298;
        nArray[101] = 15363;
        nArray[102] = 3168;
        nArray[103] = 7233;
        nArray[104] = 60846;
        nArray[105] = 64911;
        nArray[106] = 52716;
        nArray[107] = 56781;
        nArray[108] = 44330;
        nArray[109] = 48395;
        nArray[110] = 36200;
        nArray[111] = 40265;
        nArray[112] = 32407;
        nArray[113] = 28342;
        nArray[114] = 24277;
        nArray[115] = 20212;
        nArray[116] = 15891;
        nArray[117] = 11826;
        nArray[118] = 7761;
        nArray[119] = 3696;
        nArray[120] = 65439;
        nArray[121] = 61374;
        nArray[122] = 57309;
        nArray[123] = 53244;
        nArray[124] = 48923;
        nArray[125] = 44858;
        nArray[126] = 40793;
        nArray[127] = 36728;
        nArray[128] = 37256;
        nArray[129] = 33193;
        nArray[130] = 45514;
        nArray[131] = 41451;
        nArray[132] = 53516;
        nArray[133] = 49453;
        nArray[134] = 61774;
        nArray[135] = 57711;
        nArray[136] = 4224;
        nArray[137] = 161;
        nArray[138] = 12482;
        nArray[139] = 8419;
        nArray[140] = 20484;
        nArray[141] = 16421;
        nArray[142] = 28742;
        nArray[143] = 24679;
        nArray[144] = 33721;
        nArray[145] = 37784;
        nArray[146] = 41979;
        nArray[147] = 46042;
        nArray[148] = 49981;
        nArray[149] = 54044;
        nArray[150] = 58239;
        nArray[151] = 62302;
        nArray[152] = 689;
        nArray[153] = 4752;
        nArray[154] = 8947;
        nArray[155] = 13010;
        nArray[156] = 16949;
        nArray[157] = 21012;
        nArray[158] = 25207;
        nArray[159] = 29270;
        nArray[160] = 46570;
        nArray[161] = 42443;
        nArray[162] = 38312;
        nArray[163] = 34185;
        nArray[164] = 62830;
        nArray[165] = 58703;
        nArray[166] = 54572;
        nArray[167] = 50445;
        nArray[168] = 13538;
        nArray[169] = 9411;
        nArray[170] = 5280;
        nArray[171] = 1153;
        nArray[172] = 29798;
        nArray[173] = 25671;
        nArray[174] = 21540;
        nArray[175] = 17413;
        nArray[176] = 42971;
        nArray[177] = 47098;
        nArray[178] = 34713;
        nArray[179] = 38840;
        nArray[180] = 59231;
        nArray[181] = 63358;
        nArray[182] = 50973;
        nArray[183] = 55100;
        nArray[184] = 9939;
        nArray[185] = 14066;
        nArray[186] = 1681;
        nArray[187] = 5808;
        nArray[188] = 26199;
        nArray[189] = 30326;
        nArray[190] = 17941;
        nArray[191] = 22068;
        nArray[192] = 55628;
        nArray[193] = 51565;
        nArray[194] = 63758;
        nArray[195] = 59695;
        nArray[196] = 39368;
        nArray[197] = 35305;
        nArray[198] = 47498;
        nArray[199] = 43435;
        nArray[200] = 22596;
        nArray[201] = 18533;
        nArray[202] = 30726;
        nArray[203] = 26663;
        nArray[204] = 6336;
        nArray[205] = 2273;
        nArray[206] = 14466;
        nArray[207] = 10403;
        nArray[208] = 52093;
        nArray[209] = 56156;
        nArray[210] = 60223;
        nArray[211] = 64286;
        nArray[212] = 35833;
        nArray[213] = 39896;
        nArray[214] = 43963;
        nArray[215] = 48026;
        nArray[216] = 19061;
        nArray[217] = 23124;
        nArray[218] = 27191;
        nArray[219] = 31254;
        nArray[220] = 2801;
        nArray[221] = 6864;
        nArray[222] = 10931;
        nArray[223] = 14994;
        nArray[224] = 64814;
        nArray[225] = 60687;
        nArray[226] = 56684;
        nArray[227] = 52557;
        nArray[228] = 48554;
        nArray[229] = 44427;
        nArray[230] = 40424;
        nArray[231] = 36297;
        nArray[232] = 31782;
        nArray[233] = 27655;
        nArray[234] = 23652;
        nArray[235] = 19525;
        nArray[236] = 15522;
        nArray[237] = 11395;
        nArray[238] = 7392;
        nArray[239] = 3265;
        nArray[240] = 61215;
        nArray[241] = 65342;
        nArray[242] = 53085;
        nArray[243] = 57212;
        nArray[244] = 44955;
        nArray[245] = 49082;
        nArray[246] = 36825;
        nArray[247] = 40952;
        nArray[248] = 28183;
        nArray[249] = 32310;
        nArray[250] = 20053;
        nArray[251] = 24180;
        nArray[252] = 11923;
        nArray[253] = 16050;
        nArray[254] = 3793;
        nArray[255] = 7920;
        crctab_hqx = nArray;
        __doc__a2b_uu = new PyString("(ascii) -> bin. Decode a line of uuencoded data");
        __doc__b2a_uu = new PyString("(bin) -> ascii. Uuencode line of data");
        __doc__a2b_base64 = new PyString("(ascii) -> bin. Decode a line of base64 data");
        __doc__b2a_base64 = new PyString("(bin) -> ascii. Base64-code line of data");
        __doc__a2b_hqx = new PyString("ascii -> bin, done. Decode .hqx coding");
        __doc__rlecode_hqx = new PyString("Binhex RLE-code binary data");
        __doc__b2a_hqx = new PyString("Encode .hqx data");
        __doc__rledecode_hqx = new PyString("Decode hexbin RLE-coded string");
        __doc__crc_hqx = new PyString("(data, oldcrc) -> newcrc. Compute hqx CRC incrementally");
        long[] lArray = new long[256];
        lArray[1] = 1996959894L;
        lArray[2] = 3993919788L;
        lArray[3] = 2567524794L;
        lArray[4] = 124634137L;
        lArray[5] = 1886057615L;
        lArray[6] = 3915621685L;
        lArray[7] = 2657392035L;
        lArray[8] = 249268274L;
        lArray[9] = 2044508324L;
        lArray[10] = 3772115230L;
        lArray[11] = 2547177864L;
        lArray[12] = 162941995L;
        lArray[13] = 2125561021L;
        lArray[14] = 3887607047L;
        lArray[15] = 2428444049L;
        lArray[16] = 498536548L;
        lArray[17] = 1789927666L;
        lArray[18] = 4089016648L;
        lArray[19] = 2227061214L;
        lArray[20] = 450548861L;
        lArray[21] = 1843258603L;
        lArray[22] = 4107580753L;
        lArray[23] = 2211677639L;
        lArray[24] = 325883990L;
        lArray[25] = 1684777152L;
        lArray[26] = 4251122042L;
        lArray[27] = 2321926636L;
        lArray[28] = 335633487L;
        lArray[29] = 1661365465L;
        lArray[30] = 4195302755L;
        lArray[31] = 2366115317L;
        lArray[32] = 997073096L;
        lArray[33] = 1281953886L;
        lArray[34] = 3579855332L;
        lArray[35] = 2724688242L;
        lArray[36] = 1006888145L;
        lArray[37] = 1258607687L;
        lArray[38] = 3524101629L;
        lArray[39] = 2768942443L;
        lArray[40] = 901097722L;
        lArray[41] = 1119000684L;
        lArray[42] = 3686517206L;
        lArray[43] = 2898065728L;
        lArray[44] = 853044451L;
        lArray[45] = 1172266101L;
        lArray[46] = 3705015759L;
        lArray[47] = 2882616665L;
        lArray[48] = 651767980L;
        lArray[49] = 1373503546L;
        lArray[50] = 3369554304L;
        lArray[51] = 3218104598L;
        lArray[52] = 565507253L;
        lArray[53] = 1454621731L;
        lArray[54] = 3485111705L;
        lArray[55] = 3099436303L;
        lArray[56] = 671266974L;
        lArray[57] = 1594198024L;
        lArray[58] = 3322730930L;
        lArray[59] = 2970347812L;
        lArray[60] = 795835527L;
        lArray[61] = 1483230225L;
        lArray[62] = 3244367275L;
        lArray[63] = 3060149565L;
        lArray[64] = 1994146192L;
        lArray[65] = 31158534L;
        lArray[66] = 2563907772L;
        lArray[67] = 4023717930L;
        lArray[68] = 1907459465L;
        lArray[69] = 112637215L;
        lArray[70] = 2680153253L;
        lArray[71] = 3904427059L;
        lArray[72] = 2013776290L;
        lArray[73] = 251722036L;
        lArray[74] = 2517215374L;
        lArray[75] = 3775830040L;
        lArray[76] = 2137656763L;
        lArray[77] = 141376813L;
        lArray[78] = 2439277719L;
        lArray[79] = 3865271297L;
        lArray[80] = 1802195444L;
        lArray[81] = 476864866L;
        lArray[82] = 2238001368L;
        lArray[83] = 4066508878L;
        lArray[84] = 1812370925L;
        lArray[85] = 453092731L;
        lArray[86] = 2181625025L;
        lArray[87] = 4111451223L;
        lArray[88] = 1706088902L;
        lArray[89] = 314042704L;
        lArray[90] = 2344532202L;
        lArray[91] = 4240017532L;
        lArray[92] = 1658658271L;
        lArray[93] = 366619977L;
        lArray[94] = 2362670323L;
        lArray[95] = 4224994405L;
        lArray[96] = 1303535960L;
        lArray[97] = 984961486L;
        lArray[98] = 2747007092L;
        lArray[99] = 3569037538L;
        lArray[100] = 1256170817L;
        lArray[101] = 1037604311L;
        lArray[102] = 2765210733L;
        lArray[103] = 3554079995L;
        lArray[104] = 1131014506L;
        lArray[105] = 879679996L;
        lArray[106] = 2909243462L;
        lArray[107] = 3663771856L;
        lArray[108] = 1141124467L;
        lArray[109] = 855842277L;
        lArray[110] = 2852801631L;
        lArray[111] = 3708648649L;
        lArray[112] = 1342533948L;
        lArray[113] = 654459306L;
        lArray[114] = 3188396048L;
        lArray[115] = 3373015174L;
        lArray[116] = 1466479909L;
        lArray[117] = 544179635L;
        lArray[118] = 3110523913L;
        lArray[119] = 3462522015L;
        lArray[120] = 1591671054L;
        lArray[121] = 702138776L;
        lArray[122] = 2966460450L;
        lArray[123] = 3352799412L;
        lArray[124] = 1504918807L;
        lArray[125] = 783551873L;
        lArray[126] = 3082640443L;
        lArray[127] = 3233442989L;
        lArray[128] = 3988292384L;
        lArray[129] = 2596254646L;
        lArray[130] = 62317068L;
        lArray[131] = 1957810842L;
        lArray[132] = 3939845945L;
        lArray[133] = 2647816111L;
        lArray[134] = 81470997L;
        lArray[135] = 1943803523L;
        lArray[136] = 3814918930L;
        lArray[137] = 2489596804L;
        lArray[138] = 225274430L;
        lArray[139] = 2053790376L;
        lArray[140] = 3826175755L;
        lArray[141] = 2466906013L;
        lArray[142] = 167816743L;
        lArray[143] = 2097651377L;
        lArray[144] = 4027552580L;
        lArray[145] = 2265490386L;
        lArray[146] = 503444072L;
        lArray[147] = 1762050814L;
        lArray[148] = 4150417245L;
        lArray[149] = 2154129355L;
        lArray[150] = 426522225L;
        lArray[151] = 1852507879L;
        lArray[152] = 4275313526L;
        lArray[153] = 2312317920L;
        lArray[154] = 282753626L;
        lArray[155] = 1742555852L;
        lArray[156] = 4189708143L;
        lArray[157] = 2394877945L;
        lArray[158] = 397917763L;
        lArray[159] = 1622183637L;
        lArray[160] = 3604390888L;
        lArray[161] = 2714866558L;
        lArray[162] = 953729732L;
        lArray[163] = 1340076626L;
        lArray[164] = 3518719985L;
        lArray[165] = 2797360999L;
        lArray[166] = 1068828381L;
        lArray[167] = 1219638859L;
        lArray[168] = 3624741850L;
        lArray[169] = 2936675148L;
        lArray[170] = 906185462L;
        lArray[171] = 1090812512L;
        lArray[172] = 3747672003L;
        lArray[173] = 2825379669L;
        lArray[174] = 829329135L;
        lArray[175] = 1181335161L;
        lArray[176] = 3412177804L;
        lArray[177] = 3160834842L;
        lArray[178] = 628085408L;
        lArray[179] = 1382605366L;
        lArray[180] = 3423369109L;
        lArray[181] = 3138078467L;
        lArray[182] = 570562233L;
        lArray[183] = 1426400815L;
        lArray[184] = 3317316542L;
        lArray[185] = 2998733608L;
        lArray[186] = 733239954L;
        lArray[187] = 1555261956L;
        lArray[188] = 3268935591L;
        lArray[189] = 3050360625L;
        lArray[190] = 752459403L;
        lArray[191] = 1541320221L;
        lArray[192] = 2607071920L;
        lArray[193] = 3965973030L;
        lArray[194] = 1969922972L;
        lArray[195] = 40735498L;
        lArray[196] = 2617837225L;
        lArray[197] = 3943577151L;
        lArray[198] = 1913087877L;
        lArray[199] = 83908371L;
        lArray[200] = 2512341634L;
        lArray[201] = 3803740692L;
        lArray[202] = 2075208622L;
        lArray[203] = 213261112L;
        lArray[204] = 2463272603L;
        lArray[205] = 3855990285L;
        lArray[206] = 2094854071L;
        lArray[207] = 198958881L;
        lArray[208] = 2262029012L;
        lArray[209] = 4057260610L;
        lArray[210] = 1759359992L;
        lArray[211] = 534414190L;
        lArray[212] = 2176718541L;
        lArray[213] = 4139329115L;
        lArray[214] = 1873836001L;
        lArray[215] = 414664567L;
        lArray[216] = 2282248934L;
        lArray[217] = 4279200368L;
        lArray[218] = 1711684554L;
        lArray[219] = 285281116L;
        lArray[220] = 2405801727L;
        lArray[221] = 4167216745L;
        lArray[222] = 1634467795L;
        lArray[223] = 376229701L;
        lArray[224] = 2685067896L;
        lArray[225] = 3608007406L;
        lArray[226] = 1308918612L;
        lArray[227] = 956543938L;
        lArray[228] = 2808555105L;
        lArray[229] = 3495958263L;
        lArray[230] = 1231636301L;
        lArray[231] = 1047427035L;
        lArray[232] = 2932959818L;
        lArray[233] = 3654703836L;
        lArray[234] = 1088359270L;
        lArray[235] = 936918000L;
        lArray[236] = 2847714899L;
        lArray[237] = 3736837829L;
        lArray[238] = 1202900863L;
        lArray[239] = 817233897L;
        lArray[240] = 3183342108L;
        lArray[241] = 3401237130L;
        lArray[242] = 1404277552L;
        lArray[243] = 615818150L;
        lArray[244] = 3134207493L;
        lArray[245] = 3453421203L;
        lArray[246] = 1423857449L;
        lArray[247] = 601450431L;
        lArray[248] = 3009837614L;
        lArray[249] = 3294710456L;
        lArray[250] = 1567103746L;
        lArray[251] = 711928724L;
        lArray[252] = 3020668471L;
        lArray[253] = 3272380065L;
        lArray[254] = 1510334235L;
        lArray[255] = 755167117L;
        crc_32_tab = lArray;
        hexdigit = "0123456789abcdef".toCharArray();
        __doc__b2a_hex = new PyString("b2a_hex(data) -> s; Hexadecimal representation of binary data.\n\nThis function is also available as \"hexlify()\".");
        a2b_hex$doc = new PyString("a2b_hex(hexstr) -> s; Binary data of hexadecimal representation.\n\nhexstr must contain an even number of hex digits (upper or lower case).\nThis function is also available as \"unhexlify()\"");
    }

    public static String a2b_uu(String ascii_data) {
        char this_ch;
        int leftbits = 0;
        int leftchar = 0;
        StringBuffer bin_data = new StringBuffer();
        int ascii_len = ascii_data.length() - 1;
        int bin_len = ascii_data.charAt(0) - 32 & 0x3F;
        int i = 0;
        while (bin_len > 0) {
            this_ch = ascii_data.charAt(i + 1);
            if (this_ch == '\n' || this_ch == '\r' || ascii_len <= 0) {
                this_ch = '\u0000';
            } else {
                if (this_ch < ' ' || this_ch > '`') {
                    throw new PyException((PyObject)Error, "Illegal char");
                }
                this_ch = (char)(this_ch - 32 & 0x3F);
            }
            leftchar = leftchar << 6 | this_ch;
            if ((leftbits += 6) >= 8) {
                bin_data.append((char)(leftchar >> (leftbits -= 8) & 0xFF));
                leftchar &= (1 << leftbits) - 1;
                --bin_len;
            }
            ++i;
            --ascii_len;
        }
        while (ascii_len-- > 0) {
            if ((this_ch = ascii_data.charAt(++i)) == ' ' || this_ch == '@' || this_ch == '\n' || this_ch == '\r') continue;
            throw new PyException((PyObject)Error, "Trailing garbage");
        }
        return bin_data.toString();
    }

    public static String b2a_uu(String bin_data) {
        int leftbits = 0;
        int leftchar = 0;
        int bin_len = bin_data.length();
        if (bin_len > 45) {
            throw new PyException((PyObject)Error, "At most 45 bytes at once");
        }
        StringBuffer ascii_data = new StringBuffer();
        ascii_data.append((char)(32 + (bin_len & 0x3F)));
        int i = 0;
        while (bin_len > 0 || leftbits != 0) {
            leftchar = bin_len > 0 ? leftchar << 8 | bin_data.charAt(i) : (leftchar <<= 8);
            leftbits += 8;
            while (leftbits >= 6) {
                char this_ch = (char)(leftchar >> leftbits - 6 & 0x3F);
                leftbits -= 6;
                ascii_data.append((char)(this_ch + 32));
            }
            ++i;
            --bin_len;
        }
        ascii_data.append('\n');
        return ascii_data.toString();
    }

    private static int binascii_find_valid(String s, int offset, int num) {
        int slen = s.length() - offset;
        int ret = -1;
        while (slen > 0 && ret == -1) {
            char c = s.charAt(offset);
            short b64val = table_a2b_base64[c & 0x7F];
            if (c <= '\u007f' && b64val != -1) {
                if (num == 0) {
                    ret = c;
                }
                --num;
            }
            ++offset;
            --slen;
        }
        return ret;
    }

    public static String a2b_base64(String ascii_data) {
        int leftbits = 0;
        int leftchar = 0;
        int quad_pos = 0;
        int ascii_len = ascii_data.length();
        StringBuffer bin_data = new StringBuffer();
        int i = 0;
        while (ascii_len > 0) {
            char this_ch = ascii_data.charAt(i);
            if (this_ch <= '\u007f' && this_ch != '\r' && this_ch != '\n' && this_ch != ' ') {
                if (this_ch == BASE64_PAD) {
                    if (quad_pos >= 2 && (quad_pos != 2 || binascii.binascii_find_valid(ascii_data, i, 1) == BASE64_PAD)) {
                        leftbits = 0;
                        break;
                    }
                } else {
                    short this_v = table_a2b_base64[this_ch];
                    if (this_v != -1) {
                        quad_pos = quad_pos + 1 & 3;
                        leftchar = leftchar << 6 | this_v;
                        if ((leftbits += 6) >= 8) {
                            bin_data.append((char)(leftchar >> (leftbits -= 8) & 0xFF));
                            leftchar &= (1 << leftbits) - 1;
                        }
                    }
                }
            }
            --ascii_len;
            ++i;
        }
        if (leftbits != 0) {
            throw new PyException((PyObject)Error, "Incorrect padding");
        }
        return bin_data.toString();
    }

    public static String b2a_base64(String bin_data) {
        int leftbits = 0;
        int leftchar = 0;
        StringBuffer ascii_data = new StringBuffer();
        int bin_len = bin_data.length();
        if (bin_len > BASE64_MAXBIN) {
            throw new PyException((PyObject)Error, "Too much data for base64 line");
        }
        int i = 0;
        while (bin_len > 0) {
            leftchar = leftchar << 8 | bin_data.charAt(i);
            leftbits += 8;
            while (leftbits >= 6) {
                char this_ch = (char)(leftchar >> leftbits - 6 & 0x3F);
                leftbits -= 6;
                ascii_data.append((char)table_b2a_base64[this_ch]);
            }
            --bin_len;
            ++i;
        }
        if (leftbits == 2) {
            ascii_data.append((char)table_b2a_base64[(leftchar & 3) << 4]);
            ascii_data.append(BASE64_PAD);
            ascii_data.append(BASE64_PAD);
        } else if (leftbits == 4) {
            ascii_data.append((char)table_b2a_base64[(leftchar & 0xF) << 2]);
            ascii_data.append(BASE64_PAD);
        }
        ascii_data.append('\n');
        return ascii_data.toString();
    }

    public static PyTuple a2b_hqx(String ascii_data) {
        int leftbits = 0;
        int leftchar = 0;
        boolean done = false;
        int len = ascii_data.length();
        StringBuffer bin_data = new StringBuffer();
        int i = 0;
        while (len > 0) {
            char this_ch = (char)table_a2b_hqx[ascii_data.charAt(i)];
            if (this_ch != SKIP) {
                if (this_ch == FAIL) {
                    throw new PyException((PyObject)Error, "Illegal char");
                }
                if (this_ch == DONE) {
                    done = true;
                    break;
                }
                leftchar = leftchar << 6 | this_ch;
                if ((leftbits += 6) >= 8) {
                    bin_data.append((char)(leftchar >> (leftbits -= 8) & 0xFF));
                    leftchar &= (1 << leftbits) - 1;
                }
            }
            --len;
            ++i;
        }
        if (leftbits != 0 && !done) {
            throw new PyException((PyObject)Incomplete, "String has incomplete number of bytes");
        }
        return new PyTuple(new PyObject[]{Py.java2py(bin_data.toString()), Py.newInteger(done ? 1 : 0)});
    }

    public static String rlecode_hqx(String in_data) {
        int len = in_data.length();
        StringBuffer out_data = new StringBuffer();
        int in = 0;
        while (in < len) {
            char ch = in_data.charAt(in);
            if (ch == RUNCHAR) {
                out_data.append(RUNCHAR);
                out_data.append(0);
            } else {
                int inend = in + 1;
                while (inend < len && in_data.charAt(inend) == ch && inend < in + 255) {
                    ++inend;
                }
                if (inend - in > 3) {
                    out_data.append(ch);
                    out_data.append(RUNCHAR);
                    out_data.append((char)(inend - in));
                    in = inend - 1;
                } else {
                    out_data.append(ch);
                }
            }
            ++in;
        }
        return out_data.toString();
    }

    public static String b2a_hqx(String bin_data) {
        int leftbits = 0;
        int leftchar = 0;
        int len = bin_data.length();
        StringBuffer ascii_data = new StringBuffer();
        int i = 0;
        while (len > 0) {
            leftchar = leftchar << 8 | bin_data.charAt(i);
            leftbits += 8;
            while (leftbits >= 6) {
                char this_ch = (char)(leftchar >> leftbits - 6 & 0x3F);
                leftbits -= 6;
                ascii_data.append((char)table_b2a_hqx[this_ch]);
            }
            --len;
            ++i;
        }
        if (leftbits != 0) {
            ascii_data.append((char)table_b2a_hqx[(leftchar <<= 6 - leftbits) & 0x3F]);
        }
        return ascii_data.toString();
    }

    public static String rledecode_hqx(String in_data) {
        char in_repeat;
        char in_byte;
        int in_len = in_data.length();
        int i = 0;
        if (in_len == 0) {
            return "";
        }
        StringBuffer out_data = new StringBuffer();
        if (--in_len < 0) {
            throw new PyException(Incomplete);
        }
        if ((in_byte = in_data.charAt(i++)) == RUNCHAR) {
            if (--in_len < 0) {
                throw new PyException(Incomplete);
            }
            if ((in_repeat = in_data.charAt(i++)) != '\u0000') {
                throw new PyException((PyObject)Error, "Orphaned RLE code at start");
            }
            out_data.append(RUNCHAR);
        } else {
            out_data.append(in_byte);
        }
        while (in_len > 0) {
            if (--in_len < 0) {
                throw new PyException(Incomplete);
            }
            if ((in_byte = in_data.charAt(i++)) == RUNCHAR) {
                if (--in_len < 0) {
                    throw new PyException(Incomplete);
                }
                if ((in_repeat = in_data.charAt(i++)) == '\u0000') {
                    out_data.append(RUNCHAR);
                    continue;
                }
                in_byte = out_data.charAt(out_data.length() - 1);
                while ((in_repeat = (char)(in_repeat - '\u0001')) > '\u0000') {
                    out_data.append(in_byte);
                }
                continue;
            }
            out_data.append(in_byte);
        }
        return out_data.toString();
    }

    public static int crc_hqx(String bin_data, int crc) {
        int len = bin_data.length();
        int i = 0;
        while (len-- > 0) {
            crc = crc << 8 & 0xFF00 ^ crctab_hqx[crc >> 8 & 0xFF ^ bin_data.charAt(i++)];
        }
        return crc;
    }

    public static int crc32(String bin_data) {
        return binascii.crc32(bin_data, 0L);
    }

    public static int crc32(String bin_data, long crc) {
        int len = bin_data.length();
        crc &= 0xFFFFFFFFL;
        crc ^= 0xFFFFFFFFL;
        int i = 0;
        while (i < len) {
            char ch = bin_data.charAt(i);
            crc = (long)((int)crc_32_tab[(int)((crc ^ (long)ch) & 0xFFL)]) ^ crc >> 8;
            crc &= 0xFFFFFFFFL;
            ++i;
        }
        if (crc >= Integer.MIN_VALUE) {
            return -((int)(crc + 1L & 0xFFFFFFFFFFFFFFFFL));
        }
        return (int)(crc & 0xFFFFFFFFFFFFFFFFL);
    }

    public static String b2a_hex(String argbuf) {
        int arglen = argbuf.length();
        StringBuffer retbuf = new StringBuffer(arglen * 2);
        int i = 0;
        while (i < arglen) {
            char ch = argbuf.charAt(i);
            retbuf.append(hexdigit[ch >>> 4 & 0xF]);
            retbuf.append(hexdigit[ch & 0xF]);
            ++i;
        }
        return retbuf.toString();
    }

    public static String hexlify(String argbuf) {
        return binascii.b2a_hex(argbuf);
    }

    public static String a2b_hex(String argbuf) {
        int arglen = argbuf.length();
        if (arglen % 2 != 0) {
            throw Py.TypeError("Odd-length string");
        }
        StringBuffer retbuf = new StringBuffer(arglen / 2);
        int i = 0;
        while (i < arglen) {
            int top = Character.digit(argbuf.charAt(i), 16);
            int bot = Character.digit(argbuf.charAt(i + 1), 16);
            if (top == -1 || bot == -1) {
                throw Py.TypeError("Non-hexadecimal digit found");
            }
            retbuf.append((char)((top << 4) + bot));
            i += 2;
        }
        return retbuf.toString();
    }

    public static String unhexlify(String argbuf) {
        return binascii.a2b_hex(argbuf);
    }
}

