/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.SimpleJavaResourceLocator;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ModuleResourceLocator
extends SimpleJavaResourceLocator {
    public IContainer getDefaultLocation(IProject project) {
        return this.getRootFolder(project).getFolder(META_INF_PATH).getUnderlyingFolder();
    }

    public IPath getWorkspacePath(IProject project, IPath runtimePath) {
        return this.getRootFolder(project).getFile(runtimePath).getWorkspaceRelativePath();
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IFile file;
        IVirtualFolder rootFolder = this.getRootFolder(project);
        IVirtualFile vFile = this.getVirtualFile(rootFolder, file = PathTools.getFile(resourcePath));
        if (vFile != null) {
            return vFile.getRuntimePath().makeRelative();
        }
        return super.getRuntimePath(project, resourcePath);
    }

    protected IVirtualFile getVirtualFile(IVirtualFolder vFolder, IFile file) {
        try {
            return this.getVirtualFile_(vFolder, file);
        }
        catch (CoreException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    protected IVirtualFile getVirtualFile_(IVirtualFolder vFolder, IFile file) throws CoreException {
        IVirtualResource[] iVirtualResourceArray = vFolder.members();
        int n = iVirtualResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualResource vResource = iVirtualResourceArray[n2];
            IVirtualFile vFile = this.getVirtualFile(vResource, file);
            if (vFile != null) {
                return vFile;
            }
            ++n2;
        }
        return null;
    }

    protected IVirtualFile getVirtualFile(IVirtualResource vResource, IFile file) throws CoreException {
        switch (vResource.getType()) {
            case 16: {
                IVirtualFile vFile = (IVirtualFile)vResource;
                return file.equals((Object)vFile.getUnderlyingResource()) ? vFile : null;
            }
            case 32: {
                return this.getVirtualFile_((IVirtualFolder)vResource, file);
            }
        }
        return null;
    }

    protected IVirtualFolder getRootFolder(IProject project) {
        return ComponentCore.createComponent((IProject)project).getRootFolder();
    }
}

