/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.IBreakpointService;
import oracle.eclipse.tools.adf.controller.model.BreakpointState;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.taskflow.ActivityBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class TaskflowBreakpointService
implements IBreakpointService {
    public void handleActivityIdChange(IActivity act) {
        BreakpointState isBreakpointEnabled = (BreakpointState)act.getBreakpoint().content();
        if (isBreakpointEnabled != BreakpointState.NONE) {
            ITaskFlowFile tfRoot = (ITaskFlowFile)act.nearest(ITaskFlowFile.class);
            ITaskFlow taskFlow = tfRoot.getTaskFlow();
            IFile file = (IFile)act.adapt(IFile.class);
            String taskflowName = null;
            HashSet<String> allActivities = new HashSet<String>();
            TaskFlowType tfType = (TaskFlowType)tfRoot.getTaskFlowType().content();
            taskflowName = tfType == TaskFlowType.Bounded || tfType == TaskFlowType.Template ? (String)taskFlow.getTaskFlowId().content() : "UNBOUNDED_TASK_FLOW";
            for (IActivity a : taskFlow.getActivities()) {
                allActivities.add((String)a.getActivityId().content());
            }
            try {
                ActivityBreakpoint brkpt;
                String activityId = (String)act.getActivityId().content();
                if (activityId != null && (brkpt = ActivityBreakpoint.findBreakpoint(file, taskflowName, activityId)) == null) {
                    boolean register = true;
                    ActivityBreakpoint newBreakpoint = AdfDebugModel.createTaskflowActivityBreakpoint((IResource)file, taskflowName, activityId, register, null);
                    this.removeObsoletedBreakpoint(newBreakpoint, allActivities);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removeObsoletedBreakpoint(ActivityBreakpoint newBreakpoint, Set<String> allActivities) {
        IBreakpoint[] brkpoint;
        IMarker marker = newBreakpoint.getMarker();
        IResource resource = marker.getResource();
        DebugPlugin plugin = DebugPlugin.getDefault();
        IBreakpoint[] iBreakpointArray = brkpoint = plugin.getBreakpointManager().getBreakpoints("oracle.eclipse.tools.weblogic.debugger");
        int n = brkpoint.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityBreakpoint actBrkpt;
            String id;
            IBreakpoint brkpt = iBreakpointArray[n2];
            if (brkpt.getMarker().getResource() == resource && brkpt instanceof ActivityBreakpoint && !allActivities.contains(id = (actBrkpt = (ActivityBreakpoint)brkpt).getActivityId())) {
                IBreakpointManager brkptMgr = DebugPlugin.getDefault().getBreakpointManager();
                try {
                    brkptMgr.removeBreakpoint(brkpt, true);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    public String getBreakpointState(IActivity activity) {
        ITaskFlow taskFlow = (ITaskFlow)activity.nearest(ITaskFlow.class);
        if (taskFlow != null) {
            String activityId;
            ActivityBreakpoint brkpt;
            String taskflowName = null;
            IFile file = (IFile)activity.adapt(IFile.class);
            taskflowName = TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)taskFlow) || TaskFlowUtil.isTaskFlowTemplate((ITaskFlow)taskFlow) ? (String)taskFlow.getTaskFlowId().content() : "UNBOUNDED_TASK_FLOW";
            if (taskflowName != null && (brkpt = ActivityBreakpoint.findBreakpoint(file, taskflowName, activityId = (String)activity.getActivityId().content())) != null) {
                try {
                    if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                        return BreakpointState.DISABLED.toString();
                    }
                    if (brkpt.isEnabled()) {
                        String thisActivityId = String.valueOf(taskflowName) + "#" + activityId;
                        String actId = AdfDebugModel.getCurrentActivity();
                        if (TaskFlowUtil.isTaskFlowTemplate((ITaskFlow)taskFlow) ? actId != null && actId.endsWith("#" + activityId) : thisActivityId.equals(actId)) {
                            return BreakpointState.HIT.toString();
                        }
                        return BreakpointState.ENABLED.toString();
                    }
                    return BreakpointState.DISABLED.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return BreakpointState.NONE.toString();
    }
}

