/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.debugger.lifecycle.AdfLifecyclePhaseBreakpoint;
import oracle.eclipse.tools.adf.debugger.lifecycle.IAdfLifecyclePhaseBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.ActionBindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.BindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.IteratorBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.MethodBindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.TaskflowExecutableBreakpoint;
import oracle.eclipse.tools.adf.debugger.pagedef.ValueBindingBreakpoint;
import oracle.eclipse.tools.adf.debugger.taskflow.ActivityBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public class AdfDebugModel {
    public static final String ADF_LIFECYCLE_BREAKPOINT_FACADE_FWK_TYPE = "oracle.adf.controller.internal.debug.AdfLifecycleBreakpointFacadeFwk";
    public static final String ADF_LIFECYCLE_BREAKPOINT_FACADE_METHOD = "markPhaseBoundary";
    public static final String ADF_LIFECYCLE_BREAKPOINT_FACADE_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)V";
    public static final String ACTIVITY_BREAKPOINT_FACADE_IMPL_CLASS = "oracle.adfinternal.controller.debug.ActivityBreakpointFacadeImpl";
    public static final String ACTIVITY_BREAKPOINT_FACADE_METHOD = "markActivityBreakpoint";
    public static final String ACTIVITY_BREAKPOINT_FACADE_SIGNATURE = "(Loracle/adfinternal/controller/debug/ActivityBreakpointDetail;)V";
    public static final String ACTIVITY_BREAKPOINT_FACADE_BRKPT_CONDITION = "activityBreakpointDetail.getTaskFlowId().equals(\"%s\") && activityBreakpointDetail.getActivityId().equals(\"%s\")";
    public static final String ACTIVITY_BREAKPOINT_FACADE_UNBOUNDED_BRKPT_CONDITION = "activityBreakpointDetail.getTaskFlowId()==null && activityBreakpointDetail.getActivityId().equals(\"%s\")";
    public static final String PAGEDEF_VALUE_BINDING_TYPE = "oracle.jbo.uicli.binding.JUCtrlValueBinding";
    public static final String PAGEDEF_TASKFLOW_BINDING_TYPE = "oracle.adf.controller.internal.binding.DCTaskFlowBinding";
    public static final String PAGEDEF_ITERATOR_BINDING_TYPE = "oracle.adf.model.binding.DCIteratorBinding";
    public static final String PAGEDEF_ACTION_BINDING_TYPE = "oracle.jbo.uicli.binding.JUCtrlActionBinding";
    private static final HashMap<String, String[]> PAGEDEF_BINDING_METHOD_SIGNATURE = new HashMap();
    public static final String BINDING_ID = "BINDING_ID";
    public static final String PAGEDF_NAME = "PAGEDF_NAME";
    public static final String IS_BREAK_BEFORE = "IS_BREAK_BEFORE";
    private static String currentActivity;
    private static Object currentBindingElement;

    static {
        PAGEDEF_BINDING_METHOD_SIGNATURE.put(PAGEDEF_VALUE_BINDING_TYPE, new String[]{"_beforeSetInputValue", "callAfterSetAttribute"});
        PAGEDEF_BINDING_METHOD_SIGNATURE.put(PAGEDEF_TASKFLOW_BINDING_TYPE, new String[]{"debugBeforeBegin", "debugBeforeEnd"});
        PAGEDEF_BINDING_METHOD_SIGNATURE.put(PAGEDEF_ITERATOR_BINDING_TYPE, new String[]{"refresh", "afterRefresh"});
        PAGEDEF_BINDING_METHOD_SIGNATURE.put(PAGEDEF_ACTION_BINDING_TYPE, new String[]{"_dbg_invokeOperation", "_dbg_AfterInvokeOperation"});
        currentActivity = null;
        currentBindingElement = null;
    }

    private AdfDebugModel() {
    }

    public static IAdfLifecyclePhaseBreakpoint createLifecyclePhaseBreakpoint(String phaseName, boolean before, boolean after, boolean register, Map attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap(10);
        }
        return new AdfLifecyclePhaseBreakpoint(phaseName, before, after, register, attributes);
    }

    public static ActivityBreakpoint createTaskflowActivityBreakpoint(IResource resource, String taskflowName, String activityId, boolean register, Map attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap(10);
        }
        return new ActivityBreakpoint(resource, taskflowName, activityId, register, attributes);
    }

    public static BindingBreakpoint createValueBindingBreakpoint(IResource resource, String id, boolean breakBefore) throws CoreException {
        HashMap attributes = new HashMap(10);
        return new ValueBindingBreakpoint(resource, id, breakBefore, attributes);
    }

    public static BindingBreakpoint createActionBindingBreakpoint(IResource resource, String id, boolean breakBefore) throws CoreException {
        HashMap attributes = new HashMap(10);
        return new ActionBindingBreakpoint(resource, id, breakBefore, attributes);
    }

    public static BindingBreakpoint createMethodBindingBreakpoint(IResource resource, String id, boolean breakBefore) throws CoreException {
        HashMap attributes = new HashMap(10);
        return new MethodBindingBreakpoint(resource, id, breakBefore, attributes);
    }

    public static BindingBreakpoint createTaskflowExecutableBreakpoint(IResource resource, String id, boolean breakBefore) throws CoreException {
        HashMap attributes = new HashMap(10);
        return new TaskflowExecutableBreakpoint(resource, id, breakBefore, attributes);
    }

    public static void removeDCBindingBreakpoint(IResource resource, String id, boolean breakBefore) throws CoreException {
        IBreakpointManager brkptMgr = DebugPlugin.getDefault().getBreakpointManager();
        BindingBreakpoint bk = AdfDebugModel.findBidningBreakpoint(resource, id, breakBefore);
        if (bk != null) {
            brkptMgr.removeBreakpoint((IBreakpoint)bk, true);
        }
    }

    public static BindingBreakpoint findBidningBreakpoint(IResource resource, String id, boolean breakBefore) {
        IBreakpointManager brkptMgr = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = brkptMgr.getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            BindingBreakpoint bk;
            IBreakpoint brkpt = iBreakpointArray[n2];
            if (brkpt.getMarker().getResource().equals((Object)resource) && brkpt instanceof BindingBreakpoint && (bk = (BindingBreakpoint)brkpt).getId().equals(id) && breakBefore == bk.isBreakBefore()) {
                return bk;
            }
            ++n2;
        }
        return null;
    }

    public static IteratorBreakpoint createIteratorBreakpoint(IResource resource, String id, boolean breakBefore) throws CoreException {
        HashMap attributes = new HashMap(10);
        return new IteratorBreakpoint(resource, id, breakBefore, attributes);
    }

    public static String getModelIdentifier() {
        return "oracle.eclipse.tools.weblogic.debugger";
    }

    public static void reset() {
        AdfDebugModel.setCurrentActivity(null);
        AdfDebugModel.setCurrentBindingElement(null);
    }

    public static String getCurrentActivity() {
        return currentActivity;
    }

    public static void setCurrentActivity(String currentActivity2) {
        currentActivity = currentActivity2;
    }

    public static Object getCurrentBindingElement() {
        return currentBindingElement;
    }

    public static void setCurrentBindingElement(Object e) {
        currentBindingElement = e;
    }

    public static String getBindingId(IMarker marker) {
        String id = marker.getAttribute(BINDING_ID, null);
        return id;
    }

    public static boolean isAdfBindingBreakpointHit(JDIStackFrame f) {
        try {
            String typeName = f.getDeclaringTypeName();
            String methodName = f.getMethodName();
            String[] sigMethodNames = PAGEDEF_BINDING_METHOD_SIGNATURE.get(typeName);
            if (sigMethodNames != null && (sigMethodNames[0].equals(methodName) || sigMethodNames[1].equals(methodName))) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isInBeforeBindingMethod(JDIStackFrame f) {
        block4: {
            String[] sigMethodNames;
            String methodName;
            block5: {
                String typeName = f.getDeclaringTypeName();
                methodName = f.getMethodName();
                sigMethodNames = PAGEDEF_BINDING_METHOD_SIGNATURE.get(typeName);
                if (sigMethodNames == null) break block4;
                if (!sigMethodNames[0].equals(methodName)) break block5;
                return true;
            }
            try {
                if (sigMethodNames[1].equals(methodName)) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

