/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.wadl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.IJaxrsDependencyFactory;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.UnexpectedFileStateException;
import oracle.eclipse.tools.jaxrs.ui.wadl.GeneratedFilesValidator;
import oracle.eclipse.tools.jaxrs.ui.wadl.Messages;
import oracle.eclipse.tools.jaxrs.wadl.IWadl2Java;
import oracle.eclipse.tools.jaxrs.wadl.model.IWadl2JavaModel;
import oracle.eclipse.tools.jaxrs.wadl.model.Wadl2JavaModelResource;
import oracle.eclipse.tools.jaxrs.wadl.model.WadlLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.java.JavaPackageName;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class Wadl2JavaWizard
extends SapphireWizard<IWadl2JavaModel>
implements IWorkbenchWizard {
    private IStructuredSelection _selection;
    private static final String WADL_DIR = "wadl/src";
    private File wadlWorkingDir;

    public Wadl2JavaWizard() {
        super((Element)Wadl2JavaWizard.createModel(), DefinitionLoader.sdef(Wadl2JavaWizard.class).wizard());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._selection = selection;
        IWadl2JavaModel element = (IWadl2JavaModel)this.element();
        Wadl2JavaModelResource wadlResource = (Wadl2JavaModelResource)((IWadl2JavaModel)this.element()).resource();
        wadlResource.setSelection(selection);
        element.initialize();
        element.refresh();
    }

    protected void performPostFinish() {
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                try {
                    File projectWorkingDir = Activator.getDefault().getStateLocation().toFile();
                    Wadl2JavaWizard.this.wadlWorkingDir = new File(projectWorkingDir, Wadl2JavaWizard.WADL_DIR);
                    Wadl2JavaWizard.this.createNewDir(Wadl2JavaWizard.this.wadlWorkingDir);
                    IProject iProject = (IProject)((IWadl2JavaModel)Wadl2JavaWizard.this.element()).getProject().resolve();
                    String pkgName = ((JavaPackageName)((IWadl2JavaModel)Wadl2JavaWizard.this.element()).getPackage().content()).toString();
                    WadlLocation wadlLocation = (WadlLocation)((IWadl2JavaModel)Wadl2JavaWizard.this.element()).getWadlLocation().content();
                    URI url = null;
                    if (WadlLocation.REMOTE.equals((Object)wadlLocation)) {
                        url = new URI((String)((IWadl2JavaModel)Wadl2JavaWizard.this.element()).getUrl().content());
                    } else {
                        org.eclipse.sapphire.modeling.Path projRelPath = (org.eclipse.sapphire.modeling.Path)((IWadl2JavaModel)Wadl2JavaWizard.this.element()).getWadl().content();
                        IFile wadlFile = iProject.getFile(projRelPath.toString());
                        url = wadlFile.getLocationURI();
                    }
                    IJaxrsDependencyFactory jaxrsDependencyFactory = (IJaxrsDependencyFactory)Platform.getAdapterManager().loadAdapter((Object)iProject, IJaxrsDependencyFactory.class.getName());
                    IWadl2Java wadl2Java = jaxrsDependencyFactory.getWadl2Java();
                    wadl2Java.init();
                    wadl2Java.setDescription(url);
                    wadl2Java.setPackage(pkgName);
                    wadl2Java.setTarget(Wadl2JavaWizard.this.wadlWorkingDir);
                    wadl2Java.execute();
                    Wadl2JavaWizard.this.copyFiles(pm, iProject, pkgName, Wadl2JavaWizard.this.wadlWorkingDir);
                }
                catch (Exception e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (Throwable)e);
                    DialogService.showErrorDialog((String)"Unable to generate java rest client from WADL.", (Throwable)e);
                }
            }
        };
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, pm);
                }
                catch (CoreException ce) {
                    LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)ce);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnableWithProgress);
        }
        catch (InvocationTargetException ite) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (Throwable)ite);
        }
        catch (InterruptedException ie) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (Throwable)ie);
        }
    }

    public IStructuredSelection getSelection() {
        return this._selection;
    }

    private static final IWadl2JavaModel createModel() {
        return (IWadl2JavaModel)IWadl2JavaModel.TYPE.instantiate((Resource)new Wadl2JavaModelResource(IWadl2JavaModel.TYPE, null));
    }

    private void createNewDir(File f) throws IOException {
        if (f.exists()) {
            EclipseFileUtil.deleteFile((File)f);
        }
        if (!f.mkdirs()) {
            DialogService.showErrorDialog((String)Messages.bind((String)Messages.generated_files_cannot_create_tmpdir, (Object)f.getAbsolutePath()));
            throw new FileNotFoundException(f.getParent());
        }
        if (!f.canWrite()) {
            throw new FileNotFoundException(f.getParent());
        }
    }

    private boolean copyFiles(IProgressMonitor monitor, IProject project, String pkgName, File sourceDir) throws IOException, UnexpectedFileStateException, CoreException {
        File[] files;
        ArrayList<File> generatedFiles = new ArrayList<File>();
        File[] fileArray = files = sourceDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Wadl2JavaWizard.discoverGeneratedFiles(file, generatedFiles);
            ++n2;
        }
        Map<File, IFile> sourceToProjectFiles = this.discoverProjectFiles(sourceDir, generatedFiles, project);
        ArrayList<IResource> readOnly = new ArrayList<IResource>();
        ArrayList<IFile> newList = new ArrayList<IFile>();
        ArrayList<IFile> overwrite = new ArrayList<IFile>();
        Collection<IFile> projectFiles = sourceToProjectFiles.values();
        for (IFile file : projectFiles) {
            this.addIfExists(project, (IResource)file, readOnly, newList, overwrite);
        }
        GeneratedFilesValidator gFileValidator = new GeneratedFilesValidator(this.getContainer().getShell());
        if (!gFileValidator.validateFiles(monitor, overwrite, readOnly)) {
            return false;
        }
        IJavaProject jproj = JavaCore.create((IProject)project);
        IPackageFragmentRoot src = this.src(jproj);
        IPackageFragment pack = src.getPackageFragment(pkgName == null ? "" : pkgName);
        if (!pack.exists()) {
            pack = src.createPackageFragment(pkgName == null ? "" : pkgName, true, null);
        }
        for (Map.Entry<File, IFile> entry : sourceToProjectFiles.entrySet()) {
            EclipseFileUtil.copyFileToProject((File)entry.getKey(), (IFile)entry.getValue());
        }
        return true;
    }

    private final IPackageFragmentRoot src(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    private static boolean discoverGeneratedFiles(File from, List<File> fileList) throws IOException {
        if (from.isDirectory()) {
            File[] fromChildren = from.listFiles();
            boolean discoverOneChild = false;
            if (fromChildren != null) {
                File[] fileArray = fromChildren;
                int n = fromChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    File nextFrom = fileArray[n2];
                    if (Wadl2JavaWizard.discoverGeneratedFiles(nextFrom, fileList)) {
                        discoverOneChild = true;
                    }
                    ++n2;
                }
            }
            return discoverOneChild;
        }
        fileList.add(from);
        return true;
    }

    private Map<File, IFile> discoverProjectFiles(File baseFile, List<File> sourceFiles, IProject project) throws IOException, JavaModelException {
        IPath basePath = Path.fromOSString((String)baseFile.getCanonicalPath());
        HashMap<File, IFile> targetFiles = new HashMap<File, IFile>();
        IPath rootPath = project.getFullPath();
        IJavaProject jProj = JavaCore.create((IProject)project);
        IPackageFragmentRoot src = this.src(jProj);
        rootPath = src.getPath();
        for (File sFile : sourceFiles) {
            IPath sFilePath = Path.fromOSString((String)sFile.getCanonicalPath());
            IPath pkgFilePath = sFilePath.makeRelativeTo(basePath);
            IPath targetFilePath = rootPath.append(pkgFilePath);
            IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetFilePath);
            targetFiles.put(sFile, targetFile);
        }
        return targetFiles;
    }

    private void addIfExists(IProject project, IResource file, List<IResource> readonly, List<IFile> newList, List<IFile> overwrite) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            IContainer parent;
            IContainer iContainer = parent = file.getType() == 1 ? file.getParent() : (IContainer)file;
            if (!parent.exists()) {
                try {
                    FolderUtil.createFolder((IProject)project, (String)parent.getProjectRelativePath().toPortableString());
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                    throw new RuntimeException(e);
                }
            } else if (this.isReadOnly((IResource)parent)) {
                readonly.add((IResource)parent);
            }
            if (file.getType() == 1) {
                newList.add((IFile)file);
            }
        } else if (file.getType() == 1) {
            if (this.isReadOnly(file)) {
                readonly.add(file);
            } else {
                overwrite.add((IFile)file);
            }
            IContainer parent = file.getParent();
            if (this.isReadOnly((IResource)parent)) {
                readonly.add((IResource)parent);
            }
        }
    }

    private boolean isReadOnly(IResource rsrc) {
        ResourceAttributes attrs = rsrc.getResourceAttributes();
        return attrs == null ? true : attrs.isReadOnly();
    }
}

