/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.properties.sections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.eclipse.tools.jaxrs.properties.elements.IAnnotationElement;
import oracle.eclipse.tools.jaxrs.properties.model.IJwsAnnotation;
import oracle.eclipse.tools.jaxrs.ui.properties.sections.AnnotationFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AnnotationSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private final IAnnotationElement annotationElement;

    public AnnotationSection(IAnnotationElement annotationElement) {
        this.annotationElement = annotationElement;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.annotationElement.setInput();
    }

    public void createControls(Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        parent.setLayout((Layout)GridLayoutUtil.glayout((int)1, (int)5, (int)10));
        parent.setBackgroundMode(1);
        IJwsAnnotation model = AnnotationFactory.getAnnotation(this.annotationElement);
        String id = model.getId();
        SapphireForm sapphireControl = new SapphireForm(parent, (Element)model, DefinitionLoader.sdef(this.getClass()).form("rest.annotations." + id));
        sapphireControl.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                aTabbedPropertySheetPage.resizeScrolledComposite();
            }
        });
        sapphireControl.setLayoutData((Object)GridLayoutUtil.gdfill());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sapphireControl, "oracle.eclipse.tools.jaxrs.ui.AnnotationsView");
        parent.layout(true, true);
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.annotationElement != null) {
            this.annotationElement.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.annotationElement != null) {
            this.annotationElement.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public IProject getSelectionProject() {
        IJavaProject project = this.annotationElement.getJavaElement().getJavaProject();
        if (project != null) {
            return project.getProject();
        }
        return null;
    }

    public IResource getSelectionResource() {
        return this.annotationElement.getJavaElement().getResource();
    }
}

