/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.properties.context;

import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.jaxrs.properties.JavaElementType;
import oracle.eclipse.tools.jaxrs.properties.context.ASTPropertyInvocationContext;
import oracle.eclipse.tools.jaxrs.properties.elements.IAnnotationElement;
import oracle.eclipse.tools.jaxrs.ui.properties.Messages;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.ClassElement;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.ConstructorElement;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.FieldElement;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.JavaElement;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.MethodElement;
import oracle.eclipse.tools.jaxrs.ui.properties.elements.MethodParameterElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class RestPropertyContentProvider
implements IDocumentListener,
ISelectionProvider {
    private final ClassElement classElement = new ClassElement(this);
    private final ConstructorElement constructorElement = new ConstructorElement(this);
    private final MethodElement methodElement = new MethodElement(this);
    private final FieldElement fieldElement = new FieldElement(this);
    private final MethodParameterElement methodParameterElement = new MethodParameterElement(this);
    private JavaElement currentSelection;
    private ASTPropertyInvocationContext astContext;
    private ICompilationUnit icompilationUnit;

    public void rewriteAnnotation(final Annotation annotation, final String attrName, final Object value) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                RestPropertyContentProvider.this.astContext.setAnnotationAttribute(annotation, attrName, value);
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void rewriteAnnotationAsArrayAttributes(final Annotation annotation, final String attrName, final List<Object> value) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                RestPropertyContentProvider.this.astContext.setAttributeArray(annotation, attrName, value);
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotation(final BodyDeclaration parent, final String fullyQualifiedName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                if (attrs != null && !attrs.isEmpty()) {
                    RestPropertyContentProvider.this.astContext.addAnnotation(parent, fullyQualifiedName, attrs);
                } else {
                    RestPropertyContentProvider.this.astContext.addMarkerAnnotation(parent, fullyQualifiedName);
                }
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotationAsArrayAttributes(final BodyDeclaration parent, final String fullyQualifiedName, final Map<String, List<Object>> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                if (attrs != null && !attrs.isEmpty()) {
                    RestPropertyContentProvider.this.astContext.addAnnotationAttributeArray(parent, fullyQualifiedName, attrs);
                } else {
                    RestPropertyContentProvider.this.astContext.addMarkerAnnotation(parent, fullyQualifiedName);
                }
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotation(final SingleVariableDeclaration parent, final String fullyQualifiedName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                if (attrs != null && !attrs.isEmpty()) {
                    RestPropertyContentProvider.this.astContext.addAnnotation(parent, fullyQualifiedName, attrs);
                } else {
                    RestPropertyContentProvider.this.astContext.addMarkerAnnotation(parent, fullyQualifiedName);
                }
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotationAsArrayAttributes(final SingleVariableDeclaration parent, final String fullyQualifiedName, final Map<String, List<Object>> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                if (attrs != null && !attrs.isEmpty()) {
                    RestPropertyContentProvider.this.astContext.addAnnotationAttributeArray(parent, fullyQualifiedName, attrs);
                } else {
                    RestPropertyContentProvider.this.astContext.addMarkerAnnotation(parent, fullyQualifiedName);
                }
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotationWithArrayMember(final BodyDeclaration parent, final String fullyQualifiedName, final String arrayName, final String annotationName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                RestPropertyContentProvider.this.astContext.addAnnotationWithArrayMember(parent, fullyQualifiedName, arrayName, annotationName, attrs);
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotationArrayMember(final Annotation annotation, final String arrayName, final String annotationName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                RestPropertyContentProvider.this.astContext.addAnnotationArrayMember(annotation, arrayName, annotationName, attrs);
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void setAttributeArray(final Annotation annotation, final String attrName, final List<Object> values) {
        SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

            public void run() throws Exception {
                RestPropertyContentProvider.this.astContext.setAttributeArray(annotation, attrName, values);
                RestPropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void removeAnnotation(final ASTNode node) {
        if (node != null) {
            SafeRunnable code = new SafeRunnable(Messages.properties_annotation_update_failure){

                public void run() throws Exception {
                    RestPropertyContentProvider.this.astContext.removeAnnotation(node);
                    RestPropertyContentProvider.this.astContext.commitRewrite();
                }
            };
            SafeRunner.run((ISafeRunnable)code);
        }
    }

    public void refresh() {
        this.astContext.initializeEditContext();
        if (this.currentSelection != null) {
            this.currentSelection.refresh(this.getCurrentElementTypeNode());
        }
    }

    public void update() {
        this.astContext.initializeEditContext();
        if (this.currentSelection != null) {
            this.currentSelection.update(this.getCurrentElementTypeNode());
        }
    }

    public boolean hasSelectionChanged(TextSelection selection) {
        if (!this.isEmpty()) {
            Position pos = new Position(selection.getOffset(), selection.getLength());
            ASTNode node = this.astContext.findContainingNode(pos);
            node = this.findElementTypeNode(node);
            return !this.currentSelection.getASTNode().equals((Object)node);
        }
        return true;
    }

    public void selectionChanged(ITextEditor editor, TextSelection selection) {
        IEditorInput input;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)(input = editor.getEditorInput()));
        if (document.get() != null && document.get().length() >= selection.getOffset()) {
            this.icompilationUnit = (ICompilationUnit)JavaUI.getEditorInputJavaElement((IEditorInput)input);
            this.astContext = new ASTPropertyInvocationContext(this.icompilationUnit, document, selection.getOffset(), selection.getLength());
            this.astContext.addPositionUpdater();
            ASTNode node = this.astContext.findContainingNode();
            this.setSelection((ISelection)this.getElement(node));
            this.refresh();
        }
    }

    private JavaElement getElement(ASTNode node) {
        JavaElementType type = this.findElementType(node);
        return this.getJavaElement(type);
    }

    private JavaElementType findElementType(ASTNode node) {
        while (node != null) {
            if (this.classElement.isElementTypeNode(node)) {
                return this.classElement.getType();
            }
            if (this.constructorElement.isElementTypeNode(node)) {
                return this.constructorElement.getType();
            }
            if (this.methodElement.isElementTypeNode(node)) {
                return this.methodElement.getType();
            }
            if (this.fieldElement.isElementTypeNode(node)) {
                return this.fieldElement.getType();
            }
            if (this.methodParameterElement.isElementTypeNode(node)) {
                return this.methodParameterElement.getType();
            }
            if (this.unsupportedNode(node)) {
                return null;
            }
            node = node.getParent();
        }
        return null;
    }

    private ASTNode findElementTypeNode(ASTNode node) {
        while (node != null) {
            if (this.classElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.methodElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.fieldElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.methodParameterElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.unsupportedNode(node)) {
                return null;
            }
            node = node.getParent();
        }
        return null;
    }

    private boolean unsupportedNode(ASTNode node) {
        return node instanceof MethodDeclaration && ((MethodDeclaration)node).isConstructor();
    }

    public String getSelectionTabIdentifier(TextSelection selection) {
        if (!this.isEmpty()) {
            Position pos = new Position(selection.getOffset(), selection.getLength());
            ASTNode node = this.astContext.findContainingNode(pos);
            JavaElementType elementType = this.findElementType(node);
            JavaElement element = this.getJavaElement(elementType);
            Annotation annotationNode = this.findAnnotationNode(node);
            if (annotationNode != null) {
                String name = annotationNode.getTypeName().getFullyQualifiedName();
                for (IAnnotationElement annotationElement : element.getAnnotations()) {
                    if (!annotationElement.isEqual(name) && !annotationElement.contains(name)) continue;
                    return annotationElement.getTabIdentifier();
                }
            }
        }
        return null;
    }

    private Annotation findAnnotationNode(ASTNode node) {
        while (node != null) {
            if (node instanceof Annotation) {
                return (Annotation)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private JavaElement getJavaElement(JavaElementType type) {
        if (type != null) {
            switch (type) {
                case CLASS: {
                    return this.classElement;
                }
                case CONSTRUCTOR: {
                    return this.constructorElement;
                }
                case METHOD: {
                    return this.methodElement;
                }
                case METHODPARAMETER: {
                    return this.methodParameterElement;
                }
                case FIELD: {
                    return this.fieldElement;
                }
            }
        }
        return null;
    }

    private ASTNode getCurrentElementTypeNode() {
        ASTNode node = this.astContext.findContainingNode();
        while (node != null) {
            if (this.currentSelection.isElementTypeNode(node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private void addDocumentListener() {
        if (this.astContext != null && this.astContext.getDocument() != null) {
            this.astContext.getDocument().addDocumentListener((IDocumentListener)this);
        }
    }

    private void removeDocumentListener() {
        if (this.astContext != null && this.astContext.getDocument() != null) {
            this.astContext.getDocument().removeDocumentListener((IDocumentListener)this);
        }
    }

    public boolean isEmpty() {
        return this.currentSelection == null;
    }

    public void startListening() {
        this.addDocumentListener();
    }

    public void dispose() {
        this.removeDocumentListener();
        if (this.astContext != null) {
            this.astContext.removePositionUpdater();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.refresh();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
        this.currentSelection = selection instanceof JavaElement ? (JavaElement)selection : null;
    }

    public ICompilationUnit getIcompilationUnit() {
        return this.icompilationUnit;
    }
}

