/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import oracle.eclipse.tools.jaxrs.ui.launcher.JaxrsResourceSearchEngine;
import oracle.eclipse.tools.jaxrs.ui.launcher.LauncherMessages;
import oracle.eclipse.tools.jaxrs.util.JAXRSUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.SharedJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class JaxrsResourceTab
extends SharedJavaMainTab {
    public static final String ATTR_INCLUDE_EXTERNAL_JARS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".INCLUDE_EXTERNAL_JARS";
    public static final String ATTR_CONSIDER_INHERITED_MAIN = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".CONSIDER_INHERITED_MAIN";
    private Button fSearchExternalJarsCheckButton;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createMainTypeEditor(comp, LauncherMessages.jaxrsResourceTab_resource_cla_ss);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
    }

    protected void createMainTypeExtensions(Composite parent) {
        this.fSearchExternalJarsCheckButton = SWTFactory.createCheckButton((Composite)parent, (String)LauncherMessages.jaxrsResourceTab_E_xt_jars, null, (boolean)false, (int)2);
        this.fSearchExternalJarsCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public String getName() {
        return LauncherMessages.jaxrsResourceTab_Name;
    }

    public String getId() {
        return "oracle.eclipse.tools.jaxrs.ui.jaxrsResourceTab";
    }

    protected void handleSearchButtonSelected() {
        IType[] types = this.searchAnnotatedResources();
        if (types == null) {
            return;
        }
        DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(this.getShell(), types, LauncherMessages.jaxrsResourceTab_Choose_Resource_Type);
        if (mmsd.open() == 1) {
            return;
        }
        Object[] results = mmsd.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            this.fProjText.setText(type.getJavaProject().getElementName());
        }
    }

    public IType[] searchAnnotatedResources() {
        IJavaProject project = this.getJavaProject();
        IJavaElement[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log((Throwable)e);
                }
            }
        } else {
            elements = new IJavaElement[]{project};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        constraints |= 2;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 4;
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        JaxrsResourceSearchEngine engine = new JaxrsResourceSearchEngine();
        IType[] types = null;
        try {
            types = engine.searchAnnotatedResource((IRunnableContext)this.getLaunchConfigurationDialog(), project, searchScope, true);
            if (types != null) {
                HashSet<IType> result = new HashSet<IType>(types.length);
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (!Flags.isAbstract((int)type.getFlags()) && !Flags.isInterface((int)type.getFlags())) {
                        result.add(type);
                    }
                    ++n2;
                }
                return result.toArray(new IType[result.size()]);
            }
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getMessage());
            return null;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(e.getMessage());
            return null;
        }
        catch (JavaModelException e) {
            this.setErrorMessage(e.getMessage());
            return null;
        }
        return types;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateMainTypeFromConfig(config);
        this.updateExternalJars(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(NLS.bind((String)LauncherMessages.jaxrsResourceTab_project_not_exist, (Object[])new String[]{name}));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(NLS.bind((String)LauncherMessages.jaxrsResourceTab_project_closed, (Object[])new String[]{name}));
                    return false;
                }
                if (!JAXRSUtil.hasJaxrsFacetInstalled((IProject)project)) {
                    this.setErrorMessage(NLS.bind((String)LauncherMessages.jaxrsResourceTab_invalid_project, (Object[])new String[]{name}));
                    return false;
                }
            } else {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.jaxrsResourceTab_illegal_name, (Object[])new String[]{status.getMessage()}));
                return false;
            }
        }
        if ((name = this.fMainText.getText().trim()).length() == 0) {
            this.setErrorMessage(LauncherMessages.jaxrsResourceTab_type_not_specified);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText().trim());
        this.mapResources(config);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, null);
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, true);
        } else {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, null);
        }
        config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    private void updateExternalJars(ILaunchConfiguration config) {
        boolean search = false;
        try {
            search = config.getAttribute(ATTR_INCLUDE_EXTERNAL_JARS, false);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fSearchExternalJarsCheckButton.setSelection(search);
    }
}

