/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.ui.launcher.AnnotationSearchRequestor;
import oracle.eclipse.tools.jaxrs.ui.launcher.LauncherMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class JaxrsResourceSearchEngine {
    static final String PATH_ANNOTATION_CLASS = "javax.ws.rs.Path";
    static final String APPLICATION_PATH_ANNOTATION_CLASS = "javax.ws.rs.ApplicationPath";

    public IType[] findAnnotatedComponents(IProgressMonitor pm, IJavaProject jProject, IJavaSearchScope scope, boolean includeSubtypes) {
        pm.beginTask(LauncherMessages.JaxrsResourceSearchEngine_1, 100);
        int searchTicks = 100;
        if (includeSubtypes) {
            searchTicks = 25;
        }
        SearchPattern pattern = null;
        try {
            pattern = this.orPattern(null, (IJavaElement)jProject.findType(PATH_ANNOTATION_CLASS));
            pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(APPLICATION_PATH_ANNOTATION_CLASS));
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)((Object)e));
            return new IType[0];
        }
        if (pattern != null) {
            SearchEngine engine = new SearchEngine();
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            AnnotationSearchRequestor requestor = new AnnotationSearchRequestor();
            SubProgressMonitor searchMonitor = new SubProgressMonitor(pm, searchTicks);
            try {
                engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)searchMonitor);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)e);
            }
            List<IType> result = requestor.getResult();
            if (includeSubtypes) {
                SubProgressMonitor subtypesMonitor = new SubProgressMonitor(pm, 75);
                subtypesMonitor.beginTask(LauncherMessages.JaxrsResourceSearchEngine_1, result.size());
                Set<IType> set = this.addSubtypes(result, (IProgressMonitor)subtypesMonitor, scope);
                return set.toArray(new IType[set.size()]);
            }
            return result.toArray(new IType[result.size()]);
        }
        return new IType[0];
    }

    private SearchPattern orPattern(SearchPattern pattern, IJavaElement element) {
        if (element == null) {
            return pattern;
        }
        if (pattern == null) {
            return SearchPattern.createPattern((IJavaElement)element, (int)2);
        }
        return SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)element, (int)2));
    }

    private Set<IType> addSubtypes(List<IType> types, IProgressMonitor monitor, IJavaSearchScope scope) {
        Iterator<IType> iterator = types.iterator();
        HashSet<IType> result = new HashSet<IType>(types.size());
        IType type = null;
        ITypeHierarchy hierarchy = null;
        IType[] subtypes = null;
        while (iterator.hasNext()) {
            type = iterator.next();
            if (result.add(type)) {
                try {
                    hierarchy = type.newTypeHierarchy(monitor);
                    subtypes = hierarchy.getAllSubtypes(type);
                    int i = 0;
                    while (i < subtypes.length) {
                        if (scope.encloses((IJavaElement)subtypes[i])) {
                            result.add(subtypes[i]);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.jaxrs.ui", (CoreException)((Object)e));
                }
            }
            monitor.worked(1);
        }
        return result;
    }

    public IType[] searchAnnotatedResource(IRunnableContext context, final IJavaProject jProject, final IJavaSearchScope scope, final boolean includeSubtypes) throws InvocationTargetException, InterruptedException {
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                res[0] = JaxrsResourceSearchEngine.this.findAnnotatedComponents(pm, jProject, scope, includeSubtypes);
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }
}

