/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.jaxrs.jdt.ProjectPathUtil;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.IRESTServiceConstants;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassOperation;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class RESTServiceDataModelProvider
extends NewJavaClassDataModelProvider
implements IRESTServiceConstants {
    public IDataModelOperation getDefaultOperation() {
        return new RESTServiceClassOperation(this.getDataModel());
    }

    public IStatus validate(String propertyName) {
        String pkgName;
        if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
            return null;
        }
        if (propertyName.equals("RestService.javasrcFolder")) {
            String srcFolderName = this.getStringProperty(propertyName);
            if (srcFolderName == null || srcFolderName.isEmpty()) {
                return Activator.createErrorStatus(Messages.RESTServiceDataModelProvider_srcFolderMissing);
            }
            return Status.OK_STATUS;
        }
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.PROJECT_NAME") || propertyName.equals("RestService.jpaProject")) {
            String projectName = this.getStringProperty(propertyName);
            boolean isEntityType = this.getBooleanProperty("RestService.entityType");
            if (isEntityType && propertyName.equals("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
                return Status.OK_STATUS;
            }
            if (!isEntityType && propertyName.equals("RestService.jpaProject")) {
                return Status.OK_STATUS;
            }
            if (projectName == null || projectName.isEmpty()) {
                return Activator.createErrorStatus(Messages.RESTServiceDataModelProvider_selectProject);
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IStatus status = ProjectPathUtil.validateExpectedJaxrsProjectClasspath((IJavaProject)javaProject);
                if (status != null && !status.isOK()) {
                    String msg = status.getMessage();
                    if (!msg.endsWith(".")) {
                        msg = String.valueOf(msg) + ". ";
                    }
                    msg = String.valueOf(msg) + Messages.RESTServiceDataModelProvider_notAJAXRSEnabledProject;
                    if (status.getSeverity() == 4) {
                        return Activator.createErrorStatus(msg);
                    }
                    if (status.getSeverity() == 2) {
                        return Activator.createWarningStatus(msg);
                    }
                }
                return status;
            }
            return null;
        }
        boolean isRootResourceType = this.getBooleanProperty("RestService.rootResourceType");
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            if (isRootResourceType) {
                return super.validate(propertyName);
            }
            return null;
        }
        boolean isContainerItemResourceType = this.getBooleanProperty("RestService.resourceSubResourceType");
        if (propertyName.equals("RestService.ResourceClassName") && isContainerItemResourceType) {
            String containerClassName = this.getStringProperty("RestService.ResourceClassName");
            String itemClassName = this.getStringProperty("RestService.SubResourceClassName");
            if (containerClassName.isEmpty()) {
                return Activator.createErrorStatus(Messages.RESTServiceDataModelProvider_resourceClassNameEmpty);
            }
            IStatus status = this.isDuplicateClassName(containerClassName, itemClassName);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            return this.validateClassName(this.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"), "RestService.ResourceClassName");
        }
        if (propertyName.equals("RestService.SubResourceClassName") && isContainerItemResourceType) {
            String containerClassName = this.getStringProperty("RestService.ResourceClassName");
            String itemClassName = this.getStringProperty("RestService.SubResourceClassName");
            if (itemClassName.isEmpty()) {
                return Activator.createErrorStatus(Messages.RESTServiceDataModelProvider_subResourceClassNameEmpty);
            }
            IStatus status = this.isDuplicateClassName(containerClassName, itemClassName);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
            return this.validateClassName(this.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"), "RestService.SubResourceClassName");
        }
        if (propertyName.equals("RestService.applicationClassPkg") && this.isPropertySet(propertyName)) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("RestService.applicationClass") && this.isPropertySet(propertyName)) {
            String appClassPkg = this.getStringProperty("RestService.applicationClassPkg");
            String appClassName = this.getStringProperty("RestService.applicationClass");
            if (appClassName == null || appClassName.isEmpty()) {
                return Activator.createErrorStatus("Application class is empty");
            }
            IStatus status = this.canCreateTypeInClasspath(appClassPkg, appClassName);
            if (status != null && !status.isOK()) {
                return this.checkIfAppClassExtendsApplication(appClassPkg, appClassName);
            }
            return this.validateClassName(appClassPkg, propertyName);
        }
        if (propertyName.equals("RestService.entityType") || propertyName.equals("RestService.entityNames")) {
            String entityNames;
            if (this.getBooleanProperty("RestService.entityType") && ((entityNames = this.getStringProperty("RestService.entityNames")) == null || entityNames.length() == 0)) {
                return Activator.createErrorStatus(Messages.RESTServiceDataModelProvider_noEntitiesSelected);
            }
            return Status.OK_STATUS;
        }
        IStatus status = super.validate(propertyName);
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE") && ((pkgName = this.getStringProperty(propertyName)) == null || pkgName.length() == 0)) {
            return Activator.createWarningStatus(Messages.RESTServiceDataModelProvider_defaultPkgWarning);
        }
        return status;
    }

    public IProject getTargetProject() {
        boolean isEntityType = this.model.getBooleanProperty("RestService.entityType");
        if (isEntityType) {
            String projectName = (String)this.model.getProperty("RestService.jpaProject");
            if (projectName != null && projectName.length() > 0) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            return null;
        }
        return super.getTargetProject();
    }

    protected IPackageFragmentRoot getJavaPackageFragmentRoot() {
        return WizardUtils.getPkgFragRoot(this.getTargetProject(), (String)this.getProperty("RestService.javasrcFolder"));
    }

    public Set<String> getPropertyNames() {
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        propertyNames.add("NewJavaClassDataModel.JAVA_PACKAGE");
        propertyNames.add("NewJavaClassDataModel.CLASS_NAME");
        propertyNames.add("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        propertyNames.add("NewJavaClassDataModel.SOURCE_FOLDER");
        propertyNames.add("RestService.rootResourceType");
        propertyNames.add("RestService.resourceSubResourceType");
        propertyNames.add("RestService.javasrcFolder");
        propertyNames.add("RestService.PatternType");
        propertyNames.add("RestService.ResourceClassName");
        propertyNames.add("RestService.SubResourceClassName");
        propertyNames.add("RestService.treeRootObject");
        propertyNames.add("RestService.isResourceClass");
        propertyNames.add("RestService.resourceURIType");
        propertyNames.add("RestService.clientURIType");
        propertyNames.add("RestService.applicationClassPkg");
        propertyNames.add("RestService.applicationClass");
        propertyNames.add("RestService.jpaProject");
        propertyNames.add("RestService.entityType");
        propertyNames.add("RestService.entityNames");
        propertyNames.add("RestService.entityFileNames");
        return propertyNames;
    }

    IStatus checkIfClassExists(String packageName, String className) {
        return this.canCreateTypeInClasspath(packageName, className);
    }

    IStatus checkIfAppClassExtendsApplication(String appClassPkg, String appClassName) {
        ICompilationUnit cu;
        IType type;
        IPackageFragmentRoot packRoot = this.getJavaPackageFragmentRoot();
        IPackageFragment pack = null;
        if (packRoot != null) {
            pack = packRoot.getPackageFragment(appClassPkg);
        }
        if (pack != null && (type = (cu = pack.getCompilationUnit(String.valueOf(appClassName) + ".java")).getType(appClassName)) != null) {
            try {
                IImportDeclaration[] importDecls;
                String superClassName = type.getSuperclassName();
                if (superClassName != null && superClassName.equals("javax.ws.rs.core.Application")) {
                    return Status.OK_STATUS;
                }
                if (superClassName != null && superClassName.equals("Application") && (importDecls = cu.getImports()) != null) {
                    IImportDeclaration[] iImportDeclarationArray = importDecls;
                    int n = importDecls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IImportDeclaration importDecl = iImportDeclarationArray[n2];
                        String elementName = importDecl.getElementName();
                        if (elementName.equals("javax.ws.rs.core.Application") || elementName.equals("javax.ws.rs.core.*")) {
                            return Status.OK_STATUS;
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                Activator.log(e);
            }
        }
        return Activator.createErrorStatus("'" + appClassName + Messages.RESTServiceDataModelProvider_classNameAlreadyExists);
    }

    private IStatus validateClassName(String packageName, String propertyName) {
        IStatus existsStatus;
        String className = this.getStringProperty(propertyName);
        IStatus result = this.validateJavaClassName(className);
        if (result != null && result.getSeverity() != 4 && (existsStatus = this.canCreateTypeInClasspath(packageName, className)).matches(6)) {
            result = existsStatus;
        }
        return result;
    }

    private IStatus isDuplicateClassName(String containerClassName, String itemClassName) {
        if (containerClassName != null && itemClassName != null && itemClassName.equals(containerClassName)) {
            return Activator.createErrorStatus(Messages.RESTServiceDataModelProvider_resourceAndSubResourceCannotHavesameName);
        }
        return null;
    }

    private IStatus validateJavaPackage(String pkgName) {
        if (pkgName != null && pkgName.trim().length() > 0) {
            IStatus javaStatus = JavaConventions.validatePackageName((String)pkgName, (String)"1.3", (String)"1.3");
            if (javaStatus.getSeverity() == 4) {
                return WTPCommonPlugin.createErrorStatus((String)javaStatus.getMessage());
            }
            if (javaStatus.getSeverity() == 2) {
                return WTPCommonPlugin.createWarningStatus((String)javaStatus.getMessage());
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

