/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTApplicationClassPage;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassNamePage;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDataModelProvider;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDetailsPage;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JpaContextRoot;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class RESTServiceClassWizard
extends DataModelWizard
implements INewWizard {
    private RESTServiceDetailsPage serviceDetailsPage = null;
    private RESTApplicationClassPage appClassPage = null;
    private Map<String, String> entityNameToPrimaryKeyTypeName = null;
    private RESTServiceDataModelProvider dataModelProvider = null;

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.getDataModel();
        this.setWindowTitle(this.getTitle());
        this.setDefaultPageImageDescriptor(Activator.Images.REST_WIZARD_BANNER.getImageDescriptor());
    }

    protected IDataModelProvider getDefaultProvider() {
        if (this.dataModelProvider == null) {
            this.dataModelProvider = new RESTServiceDataModelProvider();
        }
        return this.dataModelProvider;
    }

    protected boolean prePerformFinish() {
        this.serviceDetailsPage.initializeFromFirstPage(this);
        return super.prePerformFinish();
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish();
        if (!canFinish) {
            return false;
        }
        return this.serviceDetailsPage.isPageComplete() && this.appClassPage.isPageComplete();
    }

    protected void doAddPages() {
        RESTServiceClassNamePage classNamePage = new RESTServiceClassNamePage(this.getDataModel(), "classNamePage");
        this.addPage((IWizardPage)classNamePage);
        classNamePage.setWizard((IWizard)this);
        this.serviceDetailsPage = new RESTServiceDetailsPage(this.getDataModel(), "detailsPage");
        this.addPage((IWizardPage)this.serviceDetailsPage);
        this.serviceDetailsPage.setWizard((IWizard)this);
        this.appClassPage = new RESTApplicationClassPage(this.getDataModel(), "applicationClassPage");
        this.addPage((IWizardPage)this.appClassPage);
        this.appClassPage.setWizard((IWizard)this);
    }

    protected void postPerformFinish() throws InvocationTargetException {
        this.appClassPage.saveApplicationPkgAndClassName();
        this.openJavaClass();
        this.updatePerspective();
        super.postPerformFinish();
    }

    void initDetailsPage() {
        this.serviceDetailsPage.initializeFromFirstPage(this);
    }

    void initAppClassPage() {
        this.appClassPage.initializePkgAndClassName(this);
    }

    String getPrimaryKeyTypeName(JpaProject jpaProject, String entityName) {
        String primaryKeyTypeName;
        if (this.entityNameToPrimaryKeyTypeName == null) {
            this.entityNameToPrimaryKeyTypeName = new HashMap<String, String>();
        }
        if ((primaryKeyTypeName = this.entityNameToPrimaryKeyTypeName.get(entityName)) == null) {
            primaryKeyTypeName = RESTServiceClassWizard.getPKTypeNameFromEntity(jpaProject, entityName);
            this.entityNameToPrimaryKeyTypeName.put(entityName, primaryKeyTypeName);
        }
        return primaryKeyTypeName;
    }

    private static String getPKTypeNameFromEntity(JpaProject jpaProject, String entityName) {
        if (jpaProject == null || entityName == null) {
            return null;
        }
        JpaContextRoot contextModelRoot = jpaProject.getContextRoot();
        PersistenceXml persistenceXml = contextModelRoot.getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return null;
        }
        PersistenceUnit pu1 = (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
        Entity entity = pu1.getEntity(entityName);
        String primaryKeyTypeName = null;
        if (entity != null) {
            SpecifiedPersistentAttribute pa = entity.getIdAttribute();
            if (pa != null) {
                primaryKeyTypeName = pa.getTypeName();
            } else {
                for (PersistentAttribute attr : entity.getPersistentType().getAllAttributes()) {
                    AttributeMapping mapping = attr.getMapping();
                    if (!(mapping instanceof BaseEmbeddedMapping)) continue;
                    primaryKeyTypeName = attr.getTypeName();
                    break;
                }
            }
        }
        return primaryKeyTypeName;
    }

    private String getTitle() {
        return Messages.RESTServiceClassWizard_wizardTitle;
    }

    private void openJavaClass() {
        IDataModel model = this.getDataModel();
        String containerPath = model.getStringProperty("RestService.javasrcFolder");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String packageName = model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String projectName = WizardUtils.getProjectName(model);
        IProject project = root.getProject(projectName);
        IFolder sourceFolder = project.getFolder(containerPath);
        IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)project);
        IFile[] files = null;
        if (sourceFolder.exists()) {
            List fileList;
            IPackageFragmentRoot packageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            IPackageFragment packageFragment = null;
            if (packageFragmentRoot != null) {
                packageFragment = packageFragmentRoot.getPackageFragment(packageName);
            }
            if (packageFragment == null) {
                return;
            }
            boolean isRootResourceType = model.getBooleanProperty("RestService.rootResourceType");
            boolean isContainerResourceType = model.getBooleanProperty("RestService.resourceSubResourceType");
            if (isRootResourceType) {
                files = new IFile[1];
                String className = model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
                IFile file = this.getFile(packageFragment, className);
                if (file != null) {
                    files[0] = file;
                }
            } else if (isContainerResourceType) {
                files = new IFile[2];
                String className = model.getStringProperty("RestService.SubResourceClassName");
                IFile file = this.getFile(packageFragment, className);
                if (file != null) {
                    files[0] = file;
                }
                if ((file = this.getFile(packageFragment, className = model.getStringProperty("RestService.ResourceClassName"))) != null) {
                    files[1] = file;
                }
            } else if (model.getBooleanProperty("RestService.entityType") && (fileList = (List)model.getProperty("RestService.entityFileNames")) != null && fileList.size() > 0) {
                int len = fileList.size();
                files = new IFile[len];
                int i = 0;
                while (i < len) {
                    files[i] = (IFile)fileList.get(i);
                    ++i;
                }
            }
        }
        try {
            if (files != null) {
                this.openEditor(files);
            }
        }
        catch (Exception cantOpen) {
            Activator.log(cantOpen);
        }
    }

    private IFile getFile(IPackageFragment packageFragment, String className) {
        ICompilationUnit cu = packageFragment.getCompilationUnit(String.valueOf(className) + ".java");
        IResource resource = cu.getResource();
        if (resource.exists() && resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private void openEditor(final IFile ... files) {
        if (files != null && files.length > 0) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IFile[] iFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile file = iFileArray[n2];
                            if (file != null) {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                            }
                            ++n2;
                        }
                    }
                    catch (PartInitException e) {
                        Activator.log(e);
                    }
                }
            });
        }
    }

    protected void updatePerspective() {
        try {
            Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("oracle.eclipse.tools.jaxrs.ui.properties.RestPropertiesView");
        }
        catch (PartInitException partInitException) {}
    }
}

