/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.EntitySelectionDialog;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.IRESTServiceConstants;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassWizard;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class RESTServiceClassNamePage
extends DataModelWizardPage
implements IRESTServiceConstants {
    private Button rootResourceBtn;
    private Button subResourcesBtn;
    private Button entitiesAccessBtn;
    private Label projectNameLabel;
    private Combo projectNameCombo;
    private Label folderLabel;
    private Combo srcFolderCombo;
    private Text packageText;
    private Button packageButton;
    private Label packageLabel;
    private Text classText;
    private Label classLabel;
    private Label resourceClassLabel;
    private Text resourceClassText;
    private Label subResourceClassLabel;
    private Text subResourceClassText;
    private Label subResourceTypeLabel;
    private Button uriResourceTypeButton;
    private Button clientTypeButton;
    private Label jpaProjLabel;
    private Combo jpaProjectCombo;
    private Label entitiesLabel;
    private Text entitiesText;
    private Button entitiesBtn;
    private Label entityResourcesTitleLabel;
    private Group patternDetailsGroup;
    private SelectionListener srcFolderListener;
    private Text descriptionText;

    protected String[] getValidationPropertyNames() {
        return new String[]{"IArtifactEditOperationDataModelProperties.PROJECT_NAME", "RestService.javasrcFolder", "NewJavaClassDataModel.JAVA_PACKAGE", "NewJavaClassDataModel.CLASS_NAME", "RestService.ResourceClassName", "RestService.SubResourceClassName", "RestService.rootResourceType", "RestService.resourceSubResourceType", "RestService.entityNames", "RestService.jpaProject", "RestService.entityType"};
    }

    protected RESTServiceClassNamePage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(Messages.RESTServiceClassNamePage_pageDescription);
        this.setTitle(Messages.RESTServiceClassNamePage_pageTitle);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topLevelComp = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        topLevelComp.setLayoutData((Object)data);
        FormLayout layout = new FormLayout();
        topLevelComp.setLayout((Layout)layout);
        Composite patternTypeComposite = this.createPatternTypeComposite(topLevelComp);
        this.patternDetailsGroup = new Group(topLevelComp, 4);
        this.patternDetailsGroup.setLayout((Layout)new FormLayout());
        FormData stackCompFormData = new FormData();
        stackCompFormData.top = new FormAttachment((Control)patternTypeComposite, 10);
        stackCompFormData.left = new FormAttachment(0, 10);
        stackCompFormData.right = new FormAttachment(100, -10);
        stackCompFormData.bottom = new FormAttachment(100, -5);
        this.patternDetailsGroup.setLayoutData((Object)stackCompFormData);
        this.patternDetailsGroup.setText(Messages.RESTServiceClassDetailsPage_rootResourceClassLabel);
        this.createRootResourceControls((Composite)this.patternDetailsGroup);
        this.showContainerControls(false);
        Dialog.applyDialogFont((Control)parent);
        ((RESTServiceClassWizard)this.getWizard()).initDetailsPage();
        ((RESTServiceClassWizard)this.getWizard()).initAppClassPage();
        return topLevelComp;
    }

    private Composite createPatternTypeComposite(Composite topLevelComp) {
        Composite patternTypeComposite = new Composite(topLevelComp, 0);
        patternTypeComposite.setLayout((Layout)new GridLayout(2, false));
        FormData patternTypeCompData = new FormData();
        patternTypeCompData.top = new FormAttachment(0, 5);
        patternTypeCompData.left = new FormAttachment(0, 5);
        patternTypeCompData.right = new FormAttachment(100, -5);
        patternTypeComposite.setLayoutData((Object)patternTypeCompData);
        this.rootResourceBtn = new Button(patternTypeComposite, 16);
        this.rootResourceBtn.setText(Messages.RESTServiceClassDetailsPage_singleRootResourceBtn);
        this.synchHelper.synchRadio(this.rootResourceBtn, "RestService.rootResourceType", null);
        this.descriptionText = new Text(patternTypeComposite, 2634);
        this.rootResourceBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RESTServiceClassNamePage.this.setGroupTitle();
                if (RESTServiceClassNamePage.this.projectNameCombo != null && !RESTServiceClassNamePage.this.projectNameCombo.isVisible()) {
                    String projectName = RESTServiceClassNamePage.this.projectNameCombo.getText();
                    RESTServiceClassNamePage.this.setSrcFolder(projectName);
                }
                RESTServiceClassNamePage.this.showContainerControls(false);
                RESTServiceClassNamePage.this.showEntityControls(false);
                RESTServiceClassNamePage.this.descriptionText.setText(Messages.RESTServiceClassDetailsPage_rootResourceTextDescription);
                RESTServiceClassNamePage.this.patternDetailsGroup.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData descTextData = new GridData();
        descTextData.verticalSpan = 3;
        descTextData.verticalAlignment = 4;
        descTextData.horizontalAlignment = 4;
        descTextData.grabExcessHorizontalSpace = true;
        descTextData.widthHint = 200;
        this.descriptionText.setLayoutData((Object)descTextData);
        this.subResourcesBtn = new Button(patternTypeComposite, 16);
        this.subResourcesBtn.setText(Messages.RESTServiceClassDetailsPage_subResourcesBtn);
        this.synchHelper.synchRadio(this.subResourcesBtn, "RestService.resourceSubResourceType", null);
        this.subResourcesBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RESTServiceClassNamePage.this.createContainerPatternControls((Composite)RESTServiceClassNamePage.this.patternDetailsGroup);
                if (RESTServiceClassNamePage.this.projectNameCombo != null && !RESTServiceClassNamePage.this.projectNameCombo.isVisible()) {
                    String projectName = RESTServiceClassNamePage.this.projectNameCombo.getText();
                    RESTServiceClassNamePage.this.setSrcFolder(projectName);
                }
                RESTServiceClassNamePage.this.showEntityControls(false);
                RESTServiceClassNamePage.this.setGroupTitle();
                RESTServiceClassNamePage.this.showContainerControls(true);
                String containerClass = RESTServiceClassNamePage.this.resourceClassText.getText();
                String itemClass = RESTServiceClassNamePage.this.subResourceClassText.getText();
                IDataModel dataModel = RESTServiceClassNamePage.this.getDataModel();
                if (containerClass == null || containerClass.isEmpty()) {
                    RESTServiceClassNamePage.this.resourceClassText.setText(WizardUtils.getUniqueClassName(dataModel, (RESTServiceClassWizard)RESTServiceClassNamePage.this.getWizard(), "Resource"));
                }
                if (itemClass == null || itemClass.isEmpty()) {
                    RESTServiceClassNamePage.this.subResourceClassText.setText(WizardUtils.getUniqueClassName(dataModel, (RESTServiceClassWizard)RESTServiceClassNamePage.this.getWizard(), "SubResource"));
                }
                RESTServiceClassNamePage.this.descriptionText.setText(String.valueOf(Messages.RESTServiceClassDetailsPage_subResourcesTextdescription1) + Messages.RESTServiceClassDetailsPage_subResourcesTextdescription2);
                RESTServiceClassNamePage.this.patternDetailsGroup.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.entitiesAccessBtn = new Button(patternTypeComposite, 16);
        this.entitiesAccessBtn.setText(Messages.RESTServiceClassDetailsPage_entitiesAccessBtn);
        this.synchHelper.synchRadio(this.entitiesAccessBtn, "RestService.entityType", null);
        this.entitiesAccessBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RESTServiceClassNamePage.this.descriptionText.setText(Messages.RESTServiceClassNamePage_jpaOptionText);
                RESTServiceClassNamePage.this.createEntityControls((Composite)RESTServiceClassNamePage.this.patternDetailsGroup);
                if (RESTServiceClassNamePage.this.jpaProjectCombo != null) {
                    String projectName = RESTServiceClassNamePage.this.jpaProjectCombo.getText();
                    RESTServiceClassNamePage.this.setSrcFolder(projectName);
                }
                RESTServiceClassNamePage.this.showContainerControls(false);
                RESTServiceClassNamePage.this.showEntityControls(true);
                RESTServiceClassNamePage.this.patternDetailsGroup.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.rootResourceBtn.setSelection(true);
        this.descriptionText.setText(Messages.RESTServiceClassDetailsPage_rootResourceTextDescription);
        this.getDataModel().setBooleanProperty("RestService.rootResourceType", true);
        return patternTypeComposite;
    }

    private void createRootResourceControls(Composite parent) {
        this.createProjectNameGroup(parent);
        this.createSourceFolderGroup(parent);
        this.createPackageGroup(parent);
        this.createClassnameGroup(parent);
    }

    private void createContainerPatternControls(Composite parent) {
        this.createResourceClassnameGroup(parent);
        this.createSubResourceClassnameGroup(parent);
        this.createSubResourceURITypeControls(parent);
    }

    private void setGroupTitle() {
        if (this.rootResourceBtn.getSelection()) {
            this.patternDetailsGroup.setText(Messages.RESTServiceClassDetailsPage_rootResourceClassLabel);
        }
        if (this.subResourcesBtn.getSelection()) {
            this.patternDetailsGroup.setText(Messages.RESTServiceClassDetailsPage_containerAndItemResourceClass);
        }
        if (this.entitiesAccessBtn.getSelection()) {
            this.patternDetailsGroup.setText(Messages.RESTServiceClassNamePage_entitiesToExposeLabel);
        }
    }

    private void createProjectNameGroup(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(Messages.RESTServiceClassDetailsPage_projectLabel);
        this.projectNameCombo = new Combo(parent, 2056);
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.initializeProjectList();
        this.projectNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String projectName = RESTServiceClassNamePage.this.projectNameCombo.getText();
                RESTServiceClassNamePage.this.setSrcFolder(projectName);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void layoutProjectNameGroup() {
        this.projectNameLabel.setVisible(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)this.projectNameCombo, 0, 0x1000000);
        this.projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo.setVisible(true);
        data = new FormData();
        Control secondControl = this.getSecondControlAlignment();
        data.left = secondControl == this.projectNameCombo ? new FormAttachment((Control)this.projectNameLabel, 10) : new FormAttachment(secondControl, 0, 16384);
        data.width = 90;
        this.projectNameCombo.setLayoutData((Object)data);
    }

    private void createSourceFolderGroup(Composite composite) {
        this.folderLabel = new Label(composite, 16384);
        this.folderLabel.setText(Messages.RESTServiceClassDetailsPage_sourceFolderLabel);
        this.srcFolderCombo = new Combo(composite, 2056);
        if (this.srcFolderListener == null) {
            this.srcFolderListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String srcFolderName = RESTServiceClassNamePage.this.srcFolderCombo.getText();
                    RESTServiceClassNamePage.this.getDataModel().setStringProperty("RestService.javasrcFolder", srcFolderName);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            };
        }
        IPackageFragmentRoot root = this.getSelectedPackageFragmentRoot();
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                this.srcFolderCombo.removeAll();
                return;
            }
            IJavaProjectLite javaProjLite = JavaCoreLite.create((IProject)project);
            if (javaProjLite == null) {
                this.srcFolderCombo.removeAll();
                return;
            }
            List sourceContainers = JavaLiteUtilities.getJavaSourceContainers((IJavaProjectLite)javaProjLite);
            for (IContainer sourceContainer : sourceContainers) {
                String name = sourceContainer.getName();
                if (name.startsWith(".")) continue;
                this.srcFolderCombo.add(name);
            }
            IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (root == null || !root.getJavaProject().getProject().equals((Object)targetProject)) {
                this.srcFolderCombo.setText(this.srcFolderCombo.getItem(0));
            } else {
                String name = root.getElementName();
                if (!name.startsWith(".")) {
                    this.srcFolderCombo.setText(name);
                }
            }
        }
        this.getDataModel().setStringProperty("RestService.javasrcFolder", this.srcFolderCombo.getText());
        this.srcFolderCombo.addSelectionListener(this.srcFolderListener);
    }

    private void layoutSourceFolderGroup() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.projectNameCombo, 0, 0x1000000);
        data.right = new FormAttachment((Control)this.srcFolderCombo, -10);
        this.folderLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.projectNameCombo, 0, 0x1000000);
        data.right = new FormAttachment(100, -5);
        data.width = 90;
        this.srcFolderCombo.setLayoutData((Object)data);
    }

    private void setSourceFolder(String projectName) {
        if (projectName == null || projectName.length() == 0) {
            return;
        }
        this.srcFolderCombo.removeSelectionListener(this.srcFolderListener);
        this.srcFolderCombo.removeAll();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return;
        }
        IJavaProjectLite javaProjLite = JavaCoreLite.create((IProject)project);
        if (javaProjLite == null) {
            return;
        }
        List sourceContainers = JavaLiteUtilities.getJavaSourceContainers((IJavaProjectLite)javaProjLite);
        for (IContainer sourceContainer : sourceContainers) {
            String name = sourceContainer.getName();
            if (name.startsWith(".")) continue;
            this.srcFolderCombo.add(name);
        }
        if (this.srcFolderCombo.getItemCount() > 0) {
            this.srcFolderCombo.setText(this.srcFolderCombo.getItem(0));
            this.getDataModel().setStringProperty("RestService.javasrcFolder", this.srcFolderCombo.getText());
        } else {
            this.getDataModel().setStringProperty("RestService.javasrcFolder", "");
        }
        this.srcFolderCombo.addSelectionListener(this.srcFolderListener);
    }

    private void createPackageGroup(Composite composite) {
        this.packageLabel = new Label(composite, 16384);
        this.packageLabel.setText(Messages.RESTServiceClassDetailsPage_packageLabel);
        this.packageText = new Text(composite, 2052);
        this.packageButton = new Button(composite, 8);
        this.synchHelper.synchText(this.packageText, "NewJavaClassDataModel.JAVA_PACKAGE", null);
        IPackageFragment packageFragment = this.getSelectedPackageFragment();
        String targetProject = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (packageFragment != null && packageFragment.exists() && packageFragment.getJavaProject().getElementName().equals(targetProject)) {
            IPackageFragmentRoot root = this.getPackageFragmentRoot(packageFragment);
            if (root != null) {
                this.srcFolderCombo.setText(root.getPath().toString());
            }
            this.model.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)packageFragment.getElementName());
        }
        this.packageButton.setText(Messages.RESTServiceClassDetailsPage_browseBtn);
        this.packageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RESTServiceClassNamePage.this.packageText.setText(WizardUtils.getPkgNameFromPkgDialog(RESTServiceClassNamePage.this.getShell(), RESTServiceClassNamePage.this.model));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void layoutPackageGroup() {
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        formData.top = new FormAttachment((Control)this.packageText, 0, 0x1000000);
        this.packageLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        formData.top = new FormAttachment((Control)this.projectNameCombo, 5);
        formData.right = new FormAttachment((Control)this.packageButton, -10);
        this.packageText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment((Control)this.packageLabel, 0, 0x1000000);
        this.packageButton.setLayoutData((Object)formData);
    }

    private void createClassnameGroup(Composite composite) {
        this.classLabel = new Label(composite, 16384);
        this.classLabel.setText(Messages.RESTServiceClassDetailsPage_classNameLabel);
        this.classText = new Text(composite, 2052);
        this.synchHelper.synchText(this.classText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.classText.setFocus();
    }

    private void layoutClassnameGroup() {
        this.classLabel.setVisible(true);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        formData.top = new FormAttachment((Control)this.classText, 0, 0x1000000);
        this.classLabel.setLayoutData((Object)formData);
        this.classText.setVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.classLabel, 5);
        formData.top = new FormAttachment((Control)this.packageText, 5);
        formData.right = new FormAttachment((Control)this.packageButton, 0, 131072);
        this.classText.setLayoutData((Object)formData);
    }

    private void createResourceClassnameGroup(Composite composite) {
        if (this.resourceClassLabel != null) {
            return;
        }
        this.resourceClassLabel = new Label(composite, 16384);
        this.resourceClassLabel.setText(Messages.RESTServiceClassDetailsPage_resourceClassNameLabel);
        this.resourceClassText = new Text(composite, 2052);
        this.synchHelper.synchText(this.resourceClassText, "RestService.ResourceClassName", null);
    }

    private void layoutResourceClassnameGroup() {
        this.resourceClassLabel.setVisible(true);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        formData.top = new FormAttachment((Control)this.resourceClassText, 0, 0x1000000);
        this.resourceClassLabel.setLayoutData((Object)formData);
        this.resourceClassText.setVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        formData.top = new FormAttachment((Control)this.packageText, 5);
        formData.right = new FormAttachment((Control)this.packageButton, 0, 131072);
        this.resourceClassText.setLayoutData((Object)formData);
    }

    private void createSubResourceClassnameGroup(Composite composite) {
        if (this.subResourceClassLabel != null) {
            return;
        }
        this.subResourceClassLabel = new Label(composite, 16384);
        this.subResourceClassLabel.setText(Messages.RESTServiceClassDetailsPage_subResourceClassNameLabel);
        this.subResourceClassText = new Text(composite, 2052);
        this.synchHelper.synchText(this.subResourceClassText, "RestService.SubResourceClassName", null);
    }

    private void layoutSubResourceClassnameGroup() {
        this.subResourceClassLabel.setVisible(true);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        formData.top = new FormAttachment((Control)this.subResourceClassText, 0, 0x1000000);
        this.subResourceClassLabel.setLayoutData((Object)formData);
        this.subResourceClassText.setVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.subResourceClassLabel, 5);
        formData.top = new FormAttachment((Control)this.resourceClassText, 5);
        formData.right = new FormAttachment((Control)this.packageButton, 0, 131072);
        this.subResourceClassText.setLayoutData((Object)formData);
    }

    private void createSubResourceURITypeControls(Composite composite) {
        if (this.subResourceTypeLabel != null) {
            return;
        }
        this.subResourceTypeLabel = new Label(composite, 16384);
        this.subResourceTypeLabel.setText(Messages.RESTServiceClassDetailsPage_newSubResourceURILabel);
        this.uriResourceTypeButton = new Button(composite, 16);
        this.uriResourceTypeButton.setText(Messages.RESTServiceClassDetailsPage_resourceTypeBtn);
        this.synchHelper.synchRadio(this.uriResourceTypeButton, "RestService.resourceURIType", null);
        this.clientTypeButton = new Button(composite, 16);
        this.clientTypeButton.setText(Messages.RESTServiceClassDetailsPage_clientTypeBtn);
        this.synchHelper.synchRadio(this.clientTypeButton, "RestService.clientURIType", null);
        this.uriResourceTypeButton.setSelection(true);
    }

    private void layoutContainerItemTypeControls() {
        this.subResourceTypeLabel.setVisible(true);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.projectNameLabel, 0, 16384);
        formData.top = new FormAttachment((Control)this.uriResourceTypeButton, 0, 0x1000000);
        this.subResourceTypeLabel.setLayoutData((Object)formData);
        this.uriResourceTypeButton.setVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        formData.top = new FormAttachment((Control)this.subResourceClassText, 5);
        this.uriResourceTypeButton.setLayoutData((Object)formData);
        this.clientTypeButton.setVisible(true);
        formData = new FormData();
        formData.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        formData.top = new FormAttachment((Control)this.uriResourceTypeButton, 5);
        this.clientTypeButton.setLayoutData((Object)formData);
    }

    private void createEntityControls(Composite parent) {
        if (this.entitiesLabel != null) {
            return;
        }
        this.jpaProjLabel = new Label(parent, 16384);
        this.jpaProjLabel.setText(Messages.RESTServiceClassNamePage_jpaProjectLabel);
        this.jpaProjectCombo = new Combo(parent, 2056);
        this.synchHelper.synchCombo(this.jpaProjectCombo, "RestService.jpaProject", null);
        this.initializeJpaProjectList();
        this.jpaProjectCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String projectName = RESTServiceClassNamePage.this.jpaProjectCombo.getText();
                RESTServiceClassNamePage.this.setSrcFolder(projectName);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.entitiesLabel = new Label(parent, 16384);
        this.entitiesLabel.setText(Messages.RESTServiceClassNamePage_entitiesLabel);
        this.entitiesText = new Text(parent, 2060);
        this.synchHelper.synchText(this.entitiesText, "RestService.entityNames", null);
        this.entitiesBtn = new Button(parent, 8);
        this.entitiesBtn.setText(Messages.RESTServiceClassNamePage_browseEntities);
        this.entitiesBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String jpaProjectName = RESTServiceClassNamePage.this.getDataModel().getStringProperty("RestService.jpaProject");
                if (jpaProjectName != null) {
                    EntitySelectionDialog dlg;
                    String entities = RESTServiceClassNamePage.this.entitiesText.getText();
                    List<String> existingEntityNames = Collections.emptyList();
                    if (entities.length() > 0) {
                        existingEntityNames = new ArrayList();
                        StringTokenizer tokenizer = new StringTokenizer(entities, ", ");
                        while (tokenizer.hasMoreTokens()) {
                            existingEntityNames.add(tokenizer.nextToken());
                        }
                    }
                    if ((dlg = new EntitySelectionDialog(e.display.getActiveShell(), existingEntityNames, jpaProjectName)).open() == 0) {
                        List<String> selectedEntities = dlg.getSelectedEntities();
                        StringBuffer sb = new StringBuffer();
                        if (selectedEntities != null) {
                            int i = 0;
                            int len = selectedEntities.size();
                            while (i < len) {
                                String entityName = selectedEntities.get(i);
                                sb.append(entityName);
                                if (i != len - 1) {
                                    sb.append(", ");
                                }
                                ++i;
                            }
                        }
                        RESTServiceClassNamePage.this.entitiesText.setText(sb.toString());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.entityResourcesTitleLabel = new Label(parent, 16384);
        this.entityResourcesTitleLabel.setText(Messages.RESTServiceClassNamePage_entityResourceClassesLabel);
        this.entityResourcesTitleLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
    }

    private void layoutJpaProjectNameGroup() {
        this.jpaProjLabel.setVisible(true);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)this.jpaProjectCombo, 0, 0x1000000);
        this.jpaProjLabel.setLayoutData((Object)data);
        this.jpaProjectCombo.setVisible(true);
        data = new FormData();
        data.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        data.width = 90;
        this.jpaProjectCombo.setLayoutData((Object)data);
    }

    private void layoutEntitiesGroup() {
        this.entitiesLabel.setVisible(true);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.entitiesBtn, 0, 0x1000000);
        formData.left = new FormAttachment((Control)this.jpaProjLabel, 0, 16384);
        this.entitiesLabel.setLayoutData((Object)formData);
        this.entitiesText.setVisible(true);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.entitiesBtn, 0, 0x1000000);
        formData.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        formData.right = new FormAttachment((Control)this.entitiesBtn, -10);
        this.entitiesText.setLayoutData((Object)formData);
        this.entitiesBtn.setVisible(true);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment((Control)this.jpaProjectCombo, 5);
        this.entitiesBtn.setLayoutData((Object)formData);
    }

    private void layoutEntityResourcesTitleLabel() {
        this.entityResourcesTitleLabel.setVisible(true);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.entitiesBtn, 10);
        formData.left = new FormAttachment((Control)this.jpaProjLabel, 0, 16384);
        this.entityResourcesTitleLabel.setLayoutData((Object)formData);
    }

    private void layoutJPASrcFolderGroup() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.jpaProjLabel, 0, 16384);
        data.top = new FormAttachment((Control)this.srcFolderCombo, 0, 0x1000000);
        this.folderLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.folderLabel, 10);
        data.top = new FormAttachment((Control)this.entityResourcesTitleLabel, 5);
        data.width = 90;
        this.srcFolderCombo.setLayoutData((Object)data);
    }

    private void layoutJPAPkgGroup() {
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.jpaProjLabel, 0, 16384);
        formData.top = new FormAttachment((Control)this.packageButton, 0, 0x1000000);
        this.packageLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(this.getSecondControlAlignment(), 0, 16384);
        formData.top = new FormAttachment((Control)this.packageButton, 0, 0x1000000);
        formData.right = new FormAttachment((Control)this.packageButton, -10);
        this.packageText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment((Control)this.srcFolderCombo, 5);
        this.packageButton.setLayoutData((Object)formData);
    }

    private void showContainerControls(boolean visible) {
        this.projectNameLabel.setText(Messages.RESTServiceClassDetailsPage_projectLabel);
        this.layoutProjectNameGroup();
        this.layoutSourceFolderGroup();
        this.layoutPackageGroup();
        this.layoutClassnameGroup();
        if (visible) {
            RESTServiceClassNamePage.hideControl((Control)this.classLabel);
            RESTServiceClassNamePage.hideControl((Control)this.classText);
            this.layoutResourceClassnameGroup();
            this.layoutSubResourceClassnameGroup();
            this.layoutContainerItemTypeControls();
        } else {
            RESTServiceClassNamePage.hideControl((Control)this.resourceClassLabel);
            RESTServiceClassNamePage.hideControl((Control)this.resourceClassText);
            RESTServiceClassNamePage.hideControl((Control)this.subResourceClassLabel);
            RESTServiceClassNamePage.hideControl((Control)this.subResourceClassText);
            RESTServiceClassNamePage.hideControl((Control)this.subResourceTypeLabel);
            RESTServiceClassNamePage.hideControl((Control)this.uriResourceTypeButton);
            RESTServiceClassNamePage.hideControl((Control)this.clientTypeButton);
        }
    }

    private void showEntityControls(boolean visible) {
        if (visible) {
            RESTServiceClassNamePage.hideControl((Control)this.classLabel);
            RESTServiceClassNamePage.hideControl((Control)this.classText);
            RESTServiceClassNamePage.hideControl((Control)this.projectNameLabel);
            RESTServiceClassNamePage.hideControl((Control)this.projectNameCombo);
            this.layoutJpaProjectNameGroup();
            this.layoutEntitiesGroup();
            this.layoutEntityResourcesTitleLabel();
            this.layoutJPASrcFolderGroup();
            this.layoutJPAPkgGroup();
        } else {
            RESTServiceClassNamePage.hideControl((Control)this.jpaProjLabel);
            RESTServiceClassNamePage.hideControl((Control)this.jpaProjectCombo);
            RESTServiceClassNamePage.hideControl((Control)this.entitiesLabel);
            RESTServiceClassNamePage.hideControl((Control)this.entitiesText);
            RESTServiceClassNamePage.hideControl((Control)this.entitiesBtn);
            RESTServiceClassNamePage.hideControl((Control)this.entityResourcesTitleLabel);
        }
    }

    private void setSrcFolder(String projectName) {
        if (this.srcFolderCombo != null && this.packageText != null) {
            this.setSourceFolder(projectName);
        }
    }

    protected IPackageFragmentRoot getPackageFragmentRoot(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            return null;
        }
        if (packageFragment.getParent() instanceof IPackageFragment) {
            return this.getPackageFragmentRoot((IPackageFragment)packageFragment.getParent());
        }
        if (packageFragment.getParent() instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)packageFragment.getParent();
        }
        return null;
    }

    private IPackageFragmentRoot getSelectedPackageFragmentRoot() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getElementType() == 3) {
            return (IPackageFragmentRoot)element;
        }
        return null;
    }

    private IProject getSelectedProject() {
        TreePath path;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        IResource resource = this.getResource(selectedElement);
        if (resource != null) {
            return resource.getProject();
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        if (selection instanceof TreeSelection && ((TreeSelection)selection).getPaths().length > 0 && (path = ((TreeSelection)selection).getPaths()[0]).getSegmentCount() > 0 && path.getSegment(0) instanceof IProject) {
            return (IProject)path.getSegment(0);
        }
        return null;
    }

    private void initializeProjectList() {
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        IProject selectedProject = null;
        String projectName = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        if (selectedProject == null) {
            selectedProject = this.getSelectedProject();
        }
        if (selectedProject != null && selectedProject.isAccessible()) {
            this.projectNameCombo.setText(selectedProject.getName());
            projectName = selectedProject.getName();
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
        }
        if (projectName == null && names.length > 0) {
            projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && projectName != null) {
            this.projectNameCombo.setText(projectName);
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)projectName);
        }
    }

    private void initializeJpaProjectList() {
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (JPAUtils.isJpaProject((IProject)project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.jpaProjectCombo.setItems(names);
        String projectName = null;
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject != null && selectedProject.isAccessible() && JPAUtils.isJpaProject((IProject)selectedProject)) {
            projectName = selectedProject.getName();
            this.jpaProjectCombo.setText(projectName);
            this.model.setProperty("RestService.jpaProject", (Object)projectName);
        }
        if (projectName == null && names.length > 0) {
            projectName = names[0];
        }
        if ((this.jpaProjectCombo.getText() == null || this.jpaProjectCombo.getText().length() == 0) && projectName != null) {
            this.jpaProjectCombo.setText(projectName);
            this.model.setProperty("RestService.jpaProject", (Object)projectName);
        }
    }

    private Control getSecondControlAlignment() {
        return this.rootResourceBtn.getSelection() ? this.classText : (this.subResourcesBtn.getSelection() ? this.subResourceClassText : this.srcFolderCombo);
    }

    private static void hideControl(Control control) {
        if (control != null) {
            control.setVisible(false);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(0, 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(0, 0);
            control.setLayoutData((Object)data);
        }
    }

    private boolean isProjectValid(IProject project) {
        boolean result;
        try {
            result = project.isAccessible() && project.getNature("org.eclipse.jdt.core.javanature") != null && !JavaEEProjectUtilities.isEARProject((IProject)project);
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result;
    }

    protected IJavaElement getInitialJavaElement(ISelection selection) {
        IResource resource;
        Object selectedElement;
        IJavaElement jelem = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (jelem = WizardUtils.getJavaElement(selectedElement = ((IStructuredSelection)selection).getFirstElement())) == null && (resource = this.getResource(selectedElement)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return jelem;
    }

    protected IResource getResource(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IResource)((IAdaptable)obj).getAdapter(IResource.class);
        }
        return (IResource)Platform.getAdapterManager().getAdapter(obj, IResource.class);
    }

    private IPackageFragment getSelectedPackageFragment() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null) {
            if (element.getElementType() == 4) {
                return (IPackageFragment)element;
            }
            if (element.getElementType() == 5) {
                IJavaElement parent = ((ICompilationUnit)element).getParent();
                if (parent.getElementType() == 4) {
                    return (IPackageFragment)parent;
                }
            } else if (element.getElementType() == 7) {
                return ((IType)element).getPackageFragment();
            }
        }
        return null;
    }
}

