/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import oracle.eclipse.tools.jaxrs.ui.internal.wizards.IRESTServiceConstants;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassWizard;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDataModelProvider;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.osgi.service.prefs.BackingStoreException;

public class RESTApplicationClassPage
extends DataModelWizardPage
implements IRESTServiceConstants {
    private static final String APP_PKG_NAME_PREF = "APP_CLASS_PKG_NAME";
    private static final String APP_CLASS_NAME_PREF = "APP_CLASS_NAME";
    private IScopeContext context = null;
    private IEclipsePreferences preferences = null;
    private Label packageLabel;
    private Text packageText;
    private Button packageBtn;
    private Label classNameLabel;
    private Text classNameText;

    protected RESTApplicationClassPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(Messages.RESTApplicationClassPage_pageDescription);
        this.setTitle(Messages.RESTApplicationClassPage_pageTitle);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"RestService.applicationClassPkg", "RestService.applicationClass"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite topLevelComp = new Composite(parent, 0);
        GridData data = new GridData(1808);
        topLevelComp.setLayoutData((Object)data);
        topLevelComp.setLayout((Layout)new GridLayout(3, false));
        this.packageLabel = new Label(topLevelComp, 16384);
        this.packageLabel.setText(Messages.RESTApplicationClassPage_packageLabel);
        data = new GridData();
        data.horizontalIndent = 5;
        this.packageLabel.setLayoutData((Object)data);
        this.packageText = new Text(topLevelComp, 2052);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.packageText.setLayoutData((Object)data);
        this.packageText.setText(this.getDataModel().getStringProperty("RestService.applicationClassPkg"));
        this.synchHelper.synchText(this.packageText, "RestService.applicationClassPkg", null);
        this.packageBtn = new Button(topLevelComp, 8);
        this.packageBtn.setText(Messages.RESTApplicationClassPage_browseBtn);
        this.packageBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RESTApplicationClassPage.this.packageText.setText(WizardUtils.getPkgNameFromPkgDialog(RESTApplicationClassPage.this.getShell(), RESTApplicationClassPage.this.model));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.classNameLabel = new Label(topLevelComp, 16384);
        this.classNameLabel.setText(Messages.RESTApplicationClassPage_classNameLabel);
        data = new GridData();
        data.horizontalIndent = 5;
        this.classNameLabel.setLayoutData((Object)data);
        this.classNameText = new Text(topLevelComp, 2052);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.classNameText.setLayoutData((Object)data);
        this.classNameText.setText(this.getDataModel().getStringProperty("RestService.applicationClass"));
        this.synchHelper.synchText(this.classNameText, "RestService.applicationClass", null);
        return topLevelComp;
    }

    void saveApplicationPkgAndClassName() {
        IDataModel dataModel = this.getDataModel();
        String pkgName = dataModel.getStringProperty("RestService.applicationClassPkg");
        String className = dataModel.getStringProperty("RestService.applicationClass");
        this.preferences.put(APP_PKG_NAME_PREF, pkgName);
        this.preferences.put(APP_CLASS_NAME_PREF, className);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e2) {
            e2.printStackTrace();
        }
    }

    void initializePkgAndClassName(RESTServiceClassWizard wizard) {
        IDataModel dataModel = this.getDataModel();
        String projectName = WizardUtils.getProjectName(dataModel);
        if (projectName == null || projectName.equals("")) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        this.context = new ProjectScope(project);
        this.preferences = this.context.getNode("oracle.eclipse.tools.jaxrs.ui");
        String pkgName = this.preferences.get(APP_PKG_NAME_PREF, "rest.application.config");
        String className = this.preferences.get(APP_CLASS_NAME_PREF, "ApplicationConfig");
        className = RESTApplicationClassPage.getAppClassName(dataModel, wizard, pkgName, className);
        dataModel.setStringProperty("RestService.applicationClassPkg", pkgName);
        dataModel.setStringProperty("RestService.applicationClass", className);
    }

    private static String getAppClassName(IDataModel dataModel, RESTServiceClassWizard wizard, String pkgName, String classNameTemplate) {
        RESTServiceDataModelProvider provider = (RESTServiceDataModelProvider)wizard.getDefaultProvider();
        String className = classNameTemplate;
        int i = 1;
        while (i < 1000) {
            IStatus status = provider.checkIfClassExists(pkgName, className);
            if (status == null || status.isOK()) {
                return className;
            }
            status = provider.checkIfAppClassExtendsApplication(pkgName, className);
            if (status == null || status.isOK()) {
                return className;
            }
            className = String.valueOf(classNameTemplate) + i;
            ++i;
        }
        return classNameTemplate;
    }
}

