/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.AbstractNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDetailsPage;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParamNodeDetailsComposite
extends AbstractNodeDetailsComposite {
    private Text parameterNameText;
    private Node.ParamNode paramNode;
    private Text dataTypeText;
    private Button dataTypeBtn;
    private Text pathParamText;
    private ModifyListener parameterNameTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ParamNodeDetailsComposite.this.paramNode == null) {
                return;
            }
            ParamNodeDetailsComposite.this.paramNode.setName(ParamNodeDetailsComposite.this.parameterNameText.getText());
            ParamNodeDetailsComposite.this.firePropertyChangeEvent("RESTServiceNodeName", null, ParamNodeDetailsComposite.this.parameterNameText.getText());
            ParamNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, ParamNodeDetailsComposite.this.dataTypeText.getText());
        }
    };
    private ModifyListener dataTypeTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ParamNodeDetailsComposite.this.paramNode == null) {
                return;
            }
            ParamNodeDetailsComposite.this.paramNode.setDataType(ParamNodeDetailsComposite.this.dataTypeText.getText());
            ParamNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, ParamNodeDetailsComposite.this.dataTypeText.getText());
        }
    };
    private SelectionListener dataTypeBtnSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            ParamNodeDetailsComposite.this.handleClassTypeButtonPressed(Messages.ParamNodeDetailsComposite_paramTypeSelectionTitle, Messages.ParamNodeDetailsComposite_paramTypeSelectionMsg, ParamNodeDetailsComposite.this.dataTypeText);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private ModifyListener pathParamValueModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ParamNodeDetailsComposite.this.paramNode == null) {
                return;
            }
            ParamNodeDetailsComposite.this.paramNode.setPathParamValue(ParamNodeDetailsComposite.this.pathParamText.getText());
            ParamNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, ParamNodeDetailsComposite.this.dataTypeText.getText());
        }
    };

    ParamNodeDetailsComposite(RESTServiceDetailsPage detailsPage, Composite parent) {
        super(detailsPage, parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label methodLabel = new Label((Composite)this, 16384);
        methodLabel.setText(Messages.ParamNodeDetailsComposite_paramNameLabel);
        this.parameterNameText = new Text((Composite)this, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.parameterNameText.setLayoutData((Object)gridData);
        Label dataTypeLabel = new Label((Composite)this, 16384);
        dataTypeLabel.setText(Messages.ParamNodeDetailsComposite_dataTypeLabel);
        this.dataTypeText = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.dataTypeText.setLayoutData((Object)gridData);
        this.dataTypeBtn = new Button((Composite)this, 8);
        this.dataTypeBtn.setText(Messages.ParamNodeDetailsComposite_browseButton);
        Label pathParamLabel = new Label((Composite)this, 16384);
        pathParamLabel.setText(Messages.ParamNodeDetailsComposite_uriParamNameLabel);
        this.pathParamText = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.pathParamText.setLayoutData((Object)gridData);
        this.addListeners();
    }

    @Override
    protected void initializeFromModel(INode node) {
        if (!(node instanceof Node.ParamNode)) {
            return;
        }
        this.removeListeners();
        this.paramNode = (Node.ParamNode)node;
        this.parameterNameText.setText(this.paramNode.getName());
        this.dataTypeText.setText(this.paramNode.getDataType());
        this.pathParamText.setText(this.paramNode.getPathParamValue());
        this.parameterNameText.setEnabled(this.paramNode.isNameEnabled());
        this.dataTypeText.setEnabled(this.paramNode.isDataTypeEnabled());
        this.dataTypeBtn.setEnabled(this.paramNode.isDataTypeEnabled());
        this.pathParamText.setEnabled(this.paramNode.isPathParamValueEnabled());
        this.addListeners();
    }

    @Override
    protected IStatus validate() {
        String methodName = this.parameterNameText.getText();
        if (methodName == null || methodName.isEmpty()) {
            return Activator.createErrorStatus(Messages.ParamNodeDetailsComposite_paramNameEmptyMsg);
        }
        String dataType = this.dataTypeText.getText();
        String projectName = WizardUtils.getProjectName(this.detailsPage.getWizardDataModel());
        return WizardUtils.validateTypeName(projectName, dataType, Messages.ParamNodeDetailsComposite_dataTypeEmptyMsg, String.valueOf(Messages.ParamNodeDetailsComposite_invalidParameterType) + dataType);
    }

    private void addListeners() {
        this.parameterNameText.addModifyListener(this.parameterNameTextModifyListener);
        this.dataTypeText.addModifyListener(this.dataTypeTextModifyListener);
        this.dataTypeBtn.addSelectionListener(this.dataTypeBtnSelectionListener);
        this.pathParamText.addModifyListener(this.pathParamValueModifyListener);
    }

    private void removeListeners() {
        this.parameterNameText.removeModifyListener(this.parameterNameTextModifyListener);
        this.dataTypeText.removeModifyListener(this.dataTypeTextModifyListener);
        this.dataTypeBtn.removeSelectionListener(this.dataTypeBtnSelectionListener);
        this.pathParamText.removeModifyListener(this.pathParamValueModifyListener);
    }
}

