/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.swt.graphics.Image;

public abstract class Node
implements INode {
    private String name = "";
    private List<INode> children;
    private INode parent;
    private boolean isNameEnabled = true;

    public Node(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends INode> getChildren() {
        List emptyList = Collections.emptyList();
        return this.children == null ? emptyList : Collections.unmodifiableList(this.children);
    }

    @Override
    public INode getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNameEnabled() {
        return this.isNameEnabled;
    }

    public void setNameEnabled(boolean b) {
        this.isNameEnabled = b;
    }

    public void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    protected void addNode(Node child) throws InvalidChildException {
        if (this.children == null) {
            this.children = new ArrayList<INode>();
        }
        if (!this.isValidChild(child)) {
            throw new InvalidChildException("Invalid child node '" + child.getName() + "' for parent '" + this.getName() + "'");
        }
        this.children.add(child);
        child.parent = this;
    }

    protected abstract boolean isValidChild(INode var1);

    protected boolean removeNode(INode child) {
        if (this.children == null) {
            return false;
        }
        return this.children.remove(child);
    }

    static class ClassNode
    extends MimeTypePathNode {
        private boolean isSubResource = false;
        private List<MethodNode> methodNodes = new ArrayList<MethodNode>();

        ClassNode(String name) {
            super(name);
        }

        public void setIsSubResource(boolean b) {
            this.isSubResource = b;
        }

        public boolean isSubResource() {
            return this.isSubResource;
        }

        public boolean removeMethod(MethodNode methodNode) {
            return this.removeNode(methodNode);
        }

        @Override
        public Image getImage() {
            return Activator.Images.CLASS.getImage();
        }

        public List<MethodNode> getMethodNodes() {
            this.methodNodes.clear();
            List<? extends INode> classChildren = this.getChildren();
            if (classChildren != null) {
                for (INode iNode : classChildren) {
                    if (!(iNode instanceof MethodNode)) continue;
                    this.methodNodes.add((MethodNode)iNode);
                }
            }
            return this.methodNodes;
        }

        @Override
        protected boolean isValidChild(INode child) {
            return child instanceof ClassNode || child instanceof MethodNode;
        }
    }

    static class ContainerOnlyMethodNode
    extends MethodNode {
        ContainerOnlyMethodNode(String name) {
            super(name);
        }
    }

    static class EntityClassNode
    extends ClassNode {
        private String entityName;

        public EntityClassNode(String name, String entityName) {
            super(name);
            this.entityName = entityName;
        }

        public String getEntityName() {
            return this.entityName;
        }
    }

    static class EntityMethodNode
    extends MethodNode {
        private EntityMethodType entityMethodType;

        public EntityMethodNode(String name, EntityMethodType methodType) {
            super(name);
            this.entityMethodType = methodType;
        }

        public EntityMethodType getMethodType() {
            return this.entityMethodType;
        }
    }

    static enum EntityMethodType {
        PERSIST,
        MERGE,
        REMOVE,
        FIND,
        FINDALL,
        FINDRANGE,
        COUNT;

    }

    static class InvalidChildException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidChildException(String msg) {
            super(msg);
        }
    }

    static class MethodNode
    extends MimeTypePathNode {
        private String returnType = "";
        private String httpMethodType = "";
        private String defaultReturnValue = "null";
        static final String GET = "GET";
        static final String PUT = "PUT";
        static final String POST = "POST";
        static final String DELETE = "DELETE";
        private boolean isReturnTypeEnabled = true;
        private boolean isHttpMethodTypeEnabled = false;
        private boolean isSubResourceMethod = false;

        MethodNode(String name) {
            super(name);
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String getHttpMethodType() {
            return this.httpMethodType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public void setHttpMethodType(String methodType) {
            this.httpMethodType = methodType;
        }

        public boolean isReturnTypeEnabled() {
            return this.isReturnTypeEnabled;
        }

        public void setReturnTypeEnabled(boolean b) {
            this.isReturnTypeEnabled = b;
        }

        public boolean isHttpMethodTypeEnabled() {
            return this.isHttpMethodTypeEnabled;
        }

        public void setHttpMethodTypeEnabled(boolean b) {
            this.isHttpMethodTypeEnabled = b;
        }

        public boolean isSubResourceMethod() {
            return this.isSubResourceMethod;
        }

        public void setIsSubResourceMethod(boolean b) {
            this.isSubResourceMethod = b;
        }

        @Override
        public Image getImage() {
            String httpMethodType = this.getHttpMethodType();
            if (httpMethodType == null) {
                return Activator.Images.METHOD.getImage();
            }
            if (httpMethodType.equals(GET)) {
                return Activator.Images.METHOD_GET.getImage();
            }
            if (httpMethodType.equals(PUT)) {
                return Activator.Images.METHOD_PUT.getImage();
            }
            if (httpMethodType.equals(POST)) {
                return Activator.Images.METHOD_POST.getImage();
            }
            if (httpMethodType.equals(DELETE)) {
                return Activator.Images.METHOD_DELETE.getImage();
            }
            return Activator.Images.METHOD.getImage();
        }

        public List<String> getParamNames() {
            List<String> paramNames = Collections.emptyList();
            List<? extends INode> methodChildren = this.getChildren();
            for (INode iNode : methodChildren) {
                if (!(iNode instanceof ParamNode)) continue;
                ParamNode paramNode = (ParamNode)iNode;
                String paramName = paramNode.getName();
                if (paramNames.size() == 0) {
                    paramNames = new ArrayList<String>();
                }
                paramNames.add(paramName);
            }
            return paramNames;
        }

        public String buildCommaSeparatedParamList() {
            StringBuffer buffer = new StringBuffer();
            List<? extends INode> methodChildren = this.getChildren();
            for (INode iNode : methodChildren) {
                if (!(iNode instanceof ParamNode)) continue;
                ParamNode paramNode = (ParamNode)iNode;
                String pathParam = paramNode.getPathParamValue();
                String paramName = paramNode.getName();
                String dataType = paramNode.getDataType();
                if (!pathParam.isEmpty()) {
                    buffer.append("@");
                    buffer.append(WizardUtils.getUnqualifiedDataTypeStr("javax.ws.rs.PathParam"));
                    buffer.append("(\"");
                    buffer.append(pathParam);
                    buffer.append("\")");
                    buffer.append(" ");
                }
                buffer.append(WizardUtils.getUnqualifiedDataTypeStr(dataType));
                buffer.append(" ");
                buffer.append(paramName);
                buffer.append(", ");
            }
            if (buffer.length() > 0) {
                buffer.delete(buffer.length() - 2, buffer.length());
            }
            return buffer.toString();
        }

        public void setDefaultReturnValue(String value) {
            this.defaultReturnValue = value;
        }

        public String getDefaultReturnValue() {
            if (this.returnType.equals("void")) {
                return null;
            }
            return this.defaultReturnValue;
        }

        public String getUnqualifiedReturnType() {
            return WizardUtils.getUnqualifiedDataTypeStr(this.returnType);
        }

        @Override
        protected boolean isValidChild(INode child) {
            return child instanceof ParamNode;
        }
    }

    static abstract class MimeTypePathNode
    extends Node {
        private String path = "";
        private Set<String> consumedMimeTypes;
        private Set<String> producedMimeTypes;
        private boolean isPathEnabled = true;
        private boolean isConsumedMimeTypesEnabled = true;
        private boolean isProducedMimeTypesEnabled = true;

        MimeTypePathNode(String name) {
            super(name);
        }

        public Set<String> getConsumedMimeTypes() {
            return this.consumedMimeTypes;
        }

        public Set<String> getProducedMimeTypes() {
            return this.producedMimeTypes;
        }

        public String getConsumedMimeTypeString() {
            return this.getMimeTypeString(this.consumedMimeTypes);
        }

        public String getProducedMimeTypeString() {
            return this.getMimeTypeString(this.producedMimeTypes);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String rootPath) {
            this.path = rootPath;
        }

        public void addConsumeMimeType(String mimeType) {
            if (this.consumedMimeTypes == null) {
                this.consumedMimeTypes = new LinkedHashSet<String>();
            }
            this.consumedMimeTypes.add(mimeType);
        }

        public boolean removeConsumeMimeType(String mimeType) {
            if (this.consumedMimeTypes == null) {
                return false;
            }
            return this.consumedMimeTypes.remove(mimeType);
        }

        public boolean removeProduceMimeType(String mimeType) {
            if (this.producedMimeTypes == null) {
                return false;
            }
            return this.producedMimeTypes.remove(mimeType);
        }

        public void addProduceMimeType(String mimeType) {
            if (this.producedMimeTypes == null) {
                this.producedMimeTypes = new LinkedHashSet<String>();
            }
            this.producedMimeTypes.add(mimeType);
        }

        public boolean isPathEnabled() {
            return this.isPathEnabled;
        }

        public void setPathEnabled(boolean b) {
            this.isPathEnabled = b;
        }

        public boolean isConsumedMimeTypesEnabled() {
            return this.isConsumedMimeTypesEnabled;
        }

        public void setConsumedMimeTypesEnabled(boolean b) {
            this.isConsumedMimeTypesEnabled = b;
        }

        public boolean isProducedMimeTypesEnabled() {
            return this.isProducedMimeTypesEnabled;
        }

        public void setProducedMimeTypesEnabled(boolean b) {
            this.isProducedMimeTypesEnabled = b;
        }

        private String getMimeTypeString(Set<String> mimeTypes) {
            if (mimeTypes == null || mimeTypes.size() == 0) {
                return "";
            }
            if (mimeTypes.size() == 1) {
                String mimeType = mimeTypes.iterator().next();
                return "\"" + mimeType + "\"";
            }
            StringBuffer mimeTypeStr = new StringBuffer("{");
            for (String mimeType : mimeTypes) {
                mimeTypeStr.append("\"");
                mimeTypeStr.append(mimeType);
                mimeTypeStr.append("\"");
                mimeTypeStr.append(", ");
            }
            int length = mimeTypeStr.length();
            mimeTypeStr.delete(length - 2, length - 1);
            mimeTypeStr.append("}");
            return mimeTypeStr.toString();
        }
    }

    static class ParamNode
    extends Node {
        private String dataType = "";
        private String pathParamValue = "";
        private boolean isDataTypeEnabled = true;
        private boolean isPathParamEnabled = true;

        public ParamNode(String name) {
            super(name);
        }

        @Override
        public Image getImage() {
            return Activator.Images.PARAMETER.getImage();
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public boolean isDataTypeEnabled() {
            return this.isDataTypeEnabled;
        }

        public void setDataTypeEnabled(boolean b) {
            this.isDataTypeEnabled = b;
        }

        public String getPathParamValue() {
            return this.pathParamValue;
        }

        public void setPathParamValue(String value) {
            this.pathParamValue = value;
        }

        public boolean isPathParamValueEnabled() {
            return this.isPathParamEnabled;
        }

        public void setPathParamValueEnable(boolean b) {
            this.isPathParamEnabled = b;
        }

        @Override
        protected boolean isValidChild(INode child) {
            return false;
        }
    }

    public static class RootNode
    extends Node {
        public RootNode(String name) {
            super(name);
        }

        public boolean removeClassNode(ClassNode node) {
            return this.removeNode(node);
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        protected boolean isValidChild(INode child) {
            return child instanceof ClassNode;
        }
    }
}

