/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.AbstractNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.MimeTypeComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDetailsPage;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MethodNodeDetailsComposite
extends AbstractNodeDetailsComposite {
    private static String[] HTTP_TYPES = new String[]{"GET", "PUT", "POST", "DELETE"};
    private Text methodNameText;
    private Text returnTypeText;
    private Button returnTypeBtn;
    private Combo httpTypeCombo;
    private Text pathText;
    private MimeTypeComposite mimeTypeComp;
    private Node.MethodNode methodNode = null;
    private Label mimeTypeLabel;
    private ModifyListener methodNameTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (MethodNodeDetailsComposite.this.methodNode == null) {
                return;
            }
            MethodNodeDetailsComposite.this.methodNode.setName(MethodNodeDetailsComposite.this.methodNameText.getText());
            MethodNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, MethodNodeDetailsComposite.this.methodNameText.getText());
            MethodNodeDetailsComposite.this.firePropertyChangeEvent("RESTServiceNodeName", null, MethodNodeDetailsComposite.this.methodNameText.getText());
        }
    };
    private ModifyListener returnTypeTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (MethodNodeDetailsComposite.this.methodNode == null) {
                return;
            }
            MethodNodeDetailsComposite.this.methodNode.setReturnType(MethodNodeDetailsComposite.this.returnTypeText.getText());
            MethodNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, MethodNodeDetailsComposite.this.returnTypeText.getText());
        }
    };
    private SelectionListener httpTypeComboSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            String text = MethodNodeDetailsComposite.this.httpTypeCombo.getText();
            MethodNodeDetailsComposite.this.changeMimeTypeUI(text);
            if (MethodNodeDetailsComposite.this.methodNode == null) {
                return;
            }
            MethodNodeDetailsComposite.this.methodNode.setHttpMethodType(text);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private ModifyListener pathTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (MethodNodeDetailsComposite.this.methodNode == null) {
                return;
            }
            MethodNodeDetailsComposite.this.methodNode.setPath(MethodNodeDetailsComposite.this.pathText.getText());
            MethodNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, MethodNodeDetailsComposite.this.methodNameText.getText());
        }
    };
    private SelectionListener returnTypeSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            MethodNodeDetailsComposite.this.handleClassTypeButtonPressed(Messages.MethodNodeDetailsComposite_returnTypeSelectionTitle, Messages.MethodNodeDetailsComposite_returnTypeSelectionMsg, MethodNodeDetailsComposite.this.returnTypeText);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };

    MethodNodeDetailsComposite(RESTServiceDetailsPage detailsPage, Composite parent) {
        super(detailsPage, parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label methodLabel = new Label((Composite)this, 16384);
        methodLabel.setText(Messages.MethodNodeDetailsComposite_methodNameLabel);
        this.methodNameText = new Text((Composite)this, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.methodNameText.setLayoutData((Object)gridData);
        Label returnTypeLabel = new Label((Composite)this, 16384);
        returnTypeLabel.setText(Messages.MethodNodeDetailsComposite_returnTypeLabel);
        this.returnTypeText = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.returnTypeText.setLayoutData((Object)gridData);
        this.returnTypeBtn = new Button((Composite)this, 8);
        this.returnTypeBtn.setText(Messages.MethodNodeDetailsComposite_browseBtn);
        Label httpTypeLabel = new Label((Composite)this, 16384);
        httpTypeLabel.setText(Messages.MethodNodeDetailsComposite_httpTypeLabel);
        this.httpTypeCombo = new Combo((Composite)this, 12);
        String[] stringArray = HTTP_TYPES;
        int n = HTTP_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String httpType = stringArray[n2];
            this.httpTypeCombo.add(httpType);
            ++n2;
        }
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 50;
        this.httpTypeCombo.setLayoutData((Object)gridData);
        this.httpTypeCombo.setText(HTTP_TYPES[0]);
        this.httpTypeCombo.setEnabled(false);
        Label pathLabel = new Label((Composite)this, 16384);
        pathLabel.setText(Messages.MethodNodeDetailsComposite_pathLabel);
        this.pathText = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.pathText.setLayoutData((Object)gridData);
        this.mimeTypeLabel = new Label((Composite)this, 16384);
        this.mimeTypeLabel.setText(Messages.MethodNodeDetailsComposite_consumesLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.mimeTypeLabel.setLayoutData((Object)gridData);
        this.mimeTypeComp = new MimeTypeComposite(this, false);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.mimeTypeComp.setLayoutData(gridData);
        this.addListeners();
    }

    @Override
    protected void initializeFromModel(INode node) {
        if (!(node instanceof Node.MethodNode)) {
            return;
        }
        this.removeListeners();
        this.methodNode = (Node.MethodNode)node;
        this.methodNameText.setText(this.methodNode.getName());
        this.returnTypeText.setText(this.methodNode.getReturnType());
        this.httpTypeCombo.setText(this.methodNode.getHttpMethodType());
        this.pathText.setText(this.methodNode.getPath());
        this.mimeTypeComp.initializeFromModel(this.methodNode);
        this.changeMimeTypeUI(this.httpTypeCombo.getText());
        this.methodNameText.setEnabled(this.methodNode.isNameEnabled());
        this.returnTypeText.setEnabled(this.methodNode.isReturnTypeEnabled());
        this.returnTypeBtn.setEnabled(this.methodNode.isReturnTypeEnabled());
        this.httpTypeCombo.setEnabled(this.methodNode.isHttpMethodTypeEnabled());
        this.pathText.setEnabled(this.methodNode.isPathEnabled());
        this.addListeners();
    }

    @Override
    protected IStatus validate() {
        IStatus pathStatus;
        MultiStatus multiStatus = new MultiStatus(Activator.getPluginId(), -1, "", null);
        String methodName = this.methodNameText.getText();
        if (methodName == null || methodName.isEmpty()) {
            multiStatus.add(Activator.createErrorStatus(Messages.MethodNodeDetailsComposite_methodNameCannotBeEmpty));
        }
        String returnType = this.returnTypeText.getText();
        String projectName = WizardUtils.getProjectName(this.detailsPage.getWizardDataModel());
        IStatus typeStatus = WizardUtils.validateTypeName(projectName, returnType, Messages.MethodNodeDetailsComposite_returnTypeCannotbeEmpty, String.valueOf(Messages.MethodNodeDetailsComposite_invalidReturnTypeMsg) + returnType);
        if (typeStatus != null) {
            multiStatus.add(typeStatus);
        }
        if ((pathStatus = WizardUtils.validatePath(this.pathText.getText(), false)) != null) {
            multiStatus.add(pathStatus);
        }
        return multiStatus;
    }

    private void changeMimeTypeUI(String mimeType) {
        this.setMimeTypeLabel();
        if (mimeType.equals("GET") || mimeType.equals("DELETE")) {
            this.mimeTypeComp.hideFirstColCheckBoxes(true);
        } else {
            this.mimeTypeComp.hideFirstColCheckBoxes(false);
        }
    }

    private void addListeners() {
        this.methodNameText.addModifyListener(this.methodNameTextModifyListener);
        this.returnTypeText.addModifyListener(this.returnTypeTextModifyListener);
        this.httpTypeCombo.addSelectionListener(this.httpTypeComboSelectionListener);
        this.pathText.addModifyListener(this.pathTextModifyListener);
        this.returnTypeBtn.addSelectionListener(this.returnTypeSelectionListener);
        this.mimeTypeComp.addListeners();
    }

    private void removeListeners() {
        this.methodNameText.removeModifyListener(this.methodNameTextModifyListener);
        this.returnTypeText.removeModifyListener(this.returnTypeTextModifyListener);
        this.httpTypeCombo.removeSelectionListener(this.httpTypeComboSelectionListener);
        this.pathText.removeModifyListener(this.pathTextModifyListener);
        this.returnTypeBtn.removeSelectionListener(this.returnTypeSelectionListener);
        this.mimeTypeComp.removeListeners();
    }

    private void setMimeTypeLabel() {
        String mimeType = this.httpTypeCombo.getText();
        if (mimeType.equals("GET")) {
            this.mimeTypeLabel.setText(Messages.MethodNodeDetailsComposite_producesLabel);
        } else if (mimeType.equals("DELETE")) {
            this.mimeTypeLabel.setText(Messages.MethodNodeDetailsComposite_consumesLabel);
        } else {
            this.mimeTypeLabel.setText(Messages.MethodNodeDetailsComposite_consumesProducesLabel);
        }
        this.layout();
    }
}

