/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.internal.wizards;

import oracle.eclipse.tools.jaxrs.ui.Activator;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.AbstractNodeDetailsComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.INode;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Messages;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.MimeTypeComposite;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.Node;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceClassWizard;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDataModelProvider;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.RESTServiceDetailsPage;
import oracle.eclipse.tools.jaxrs.ui.internal.wizards.WizardUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ClassNodeDetailsComposite
extends AbstractNodeDetailsComposite {
    private Text classNameText;
    private Text rootPathText;
    private MimeTypeComposite mimeTypeComp;
    private Node.ClassNode classNode = null;
    private Label entityNameLabel;
    private Label entityLabel;
    private ModifyListener rootPathTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ClassNodeDetailsComposite.this.classNode == null) {
                return;
            }
            ClassNodeDetailsComposite.this.classNode.setPath(ClassNodeDetailsComposite.this.rootPathText.getText());
            ClassNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, ClassNodeDetailsComposite.this.rootPathText.getText());
        }
    };
    private ModifyListener nameTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ClassNodeDetailsComposite.this.classNode == null) {
                return;
            }
            ClassNodeDetailsComposite.this.classNode.setName(ClassNodeDetailsComposite.this.classNameText.getText());
            ClassNodeDetailsComposite.this.firePropertyChangeEvent("RESTServiceNodeName", null, ClassNodeDetailsComposite.this.classNameText.getText());
            ClassNodeDetailsComposite.this.firePropertyChangeEvent("ValidateRestServiceDetailsPage", null, ClassNodeDetailsComposite.this.classNameText.getText());
        }
    };

    public ClassNodeDetailsComposite(RESTServiceDetailsPage detailsPage, Composite parent) {
        super(detailsPage, parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label classLabel = new Label((Composite)this, 16384);
        classLabel.setText(Messages.ClassNodeDetailsComposite_rootResourceClassLabel);
        this.classNameText = new Text((Composite)this, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.classNameText.setLayoutData((Object)gridData);
        this.classNameText.setEnabled(false);
        Label rootPath = new Label((Composite)this, 0);
        rootPath.setText(Messages.ClassNodeDetailsComposite_rootPathLabel);
        this.rootPathText = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.rootPathText.setLayoutData((Object)gridData);
        this.entityLabel = new Label((Composite)this, 16384);
        this.entityLabel.setText(Messages.ClassNodeDetailsComposite_entityName);
        this.entityNameLabel = new Label((Composite)this, 16384);
        Label consumesLabel = new Label((Composite)this, 16384);
        consumesLabel.setText(Messages.ClassNodeDetailsComposite_consumesProducesLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        consumesLabel.setLayoutData((Object)gridData);
        this.mimeTypeComp = new MimeTypeComposite(this, true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.mimeTypeComp.setLayoutData(gridData);
        this.addListeners();
    }

    String[] getConsumesMediaTypes() {
        return null;
    }

    String[] getProducesConsumesMediaTypes() {
        return null;
    }

    @Override
    protected void initializeFromModel(INode node) {
        if (!(node instanceof Node.ClassNode)) {
            return;
        }
        this.removeListeners();
        this.classNode = (Node.ClassNode)node;
        this.classNameText.setText(this.classNode.getName());
        this.rootPathText.setText(this.classNode.getPath());
        this.mimeTypeComp.initializeFromModel(this.classNode);
        this.rootPathText.setEnabled(this.classNode.isPathEnabled());
        if (node instanceof Node.EntityClassNode) {
            this.classNameText.setEnabled(true);
            this.showEntityNameLabel(true, ((Node.EntityClassNode)node).getEntityName());
        } else {
            this.classNameText.setEnabled(false);
            this.showEntityNameLabel(false, null);
        }
        this.addListeners();
    }

    private void showEntityNameLabel(boolean show, String entityName) {
        this.entityLabel.setVisible(show);
        this.entityNameLabel.setVisible(show);
        if (show) {
            GridData gridData = new GridData();
            this.entityLabel.setLayoutData((Object)gridData);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.entityNameLabel.setLayoutData((Object)gridData);
            this.entityNameLabel.setText(entityName);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalSpan = 0;
            gridData.verticalSpan = 0;
            gridData.heightHint = 0;
            gridData.heightHint = 0;
            this.entityLabel.setLayoutData((Object)gridData);
            this.entityNameLabel.setLayoutData((Object)gridData);
        }
    }

    private void addListeners() {
        this.rootPathText.addModifyListener(this.rootPathTextModifyListener);
        this.classNameText.addModifyListener(this.nameTextModifyListener);
        this.mimeTypeComp.addListeners();
    }

    private void removeListeners() {
        this.rootPathText.removeModifyListener(this.rootPathTextModifyListener);
        this.classNameText.removeModifyListener(this.nameTextModifyListener);
        this.mimeTypeComp.removeListeners();
    }

    @Override
    protected IStatus validate() {
        MultiStatus multiStatus = new MultiStatus(Activator.getPluginId(), -1, "", null);
        String rootPath = this.rootPathText.getText();
        if (this.classNode != null && !this.classNode.isSubResource() && (rootPath == null || rootPath.isEmpty())) {
            return Activator.createErrorStatus(Messages.ClassNodeDetailsComposite_rootPathEmptyMsg);
        }
        IStatus pathStatus = WizardUtils.validatePath(rootPath, false);
        if (pathStatus != null) {
            multiStatus.add(pathStatus);
        }
        if (this.classNode instanceof Node.EntityClassNode) {
            RESTServiceDataModelProvider dataModelProvider = (RESTServiceDataModelProvider)((RESTServiceClassWizard)this.detailsPage.getWizard()).getDefaultProvider();
            String pkgName = this.detailsPage.getWizardDataModel().getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
            String className = this.classNameText.getText();
            if (className != null && className.isEmpty()) {
                return Activator.createErrorStatus(Messages.ClassNodeDetailsComposite_classNameEmptyMsg);
            }
            IStatus classNameStatus = dataModelProvider.checkIfClassExists(pkgName, className);
            if (classNameStatus != null) {
                multiStatus.add(classNameStatus);
            }
        }
        return multiStatus;
    }
}

