/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui.actions;

import oracle.eclipse.tools.jaxrs.ui.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class JaxrsDerivedAction
implements IActionDelegate {
    private IStructuredSelection selection;
    private Shell shell;

    public JaxrsDerivedAction() {
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        this.shell = window.getShell();
    }

    public void selectionChanged(IAction action, ISelection selectionParam) {
        boolean enabled = false;
        if (selectionParam instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selectionParam;
            boolean skipEnablement = false;
            IProject proj = null;
            for (Object obj : this.selection.toList()) {
                if (!(obj instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)obj;
                IResource rsrc = (IResource)adaptable.getAdapter(IResource.class);
                if (proj == null) {
                    proj = rsrc.getProject();
                    continue;
                }
                if (proj == rsrc.getProject()) continue;
                skipEnablement = true;
                break;
            }
            enabled = !skipEnablement && this.shouldEnable();
        }
        action.setEnabled(enabled);
    }

    protected boolean shouldEnable() {
        IFile file = this.getFile();
        return file != null && this.isFeatureEnabledOnProject(file.getProject());
    }

    protected abstract boolean isFeatureEnabledOnProject(IProject var1);

    protected final IStructuredSelection getSelection() {
        return this.selection;
    }

    protected final Shell getShell() {
        return this.shell;
    }

    protected final IFile getFile() {
        Object obj;
        if (this.selection != null && (obj = this.selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)obj;
            return (IFile)adaptable.getAdapter(IFile.class);
        }
        return null;
    }

    protected void openWizard(IWizard wizard) {
        WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
        dialog.create();
        dialog.getShell().setMinimumSize(300, 400);
        dialog.open();
    }
}

