/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.ui;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.jaxrs.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = Activator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void logError(String msg, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, e));
    }

    public static void log(Throwable e) {
        Activator.logError("Error", e);
    }

    public static void logInfo(String msg) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, msg));
    }

    public static IStatus createErrorStatus(String message) {
        return Activator.createErrorStatus(message, null);
    }

    public static IStatus createWarningStatus(String message) {
        return Activator.createWarningStatus(message, null);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, -1, message, exception);
    }

    public static IStatus createWarningStatus(String message, Throwable exception) {
        return new Status(2, PLUGIN_ID, -1, message, exception);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Images[] imagesArray = Images.values();
        int n = imagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Images img = imagesArray[n2];
            img.init(reg);
            ++n2;
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static enum Images {
        JAX_RS("images/icons/jax-rs.png"),
        ADD("images/icons/wizard/add.png"),
        DELETE("images/icons/wizard/delete.png"),
        CLASS("images/icons/wizard/class.png"),
        METHOD_GET("images/icons/wizard/method_get.png"),
        METHOD_PUT("images/icons/wizard/method_put.png"),
        METHOD_POST("images/icons/wizard/method_post.png"),
        METHOD_DELETE("images/icons/wizard/method_delete.png"),
        METHOD("images/icons/wizard/method.png"),
        PARAMETER("images/icons/wizard/parameter.png"),
        REST_WIZARD_BANNER("images/icons/wizard/new_rest_serv_banner.png");

        private String key;

        private Images(String path) {
            this.key = path;
        }

        private void init(ImageRegistry reg) {
            ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)Activator.PLUGIN_ID, (String)this.key);
            if (desc == null) {
                LoggingService.logError((Plugin)Activator.getDefault(), (String)("ERROR LOADING IMAGE " + this.key));
            } else {
                reg.put(this.key, desc);
            }
        }

        public Image getImage() {
            return Activator.getDefault().getImageRegistry().get(this.key);
        }

        public ImageDescriptor getImageDescriptor() {
            return Activator.getDefault().getImageRegistry().getDescriptor(this.key);
        }
    }
}

