/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.correctionassist.PyCorrectionAssistant;
import org.python.pydev.editor.correctionassist.heuristics.AssistAssign;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;

public class PydevConsoleQuickAssistProcessor
implements IQuickAssistProcessor {
    public PydevConsoleQuickAssistProcessor(PyCorrectionAssistant quickAssist) {
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        ArrayList props = new ArrayList();
        if (sourceViewer instanceof ScriptConsoleViewer) {
            ScriptConsoleViewer viewer = (ScriptConsoleViewer)sourceViewer;
            AssistAssign assistAssign = new AssistAssign();
            ISelection selection = sourceViewer.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                PySelection ps = new PySelection(sourceViewer.getDocument(), (ITextSelection)selection);
                int offset = viewer.getCaretOffset();
                String commandLine = viewer.getCommandLine();
                if (assistAssign.isValid(ps.getSelLength(), commandLine, offset)) {
                    try {
                        char c;
                        int commandLineOffset;
                        IDocument doc = sourceViewer.getDocument();
                        for (commandLineOffset = viewer.getCommandLineOffset(); commandLineOffset != doc.getLength() - 1 && Character.isWhitespace(c = doc.getChar(commandLineOffset)); ++commandLineOffset) {
                        }
                        props.addAll(assistAssign.getProps(ps, PydevPlugin.getImageCache(), sourceViewer, offset, commandLine, commandLineOffset));
                    }
                    catch (BadLocationException e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
        return props.toArray(new ICompletionProposal[props.size()]);
    }

    public String getErrorMessage() {
        return null;
    }
}

