/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.parts;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.reviews.ui.IReviewAction;
import org.eclipse.mylyn.internal.reviews.ui.IReviewActionListener;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.ExpandablePart;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.reviews.ui.SizeCachingComposite;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractCommentPart<V extends ExpandablePart<IComment, V>>
extends ExpandablePart<IComment, V> {
    protected IComment comment;
    protected Control commentTextComposite;
    protected SizeCachingComposite sectionClient;
    private final ReviewBehavior behavior;

    public AbstractCommentPart(IComment comment, ReviewBehavior behavior) {
        Assert.isNotNull((Object)comment);
        Assert.isNotNull((Object)behavior);
        this.comment = comment;
        this.behavior = behavior;
    }

    @Override
    protected String getSectionHeaderText() {
        String headerText = String.valueOf(this.comment.getAuthor().getDisplayName()) + "   ";
        headerText = String.valueOf(headerText) + DateFormat.getDateTimeInstance(2, 3).format(this.comment.getCreationDate());
        return headerText;
    }

    public ReviewBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    protected Comparator<IComment> getComparator() {
        return new Comparator<IComment>(){

            @Override
            public int compare(IComment o1, IComment o2) {
                if (o1 != null && o2 != null) {
                    return o1.getCreationDate().compareTo(o2.getCreationDate());
                }
                return 0;
            }
        };
    }

    protected final Control createOrUpdateControl(Composite parentComposite, FormToolkit toolkit) {
        Control createdControl = null;
        if (this.getSection() == null) {
            Control newControl = this.createControl(parentComposite, toolkit);
            this.setIncomming(true);
            createdControl = newControl;
        } else {
            if (this.commentTextComposite != null && !this.commentTextComposite.isDisposed()) {
                Composite parent = this.commentTextComposite.getParent();
                this.commentTextComposite.dispose();
                this.createCommentArea(toolkit, this.sectionClient);
                if (parent.getChildren().length > 0) {
                    this.commentTextComposite.moveAbove(parent.getChildren()[0]);
                }
            }
            this.updateChildren(this.sectionClient, toolkit, true, this.comment.getReplies());
            createdControl = this.getSection();
        }
        if (this.sectionClient != null && !this.sectionClient.isDisposed()) {
            this.sectionClient.clearCache();
        }
        this.getSection().layout(true, true);
        this.update();
        return createdControl;
    }

    @Override
    protected Composite createSectionContents(Section section, FormToolkit toolkit) {
        section.clientVerticalSpacing = 0;
        this.sectionClient = new SizeCachingComposite((Composite)section, 0);
        toolkit.adapt((Composite)this.sectionClient);
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 0;
        layout.marginLeft = 9;
        layout.marginRight = 11;
        this.sectionClient.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sectionClient);
        this.createCommentArea(toolkit, this.sectionClient);
        this.updateChildren(this.sectionClient, toolkit, false, this.comment.getReplies());
        return this.sectionClient;
    }

    protected void createCommentArea(FormToolkit toolkit, Composite parentComposite) {
        Composite twoColumnComposite = new Composite(parentComposite, 0);
        twoColumnComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        GridDataFactory.fillDefaults().hint(500, -1).applyTo((Control)twoColumnComposite);
        toolkit.adapt(twoColumnComposite);
        Label avatarLabel = new Label(twoColumnComposite, 0);
        toolkit.adapt((Control)avatarLabel, false, false);
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)avatarLabel);
        this.commentTextComposite = this.createReadOnlyText(toolkit, twoColumnComposite, this.getCommentText());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.commentTextComposite);
    }

    private String getCommentText() {
        String commentText = this.comment.getDescription();
        String customFieldsString = "";
        if (customFieldsString.length() > 0) {
            commentText = String.valueOf(commentText) + "  " + customFieldsString;
        }
        return commentText;
    }

    @Override
    protected String getAnnotationText() {
        return this.comment.isDraft() ? Messages.AbstractCommentPart_Draft : "";
    }

    private Control createReadOnlyText(FormToolkit toolkit, Composite composite, String value) {
        int style = 8388682;
        ITask task = this.getBehavior().getTask();
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)repository);
        final RichTextEditor editor = new RichTextEditor(repository, style, null, extension);
        editor.setReadOnly(true);
        editor.setText(value);
        editor.createControl(composite, toolkit);
        editor.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                editor.getViewer().getTextWidget().setSelection(0);
            }
        });
        return editor.getControl();
    }

    @Override
    protected boolean canExpand() {
        return this.comment.getReplies().size() > 0;
    }

    @Override
    protected boolean hasContents() {
        return true;
    }

    @Override
    protected ImageDescriptor getAnnotationImage() {
        return null;
    }

    @Override
    protected List<IReviewAction> getToolbarActions(boolean isExpanded) {
        ArrayList<IReviewAction> actions = new ArrayList<IReviewAction>();
        return actions;
    }

    private final class CannotRemoveCommentAction
    extends Action
    implements IReviewAction {
        public CannotRemoveCommentAction(String text, ImageDescriptor icon) {
            super(text);
            this.setImageDescriptor(icon);
        }

        @Override
        public void setActionListener(IReviewActionListener listner) {
        }

        public void run() {
            MessageDialog.openInformation((Shell)AbstractCommentPart.this.getSection().getShell(), (String)Messages.AbstractCommentPart_Delete, (String)Messages.AbstractCommentPart_Cannot_delete_comment_with_replies);
        }
    }
}

