/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportReferencesCollector
extends GenericVisitor {
    private CompilationUnit fASTRoot;
    private Region fSubRange;
    private Collection<SimpleName> fTypeImports;
    private Collection<SimpleName> fStaticImports;
    private boolean fSkipMethodBodies;

    public static void collect(ASTNode node, IJavaProject project, Region rangeLimit, Collection<SimpleName> resultingTypeImports, Collection<SimpleName> resultingStaticImports) {
        ImportReferencesCollector.collect(node, project, rangeLimit, false, resultingTypeImports, resultingStaticImports);
    }

    public static void collect(ASTNode node, IJavaProject project, Region rangeLimit, boolean skipMethodBodies, Collection<SimpleName> resultingTypeImports, Collection<SimpleName> resultingStaticImports) {
        ASTNode root = node.getRoot();
        CompilationUnit astRoot = root instanceof CompilationUnit ? (CompilationUnit)root : null;
        node.accept((ASTVisitor)new ImportReferencesCollector(project, astRoot, rangeLimit, skipMethodBodies, resultingTypeImports, resultingStaticImports));
    }

    private ImportReferencesCollector(IJavaProject project, CompilationUnit astRoot, Region rangeLimit, boolean skipMethodBodies, Collection<SimpleName> resultingTypeImports, Collection<SimpleName> resultingStaticImports) {
        super(ImportReferencesCollector.processJavadocComments(astRoot));
        this.fTypeImports = resultingTypeImports;
        this.fStaticImports = resultingStaticImports;
        this.fSubRange = rangeLimit;
        if (project == null || !JavaModelUtil.is50OrHigher(project)) {
            this.fStaticImports = null;
        }
        this.fASTRoot = astRoot;
        this.fSkipMethodBodies = skipMethodBodies;
    }

    private static boolean processJavadocComments(CompilationUnit astRoot) {
        if (astRoot != null && astRoot.getTypeRoot() != null) {
            return !"package-info.java".equals(astRoot.getTypeRoot().getElementName());
        }
        return true;
    }

    private boolean isAffected(ASTNode node) {
        if (this.fSubRange == null) {
            return true;
        }
        int nodeStart = node.getStartPosition();
        int offset = this.fSubRange.getOffset();
        return nodeStart + node.getLength() > offset && offset + this.fSubRange.getLength() > nodeStart;
    }

    private void addReference(SimpleName name) {
        if (this.isAffected((ASTNode)name)) {
            this.fTypeImports.add(name);
        }
    }

    private void typeRefFound(Name node) {
        if (node != null) {
            while (node.isQualifiedName()) {
                node = ((QualifiedName)node).getQualifier();
            }
            this.addReference((SimpleName)node);
        }
    }

    private void possibleTypeRefFound(Name node) {
        while (node.isQualifiedName()) {
            node = ((QualifiedName)node).getQualifier();
        }
        IBinding binding = node.resolveBinding();
        if (binding == null || binding.getKind() == 2) {
            this.addReference((SimpleName)node);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void possibleStaticImportFound(Name name) {
        if (this.fStaticImports != null && this.fASTRoot != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            name = ((QualifiedName)name).getQualifier();
lbl4:
            // 2 sources

            ** while (name.isQualifiedName())
        }
lbl5:
        // 1 sources

        if (!this.isAffected((ASTNode)name)) {
            return;
        }
        binding = name.resolveBinding();
        simpleName = (SimpleName)name;
        if (binding == null || binding instanceof ITypeBinding || !Modifier.isStatic((int)binding.getModifiers()) || simpleName.isDeclaration()) {
            return;
        }
        if (binding instanceof IVariableBinding) {
            varBinding = (IVariableBinding)binding;
            if (varBinding.isField() && (declaringClass = (varBinding = varBinding.getVariableDeclaration()).getDeclaringClass()) != null && !declaringClass.isLocal()) {
                if (new ScopeAnalyzer(this.fASTRoot).isDeclaredInScope((IBinding)varBinding, simpleName, 18)) {
                    return;
                }
                this.fStaticImports.add(simpleName);
            }
        } else if (binding instanceof IMethodBinding && (declaringClass = (methodBinding = ((IMethodBinding)binding).getMethodDeclaration()).getDeclaringClass()) != null && !declaringClass.isLocal()) {
            if (new ScopeAnalyzer(this.fASTRoot).isDeclaredInScope((IBinding)methodBinding, simpleName, 17)) {
                return;
            }
            this.fStaticImports.add(simpleName);
        }
    }

    private void doVisitChildren(List<? extends ASTNode> elements) {
        int nElements = elements.size();
        int i = 0;
        while (i < nElements) {
            elements.get(i).accept((ASTVisitor)this);
            ++i;
        }
    }

    private void doVisitNode(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        return this.isAffected(node);
    }

    @Override
    public boolean visit(SimpleType node) {
        this.typeRefFound(node.getName());
        this.doVisitChildren(node.annotations());
        return false;
    }

    @Override
    public boolean visit(NameQualifiedType node) {
        this.possibleTypeRefFound(node.getQualifier());
        this.doVisitChildren(node.annotations());
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        this.doVisitNode((ASTNode)node.getQualifier());
        this.doVisitChildren(node.annotations());
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        this.possibleTypeRefFound((Name)node);
        this.possibleStaticImportFound((Name)node);
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        return false;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        this.doVisitNode((ASTNode)node.getJavadoc());
        this.doVisitChildren(node.annotations());
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        this.typeRefFound(node.getQualifier());
        return false;
    }

    private void evalQualifyingExpression(Expression expr, Name selector) {
        if (expr != null) {
            if (expr instanceof Name) {
                Name name = (Name)expr;
                this.possibleTypeRefFound(name);
                this.possibleStaticImportFound(name);
            } else {
                expr.accept((ASTVisitor)this);
            }
        } else if (selector != null) {
            this.possibleStaticImportFound(selector);
        }
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        this.doVisitChildren(node.typeArguments());
        this.doVisitNode((ASTNode)node.getType());
        this.evalQualifyingExpression(node.getExpression(), null);
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        this.doVisitChildren(node.arguments());
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        this.doVisitChildren(node.typeArguments());
        this.doVisitChildren(node.arguments());
        return false;
    }

    @Override
    public boolean visit(CreationReference node) {
        this.doVisitNode((ASTNode)node.getType());
        this.doVisitChildren(node.typeArguments());
        return false;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        this.doVisitChildren(node.typeArguments());
        return false;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        this.doVisitNode((ASTNode)node.getQualifier());
        this.doVisitChildren(node.typeArguments());
        return false;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        this.doVisitNode((ASTNode)node.getType());
        this.doVisitChildren(node.typeArguments());
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.evalQualifyingExpression(node.getExpression(), null);
        this.doVisitChildren(node.typeArguments());
        this.doVisitChildren(node.arguments());
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        this.evalQualifyingExpression(node.getExpression(), (Name)node.getName());
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.possibleStaticImportFound((Name)node);
        return false;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.typeRefFound(node.getTypeName());
        return false;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.typeRefFound(node.getTypeName());
        this.doVisitChildren(node.values());
        return false;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.typeRefFound(node.getTypeName());
        this.doVisitNode((ASTNode)node.getValue());
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        return this.isAffected((ASTNode)node);
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (!this.isAffected((ASTNode)node)) {
            return false;
        }
        this.doVisitNode((ASTNode)node.getJavadoc());
        this.doVisitChildren(node.modifiers());
        this.doVisitChildren(node.typeParameters());
        if (!node.isConstructor()) {
            this.doVisitNode((ASTNode)node.getReturnType2());
        }
        this.doVisitNode((ASTNode)node.getReceiverType());
        this.doVisitChildren(node.parameters());
        this.doVisitChildren(node.extraDimensions());
        this.doVisitChildren(node.thrownExceptionTypes());
        if (!this.fSkipMethodBodies) {
            this.doVisitNode((ASTNode)node.getBody());
        }
        return false;
    }

    @Override
    public boolean visit(TagElement node) {
        Object first;
        String tagName = node.getTagName();
        List list = node.fragments();
        int idx = 0;
        if (tagName != null && !list.isEmpty() && (first = list.get(0)) instanceof Name) {
            if ("@throws".equals(tagName) || "@exception".equals(tagName)) {
                this.typeRefFound((Name)first);
            } else if ("@see".equals(tagName) || "@link".equals(tagName) || "@linkplain".equals(tagName)) {
                Name name = (Name)first;
                this.possibleTypeRefFound(name);
            }
            ++idx;
        }
        int i = idx;
        while (i < list.size()) {
            this.doVisitNode((ASTNode)list.get(i));
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(MemberRef node) {
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        return false;
    }

    @Override
    public boolean visit(MethodRef node) {
        List list;
        Name qualifier = node.getQualifier();
        if (qualifier != null) {
            this.typeRefFound(qualifier);
        }
        if ((list = node.parameters()) != null) {
            this.doVisitChildren(list);
        }
        return false;
    }
}

