/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.trinidad.facet;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.trinidad.TrinidadPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class TrinidadFacetUtil {
    public static final String TRINIDAD_FACET_ID = "jst.jsf.trinidad";
    static final String TEMPLATES_FOLDER = "templates/";
    static final String[] jspFiles = new String[]{"index.jsp"};
    static final String[] resourceBundle = new String[]{"resources/application.properties"};
    static final Map<String, String> templateFileMap = new HashMap<String, String>();

    static {
        templateFileMap.put("index.jsp", "templates/new-app/web-app-common/web/index.jsp");
        templateFileMap.put("application.properties", "templates/new-app/web-app-common/src/resources/application.properties");
    }

    public static List<IFile> getExistingTemplateFilesInProject(IProject project, IProjectFacetVersion fv) throws CoreException {
        ArrayList<IFile> existingIfiles = new ArrayList<IFile>();
        try {
            String WEB_CONTENT_FOLDER_NAME = FacetUtil.getWebContentFolderName((IProject)project);
            TrinidadFacetUtil.addFilesIfExistingToExistingIfilesList(jspFiles, existingIfiles, project, String.valueOf(WEB_CONTENT_FOLDER_NAME) + "/");
        }
        catch (CoreException e) {
            LoggingService.logError((Plugin)TrinidadPlugin.getDefault(), (String)e.getLocalizedMessage());
        }
        TrinidadFacetUtil.addFilesIfExistingToExistingIfilesList(resourceBundle, existingIfiles, project, String.valueOf(OperationUtil.getSrcFolderName((IProject)project)) + "/");
        return existingIfiles;
    }

    public static File getTemplateFile(IFile ifile, IProjectFacetVersion fv) throws IOException, URISyntaxException {
        String templateFileRelativePath = templateFileMap.get(ifile.getName());
        if (templateFileRelativePath == null) {
            throw new IllegalArgumentException("Template file \"" + ifile.getName() + "\" not found in map.");
        }
        File templateFile = FacetUtil.getFileFromPlugin((Plugin)TrinidadPlugin.getDefault(), (String)templateFileRelativePath);
        if (templateFile == null) {
            throw new IllegalArgumentException("Template file \"" + templateFileRelativePath + "\" not found in plugin " + TrinidadPlugin.getDefault().toString());
        }
        return templateFile;
    }

    public static void addFilesIfExistingToExistingIfilesList(String[] filenames, List<IFile> iFileList, IProject project, String filenamePrefix) {
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filenameToAdd = stringArray[n2];
            IFile iFile = project.getFile(String.valueOf(filenamePrefix) + filenameToAdd);
            if (iFile.isAccessible()) {
                iFileList.add(iFile);
            }
            ++n2;
        }
    }
}

