/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.trinidad.commands;

import oracle.eclipse.tools.webtier.trinidad.TrinidadPlugin;
import oracle.eclipse.tools.webtier.trinidad.dom.TrinidadDOMUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableDeleteColumnCommand
extends DesignerCommand {
    private Element _table;
    private int _index;

    public TableDeleteColumnCommand(IHTMLGraphicalViewer viewer, Element table, int columnIndex) {
        super(TrinidadPlugin.getResourceString("TableDeleteColumnCommand.Label.DeleteColumn"), viewer);
        this._table = table;
        this._index = columnIndex;
    }

    public boolean canExecute() {
        if (this._index < 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        NodeList children = this._table.getChildNodes();
        int index = 0;
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Node node = children.item(i);
            if (TrinidadDOMUtil.isTRColumn(node) && index++ == this._index) {
                this._table.removeChild(node);
                return;
            }
            ++i;
        }
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._table);
    }
}

