/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoCommand
extends GitCommand<RevCommit> {
    private String path;
    private String uri;
    private String groups;
    private Git git;
    private ProgressMonitor monitor;

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    @Override
    public RevCommit call() throws GitAPIException {
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        this.git = new Git(this.repo);
        XmlManifest manifest = new XmlManifest(this, this.path, this.uri, this.groups);
        try {
            manifest.read();
        }
        catch (IOException e) {
            throw new ManifestErrorException(e);
        }
        return this.git.commit().setMessage(RepoText.get().repoCommitMessage).call();
    }

    private void addSubmodule(String url, String name) throws SAXException {
        SubmoduleAddCommand add = this.git.submoduleAdd().setPath(name).setURI(url);
        if (this.monitor != null) {
            add.setProgressMonitor(this.monitor);
        }
        try {
            add.call();
        }
        catch (GitAPIException e) {
            throw new SAXException(e);
        }
    }

    private static class CopyFile {
        final String src;
        final String dest;
        final String relativeDest;

        CopyFile(Repository repo, String path, String src, String dest) {
            this.src = repo.getWorkTree() + "/" + path + "/" + src;
            this.relativeDest = dest;
            this.dest = repo.getWorkTree() + "/" + dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void copy() throws IOException {
            FileInputStream input = new FileInputStream(this.src);
            try {
                FileOutputStream output = new FileOutputStream(this.dest);
                try {
                    FileChannel channel = input.getChannel();
                    output.getChannel().transferFrom(channel, 0L, channel.size());
                }
                finally {
                    output.close();
                }
            }
            finally {
                input.close();
            }
        }
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    private static class Project {
        final String name;
        final String path;
        final Set<String> groups;
        final List<CopyFile> copyfiles;

        Project(String name, String path, String groups) {
            this.name = name;
            this.path = path;
            this.groups = new HashSet<String>();
            if (groups != null && groups.length() > 0) {
                this.groups.addAll(Arrays.asList(groups.split(",")));
            }
            this.copyfiles = new ArrayList<CopyFile>();
        }

        void addCopyFile(CopyFile copyfile) {
            this.copyfiles.add(copyfile);
        }
    }

    private static class XmlManifest
    extends DefaultHandler {
        private final RepoCommand command;
        private final String filename;
        private final String baseUrl;
        private final Map<String, String> remotes;
        private final List<Project> projects;
        private final Set<String> plusGroups;
        private final Set<String> minusGroups;
        private String defaultRemote;
        private Project currentProject;

        XmlManifest(RepoCommand command, String filename, String baseUrl, String groups) {
            this.command = command;
            this.filename = filename;
            this.baseUrl = baseUrl;
            this.remotes = new HashMap<String, String>();
            this.projects = new ArrayList<Project>();
            this.plusGroups = new HashSet<String>();
            this.minusGroups = new HashSet<String>();
            if (groups == null || groups.length() == 0 || groups.equals("default")) {
                this.minusGroups.add("notdefault");
            } else {
                for (String group : groups.split(",")) {
                    if (group.startsWith("-")) {
                        this.minusGroups.add(group.substring(1));
                        continue;
                    }
                    this.plusGroups.add(group);
                }
            }
        }

        void read() throws IOException {
            XMLReader xr;
            try {
                xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                throw new IOException(JGitText.get().noXMLParserAvailable);
            }
            xr.setContentHandler(this);
            FileInputStream in = new FileInputStream(this.filename);
            try {
                xr.parse(new InputSource(in));
            }
            catch (SAXException e) {
                IOException error = new IOException(MessageFormat.format(RepoText.get().errorParsingManifestFile, this.filename));
                error.initCause(e);
                throw error;
            }
            finally {
                in.close();
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("project".equals(qName)) {
                this.currentProject = new Project(attributes.getValue("name"), attributes.getValue("path"), attributes.getValue("groups"));
            } else if ("remote".equals(qName)) {
                this.remotes.put(attributes.getValue("name"), attributes.getValue("fetch"));
            } else if ("default".equals(qName)) {
                this.defaultRemote = attributes.getValue("remote");
            } else if ("copyfile".equals(qName)) {
                if (this.currentProject == null) {
                    throw new SAXException(RepoText.get().invalidManifest);
                }
                this.currentProject.addCopyFile(new CopyFile(this.command.repo, this.currentProject.path, attributes.getValue("src"), attributes.getValue("dest")));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("project".equals(qName)) {
                this.projects.add(this.currentProject);
                this.currentProject = null;
            }
        }

        public void endDocument() throws SAXException {
            String remoteUrl;
            if (this.defaultRemote == null) {
                throw new SAXException(MessageFormat.format(RepoText.get().errorNoDefault, this.filename));
            }
            try {
                URI uri = new URI(String.format("%s/%s/", this.baseUrl, this.remotes.get(this.defaultRemote)));
                remoteUrl = uri.normalize().toString();
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            for (Project proj : this.projects) {
                if (!this.inGroups(proj)) continue;
                String url = remoteUrl + proj.name;
                this.command.addSubmodule(url, proj.path);
                for (CopyFile copyfile : proj.copyfiles) {
                    try {
                        copyfile.copy();
                    }
                    catch (IOException e) {
                        throw new SAXException(RepoText.get().copyFileFailed, e);
                    }
                    AddCommand add = this.command.git.add().addFilepattern(copyfile.relativeDest);
                    try {
                        add.call();
                    }
                    catch (GitAPIException e) {
                        throw new SAXException(e);
                    }
                }
            }
        }

        boolean inGroups(Project proj) {
            for (String group : this.minusGroups) {
                if (!proj.groups.contains(group)) continue;
                return false;
            }
            if (this.plusGroups.isEmpty() || this.plusGroups.contains("all")) {
                return true;
            }
            for (String group : this.plusGroups) {
                if (!proj.groups.contains(group)) continue;
                return true;
            }
            return false;
        }
    }
}

