/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.File;
import java.io.IOException;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.WatchService;
import name.pachler.nio.file.impl.PathWatchService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathImpl
extends Path {
    private File file;

    public PathImpl(File file) {
        this.file = file;
    }

    @Override
    public Path resolve(Path other) {
        PathImpl otherImpl = (PathImpl)other;
        if (otherImpl == null) {
            return this;
        }
        if (otherImpl.getFile().isAbsolute()) {
            return otherImpl;
        }
        return new PathImpl(new File(this.getFile(), otherImpl.toString()));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        PathWatchService pws = (PathWatchService)watcher;
        return pws.register(this, events, modifiers);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathImpl other = (PathImpl)obj;
        return this.file == other.file || this.file != null && this.file.equals(other.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }
}

