/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCachingEntity;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching.EclipseLinkEntityCachingPropertyComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.plugin.JptJpaEclipseLinkUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkEntityListComposite<T extends EclipseLinkCaching>
extends Pane<T> {
    private ModifiableCollectionValueModel<EclipseLinkCachingEntity> selectedEntitiesModel;
    private PropertyValueModel<EclipseLinkCachingEntity> selectedEntityModel;

    public EclipseLinkEntityListComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedEntitiesModel = this.buildSelectedEntitiesModel();
        this.selectedEntityModel = this.buildSelectedEntityModel((CollectionValueModel<EclipseLinkCachingEntity>)this.selectedEntitiesModel);
    }

    private ModifiableCollectionValueModel<EclipseLinkCachingEntity> buildSelectedEntitiesModel() {
        return new SimpleCollectionValueModel();
    }

    private PropertyValueModel<EclipseLinkCachingEntity> buildSelectedEntityModel(CollectionValueModel<EclipseLinkCachingEntity> selectedEntitiesModel) {
        return new CollectionPropertyValueModelAdapter<EclipseLinkCachingEntity, EclipseLinkCachingEntity>(selectedEntitiesModel){

            protected EclipseLinkCachingEntity buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (EclipseLinkCachingEntity)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, JptJpaEclipseLinkUiMessages.CACHING_ENTITY_LIST_COMPOSITE_GROUP_TITLE);
    }

    protected void initializeLayout(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.selectedEntitiesModel, this.buildEntityLabelProvider(), EclipseLinkHelpContextIds.PERSISTENCE_CACHING);
        new EclipseLinkEntityCachingPropertyComposite(this, this.selectedEntityModel, this.buildPaneEnablerModel(this.selectedEntityModel), container);
    }

    private AddRemovePane.Adapter<EclipseLinkCachingEntity> buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter<EclipseLinkCachingEntity>(){

            public EclipseLinkCachingEntity addNewItem() {
                return EclipseLinkEntityListComposite.this.addEntity();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<EclipseLinkCachingEntity> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<EclipseLinkCachingEntity> selectedItemsModel) {
                EclipseLinkCachingEntity cachingEntity = (EclipseLinkCachingEntity)selectedItemsModel.iterator().next();
                ((EclipseLinkCaching)EclipseLinkEntityListComposite.this.getSubject()).removeEntity(cachingEntity.getName());
            }
        };
    }

    private EclipseLinkCachingEntity addEntity() {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((EclipseLinkCaching)this.getSubject()).entityExists(entityName)) {
                return ((EclipseLinkCaching)this.getSubject()).addEntity(entityName);
            }
        }
        return null;
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        Entity entity = ((EclipseLinkCaching)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()}), (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException ex) {
            JptJpaEclipseLinkUiPlugin.instance().logError(ex);
            return null;
        }
        dialog.setTitle(JptJpaEclipseLinkUiMessages.CACHING_ENTITY_LIST_COMPOSITE_DIALOG_TITLE);
        dialog.setMessage(JptJpaEclipseLinkUiMessages.CACHING_ENTITY_LIST_COMPOSITE_DIALOG_MESSAGE);
        return dialog.open() == 0 ? (IType)dialog.getResult()[0] : null;
    }

    private IJavaProject getJavaProject() {
        return ((EclipseLinkCaching)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                EclipseLinkCachingEntity entityCaching = (EclipseLinkCachingEntity)element;
                return entityCaching.getName();
            }
        };
    }

    private ListValueModel<EclipseLinkCachingEntity> buildEntitiesListHolder() {
        return new ListAspectAdapter<EclipseLinkCaching, EclipseLinkCachingEntity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterable<EclipseLinkCachingEntity> getListIterable() {
                return ((EclipseLinkCaching)this.subject).getEntities();
            }

            protected int size_() {
                return ((EclipseLinkCaching)this.subject).getEntitiesSize();
            }
        };
    }

    private PropertyValueModel<Boolean> buildPaneEnablerModel(PropertyValueModel<EclipseLinkCachingEntity> entityHolder) {
        return new TransformationPropertyValueModel<EclipseLinkCachingEntity, Boolean>(entityHolder){

            protected Boolean transform_(EclipseLinkCachingEntity value) {
                return value.entityNameIsValid();
            }
        };
    }
}

