/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.myfaces.shared.util.ClassUtils;

public class ReflectionUtil {
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (name == null || "".equals(name)) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = ClassUtils.classForName(nc);
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = ClassUtils.classForName(name);
            }
        }
        return c;
    }

    protected static Class<?> forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        int i = 0;
        while (i < s.length) {
            c[i] = ReflectionUtil.forName(s[i]);
            ++i;
        }
        return c;
    }

    public static String[] toTypeNameArray(Class<?>[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        int i = 0;
        while (i < c.length) {
            s[i] = c[i].getName();
            ++i;
        }
        return s;
    }

    protected static final String paramString(Class<?> ... types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                sb.append(type.getName()).append(", ");
                ++n2;
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }
}

