/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesWrapper;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.view.EditableValueHolderAttachedObjectHandler;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandlerDelegate;
import javax.faces.view.facelets.ValidatorHandler;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.view.facelets.tag.jsf.ActionSourceRule;
import org.apache.myfaces.view.facelets.tag.jsf.ClearBindingValueExpressionListener;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentBuilderHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentRule;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.EditableValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.PreDisposeViewEvent;
import org.apache.myfaces.view.facelets.tag.jsf.RelocatableResourceHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ValueHolderRule;
import org.apache.myfaces.view.facelets.tag.jsf.core.AjaxHandler;

public class ComponentTagHandlerDelegate
extends TagHandlerDelegate {
    private static final Logger log = Logger.getLogger(ComponentTagHandlerDelegate.class.getName());
    private final ComponentHandler _delegate;
    private final String _componentType;
    private final TagAttribute _id;
    private final String _rendererType;
    private final ComponentBuilderHandler _componentBuilderHandlerDelegate;
    private final RelocatableResourceHandler _relocatableResourceHandler;

    public ComponentTagHandlerDelegate(ComponentHandler delegate) {
        ComponentHandler handler = this._delegate = delegate;
        boolean found = false;
        while (handler != null && !found) {
            if (handler instanceof ComponentBuilderHandler) {
                found = true;
                continue;
            }
            handler = handler instanceof FacesWrapper ? (ComponentHandler)((FacesWrapper)((Object)handler)).getWrapped() : null;
        }
        this._componentBuilderHandlerDelegate = found ? (ComponentBuilderHandler)((Object)handler) : null;
        handler = this._delegate;
        found = false;
        while (handler != null && !found) {
            if (handler instanceof RelocatableResourceHandler) {
                found = true;
                continue;
            }
            handler = handler instanceof FacesWrapper ? (ComponentHandler)((FacesWrapper)((Object)handler)).getWrapped() : null;
        }
        this._relocatableResourceHandler = found ? (RelocatableResourceHandler)((Object)handler) : null;
        ComponentConfig delegateComponentConfig = delegate.getComponentConfig();
        this._componentType = delegateComponentConfig.getComponentType();
        this._rendererType = delegateComponentConfig.getRendererType();
        this._id = delegate.getTagAttribute("id");
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null) {
            throw new TagException(this._delegate.getTag(), "Parent UIComponent was null");
        }
        FacesContext facesContext = ctx.getFacesContext();
        String facetName = this.getFacetName(ctx, parent);
        String id = ctx.generateUniqueId(this._delegate.getTagId());
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        UIComponent c = null;
        UIComponent oldParent = parent;
        if (mctx.isRefreshingSection()) {
            c = this._relocatableResourceHandler != null ? this._relocatableResourceHandler.findChildByTagId(ctx, parent, id) : ComponentSupport.findChildByTagId(parent, id);
        }
        boolean componentFound = false;
        if (c != null) {
            componentFound = true;
            mctx.incrementUniqueComponentId();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._delegate.getTag() + " Component[" + id + "] Found, marking children for cleanup");
            }
            mctx.markForDeletion(c);
        } else {
            c = this.createComponent(ctx);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._delegate.getTag() + " Component[" + id + "] Created: " + c.getClass().getName());
            }
            this._delegate.setAttributes(ctx, c);
            c.getAttributes().put("oam.vf.MARK_ID", id);
            if (facesContext.isProjectStage(ProjectStage.Development)) {
                c.getAttributes().put("javax.faces.component.VIEW_LOCATION_KEY", this._delegate.getTag().getLocation());
            }
            if (this._id != null) {
                mctx.incrementUniqueComponentId();
                c.setId(this._id.getValue(ctx));
            } else {
                String componentId = mctx.generateUniqueComponentId();
                UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
                if (uniqueIdVendor == null && (uniqueIdVendor = facesContext.getViewRoot()) == null) {
                    uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
                }
                if (uniqueIdVendor != null) {
                    String uid = uniqueIdVendor.createUniqueId(facesContext, componentId);
                    c.setId(uid);
                }
            }
            if (this._rendererType != null) {
                c.setRendererType(this._rendererType);
            }
            this._delegate.onComponentCreated(ctx, c, parent);
        }
        c.pushComponentToEL(facesContext, c);
        if (c instanceof UniqueIdVendor) {
            mctx.pushUniqueIdVendorToStack((UniqueIdVendor)((Object)c));
        }
        this._delegate.applyNextHandler(ctx, c);
        boolean oldProcessingEvents = facesContext.isProcessingEvents();
        if (componentFound) {
            mctx.finalizeForDeletion(c);
            if (mctx.isRefreshingSection()) {
                facesContext.setProcessingEvents(false);
                if (this._relocatableResourceHandler != null && parent != null && !parent.equals(c.getParent())) {
                    parent = c.getParent();
                }
            }
            if (facetName == null) {
                parent.getChildren().remove(c);
            } else {
                ComponentSupport.removeFacet(ctx, parent, c, facetName);
            }
            if (mctx.isRefreshingSection()) {
                facesContext.setProcessingEvents(oldProcessingEvents);
            }
        }
        if (!componentFound) {
            Iterator<AjaxHandler> it;
            if (c instanceof ClientBehaviorHolder && !UIComponent.isCompositeComponent(c) && (it = ((AbstractFaceletContext)ctx).getAjaxHandlers()) != null) {
                while (it.hasNext()) {
                    it.next().applyAttachedObject(facesContext, c);
                }
            }
            if (c instanceof EditableValueHolder) {
                this.addEnclosingAndDefaultValidators(ctx, mctx, facesContext, (EditableValueHolder)((Object)c));
            }
        }
        this._delegate.onComponentPopulated(ctx, c, oldParent);
        if (componentFound && mctx.isRefreshingSection()) {
            facesContext.setProcessingEvents(false);
        }
        if (facetName == null) {
            parent.getChildren().add(c);
        } else {
            ComponentSupport.addFacet(ctx, parent, c, facetName);
        }
        if (componentFound && mctx.isRefreshingSection()) {
            facesContext.setProcessingEvents(oldProcessingEvents);
        }
        if (c instanceof UniqueIdVendor) {
            mctx.popUniqueIdVendorToStack();
        }
        c.popComponentFromEL(facesContext);
        if (mctx.isMarkInitialState()) {
            c.markInitialState();
        }
    }

    protected final String getFacetName(FaceletContext ctx, UIComponent parent) {
        return (String)parent.getAttributes().get("facelets.FACET_NAME");
    }

    protected UIComponent createComponent(FaceletContext ctx) {
        if (this._componentBuilderHandlerDelegate != null) {
            return this._componentBuilderHandlerDelegate.createComponent(ctx);
        }
        UIComponent c = null;
        FacesContext faces = ctx.getFacesContext();
        Application app = faces.getApplication();
        if (this._delegate.getBinding() != null) {
            ValueExpression ve = this._delegate.getBinding().getValueExpression(ctx, Object.class);
            c = this._rendererType == null ? app.createComponent(ve, faces, this._componentType) : app.createComponent(ve, faces, this._componentType, this._rendererType);
            if (c != null) {
                c.setValueExpression("binding", ve);
                if (!ve.isReadOnly(faces.getELContext())) {
                    ComponentSupport.getViewRoot(ctx, c).getAttributes().put("oam.CALL_PRE_DISPOSE_VIEW", Boolean.TRUE);
                    c.subscribeToEvent(PreDisposeViewEvent.class, new ClearBindingValueExpressionListener());
                }
            }
        } else {
            c = app.createComponent(faces, this._componentType, this._rendererType);
        }
        return c;
    }

    protected String getId(FaceletContext ctx) {
        if (this._id != null) {
            return this._id.getValue(ctx);
        }
        return ctx.generateUniqueId(this._delegate.getTagId());
    }

    @Override
    public MetaRuleset createMetaRuleset(Class type) {
        MetaRulesetImpl m = new MetaRulesetImpl(this._delegate.getTag(), type);
        ((MetaRuleset)m).ignore("binding").ignore("id");
        ((MetaRuleset)m).addRule(ComponentRule.INSTANCE);
        if (ActionSource.class.isAssignableFrom(type)) {
            ((MetaRuleset)m).addRule(ActionSourceRule.INSTANCE);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            ((MetaRuleset)m).addRule(ValueHolderRule.INSTANCE);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                ((MetaRuleset)m).ignore("submittedValue");
                ((MetaRuleset)m).ignore("valid");
                ((MetaRuleset)m).addRule(EditableValueHolderRule.INSTANCE);
            }
        }
        return m;
    }

    private void addEnclosingAndDefaultValidators(FaceletContext ctx, FaceletCompositionContext mctx, FacesContext context, EditableValueHolder component) {
        Map<String, String> defaultValidators;
        Iterator<Map.Entry<String, EditableValueHolderAttachedObjectHandler>> enclosingValidatorIds = mctx.getEnclosingValidatorIdsAndHandlers();
        if (enclosingValidatorIds != null) {
            while (enclosingValidatorIds.hasNext()) {
                Map.Entry<String, EditableValueHolderAttachedObjectHandler> entry = enclosingValidatorIds.next();
                this.addEnclosingValidator(ctx, mctx, context, component, entry.getKey(), entry.getValue());
            }
        }
        if ((defaultValidators = context.getApplication().getDefaultValidatorInfo()) != null && defaultValidators.size() != 0) {
            for (Map.Entry<String, String> entry : defaultValidators.entrySet()) {
                if (mctx.containsEnclosingValidatorId(entry.getKey())) continue;
                this.addDefaultValidator(ctx, mctx, context, component, entry.getKey(), entry.getValue());
            }
        }
    }

    private void addDefaultValidator(FaceletContext ctx, FaceletCompositionContext mctx, FacesContext context, EditableValueHolder component, String validatorId, String validatorClassName) {
        BeanValidator beanValidator;
        String validationGroups;
        Validator enclosingValidator = null;
        if (validatorClassName == null) {
            enclosingValidator = context.getApplication().createValidator(validatorId);
            validatorClassName = enclosingValidator.getClass().getName();
        }
        Validator validator = null;
        Validator[] validatorArray = component.getValidators();
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.getClass().getName().equals(validatorClassName)) {
                validator = v;
                break;
            }
            ++n2;
        }
        if (validator == null) {
            if (this.shouldAddDefaultValidator(ctx, mctx, context, component, validatorId)) {
                validator = enclosingValidator != null ? enclosingValidator : context.getApplication().createValidator(validatorId);
                component.addValidator(validator);
            } else {
                return;
            }
        }
        if (validator instanceof BeanValidator && ((validationGroups = (beanValidator = (BeanValidator)validator).getValidationGroups()) == null || validationGroups.matches("^[\\W,]*$"))) {
            throw new UnsupportedOperationException("TODO: C.B.");
        }
    }

    private boolean shouldAddDefaultValidator(FaceletContext ctx, FaceletCompositionContext mctx, FacesContext facesContext, EditableValueHolder component, String validatorId) {
        Iterator<Map.Entry<String, EditableValueHolderAttachedObjectHandler>> enclosingValidatorIds;
        List exclusionList = (List)((UIComponent)((Object)component)).getAttributes().get("org.apache.myfaces.validator.VALIDATOR_ID_EXCLUSION_LIST");
        if (exclusionList != null) {
            for (String excludedId : exclusionList) {
                if (!excludedId.equals(validatorId)) continue;
                return false;
            }
        }
        if ((enclosingValidatorIds = mctx.getEnclosingValidatorIdsAndHandlers()) != null) {
            while (enclosingValidatorIds.hasNext()) {
                boolean validatorIdAvailable;
                Map.Entry<String, EditableValueHolderAttachedObjectHandler> entry = enclosingValidatorIds.next();
                boolean bl = validatorIdAvailable = entry.getKey() != null && !"".equals(entry.getKey());
                if (!validatorIdAvailable || !entry.getKey().equals(validatorId) || !((ValidatorHandler)((FacesWrapper)((Object)entry.getValue())).getWrapped()).isDisabled(ctx)) continue;
                return false;
            }
        }
        if (validatorId.equals("javax.faces.Bean") && !ExternalSpecifications.isBeanValidationAvailable()) {
            log.log(Level.WARNING, "Bean validation is not available on the classpath, thus the BeanValidator will not be added for the component " + component);
            return false;
        }
        return true;
    }

    private void addEnclosingValidator(FaceletContext ctx, FaceletCompositionContext mctx, FacesContext context, EditableValueHolder component, String validatorId, EditableValueHolderAttachedObjectHandler attachedObjectHandler) {
        if (this.shouldAddEnclosingValidator(mctx, context, component, validatorId)) {
            if (attachedObjectHandler != null) {
                attachedObjectHandler.applyAttachedObject(context, (UIComponent)((Object)component));
            } else {
                BeanValidator beanValidator;
                String validationGroups;
                Validator validator = null;
                validator = context.getApplication().createValidator(validatorId);
                if (validator instanceof BeanValidator && ((validationGroups = (beanValidator = (BeanValidator)validator).getValidationGroups()) == null || validationGroups.matches("^[\\W,]*$"))) {
                    throw new UnsupportedOperationException("TODO: C.B");
                }
                component.addValidator(validator);
            }
        }
    }

    private boolean shouldAddEnclosingValidator(FaceletCompositionContext mctx, FacesContext facesContext, EditableValueHolder component, String validatorId) {
        List exclusionList = (List)((UIComponent)((Object)component)).getAttributes().get("org.apache.myfaces.validator.VALIDATOR_ID_EXCLUSION_LIST");
        if (exclusionList != null) {
            for (String excludedId : exclusionList) {
                if (!excludedId.equals(validatorId)) continue;
                return false;
            }
        }
        if (validatorId.equals("javax.faces.Bean") && !ExternalSpecifications.isBeanValidationAvailable()) {
            log.log(Level.WARNING, "Bean validation is not available on the classpath, thus the BeanValidator will not be added for the component " + component);
            return false;
        }
        return true;
    }
}

