/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.tag.jsf.FaceletState;

public final class ComponentSupport {
    private static final String MARK_DELETED = "oam.vf.MARK_DELETED";
    public static final String MARK_CREATED = "oam.vf.MARK_ID";
    public static final String FACET_CREATED_UIPANEL_MARKER = "oam.vf.createdUIPanel";
    public static final String COMPONENT_ADDED_BY_HANDLER_MARKER = "oam.vf.addedByHandler";
    public static final String FACELET_STATE_INSTANCE = "oam.FACELET_STATE_INSTANCE";

    @Deprecated
    public static void finalizeForDeletion(UIComponent component) {
        Map<String, UIComponent> facets;
        component.getAttributes().remove(MARK_DELETED);
        if (component.getChildCount() > 0) {
            Iterator<UIComponent> iter = component.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = iter.next();
                if (!child.getAttributes().containsKey(MARK_DELETED)) continue;
                iter.remove();
            }
        }
        if (!(facets = component.getFacets()).isEmpty()) {
            Collection<UIComponent> col = facets.values();
            Iterator<UIComponent> itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = itr.next();
                if (!fc.getAttributes().containsKey(MARK_DELETED)) continue;
                itr.remove();
            }
        }
    }

    public static UIComponent findChild(UIComponent parent, String id) {
        int childCount = parent.getChildCount();
        if (childCount > 0) {
            int i = 0;
            while (i < childCount) {
                UIComponent child = parent.getChildren().get(i);
                if (id.equals(child.getId())) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    public static UIComponent findChildByTagId(UIComponent parent, String id) {
        Iterator<UIComponent> itr = null;
        if (parent.getChildCount() > 0) {
            int i = 0;
            int childCount = parent.getChildCount();
            while (i < childCount) {
                UIComponent child = parent.getChildren().get(i);
                if (id.equals(child.getAttributes().get(MARK_CREATED))) {
                    return child;
                }
                ++i;
            }
        }
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
                    if (facet.getChildCount() > 0) {
                        int i = 0;
                        int childCount = facet.getChildCount();
                        while (i < childCount) {
                            UIComponent child = facet.getChildren().get(i);
                            if (id.equals(child.getAttributes().get(MARK_CREATED))) {
                                return child;
                            }
                            ++i;
                        }
                    }
                    if (facet.getFacetCount() <= 0) continue;
                    for (UIComponent child : facet.getFacets().values()) {
                        if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                        return child;
                    }
                    continue;
                }
                if (!id.equals(facet.getAttributes().get(MARK_CREATED))) continue;
                return facet;
            }
        }
        return null;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    @Deprecated
    public static void markForDeletion(UIComponent component) {
        component.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        Iterator<UIComponent> iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = iter.next();
            if (!child.getAttributes().containsKey(MARK_CREATED)) continue;
            child.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        }
    }

    public static void encodeRecursive(FacesContext context, UIComponent toRender) throws IOException, FacesException {
        if (toRender.isRendered()) {
            toRender.encodeBegin(context);
            if (toRender.getRendersChildren()) {
                toRender.encodeChildren(context);
            } else if (toRender.getChildCount() > 0) {
                int i = 0;
                int childCount = toRender.getChildCount();
                while (i < childCount) {
                    UIComponent child = toRender.getChildren().get(i);
                    ComponentSupport.encodeRecursive(context, child);
                    ++i;
                }
            }
            toRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent component) {
        Map<String, UIComponent> facets;
        if (component.getChildCount() > 0) {
            Iterator<UIComponent> itr = component.getChildren().iterator();
            while (itr.hasNext()) {
                UIComponent child = itr.next();
                if (child.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(child);
            }
        }
        if (!(facets = component.getFacets()).isEmpty()) {
            Iterator<UIComponent> itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent facet = itr.next();
                if (facet.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(facet);
            }
        }
    }

    @Deprecated
    public static boolean isNew(UIComponent component) {
        return component != null && component.getParent() == null;
    }

    private static UIComponent createFacetUIPanel(FaceletContext ctx, UIComponent parent, String facetName) {
        FacesContext facesContext = ctx.getFacesContext();
        UIComponent panel = facesContext.getApplication().createComponent(facesContext, "javax.faces.Panel", null);
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
        if (uniqueIdVendor == null) {
            uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
        }
        if (uniqueIdVendor != null) {
            int index = facetName.indexOf(46);
            String cleanFacetName = facetName;
            if (index >= 0) {
                cleanFacetName = facetName.replace('.', '_');
            }
            panel.setId(uniqueIdVendor.createUniqueId(facesContext, mctx.getSharedStringBuilder().append(parent.getId()).append("__f_").append(cleanFacetName).toString()));
        }
        panel.getAttributes().put(FACET_CREATED_UIPANEL_MARKER, Boolean.TRUE);
        panel.getAttributes().put(COMPONENT_ADDED_BY_HANDLER_MARKER, Boolean.TRUE);
        return panel;
    }

    public static void addFacet(FaceletContext ctx, UIComponent parent, UIComponent c, String facetName) {
        UIComponent facet = parent.getFacets().get(facetName);
        if (facet == null) {
            parent.getFacets().put(facetName, c);
        } else if (!(facet instanceof UIPanel)) {
            UIComponent child = facet;
            facet = ComponentSupport.createFacetUIPanel(ctx, parent, facetName);
            facet.getChildren().add(child);
            facet.getChildren().add(c);
            parent.getFacets().put(facetName, facet);
        } else if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
            facet.getChildren().add(c);
        } else {
            UIComponent oldPanel = facet;
            facet = ComponentSupport.createFacetUIPanel(ctx, parent, facetName);
            facet.getChildren().add(oldPanel);
            facet.getChildren().add(c);
            parent.getFacets().put(facetName, facet);
        }
    }

    public static void removeFacet(FaceletContext ctx, UIComponent parent, UIComponent c, String facetName) {
        UIComponent facet = parent.getFacet(facetName);
        if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
            facet.getChildren().remove(c);
        } else {
            parent.getFacets().remove(facetName);
        }
    }

    public static void markComponentToRestoreFully(FacesContext context, UIComponent component) {
        if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isRefreshTransientBuildOnPSSPreserveState()) {
            component.getAttributes().put("oam.COMPONENT_ADDED_AFTER_BUILD_VIEW", (Object)ComponentState.REMOVE_ADD);
        }
        if (FaceletViewDeclarationLanguage.isRefreshTransientBuildOnPSSAuto(context)) {
            FaceletViewDeclarationLanguage.cleanTransientBuildOnRestore(context);
        }
    }

    public static UIComponent findComponentChildOrFacetFrom(FacesContext facesContext, UIComponent parent, String expr) {
        char separatorChar = UINamingContainer.getSeparatorChar(facesContext);
        int separator = expr.indexOf(separatorChar);
        if (separator == -1) {
            return ComponentSupport.findComponentChildOrFacetFrom(parent, expr, null);
        }
        return ComponentSupport.findComponentChildOrFacetFrom(parent, expr.substring(0, separator), expr);
    }

    public static UIComponent findComponentChildOrFacetFrom(UIComponent parent, String id, String innerExpr) {
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                UIComponent find;
                if (id.equals(facet.getId())) {
                    if (innerExpr == null) {
                        return facet;
                    }
                    if (!(facet instanceof NamingContainer) || (find = facet.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (facet instanceof NamingContainer || (find = ComponentSupport.findComponentChildOrFacetFrom(facet, id, innerExpr)) == null) continue;
                return find;
            }
        }
        if (parent.getChildCount() > 0) {
            int i = 0;
            int childCount = parent.getChildCount();
            while (i < childCount) {
                UIComponent find;
                UIComponent child = parent.getChildren().get(i);
                if (id.equals(child.getId())) {
                    if (innerExpr == null) {
                        return child;
                    }
                    if (child instanceof NamingContainer && (find = child.findComponent(innerExpr)) != null) {
                        return find;
                    }
                } else if (!(child instanceof NamingContainer) && (find = ComponentSupport.findComponentChildOrFacetFrom(child, id, innerExpr)) != null) {
                    return find;
                }
                ++i;
            }
        }
        return null;
    }

    public static String getFindComponentExpression(FacesContext facesContext, UIComponent component) {
        char separatorChar = UINamingContainer.getSeparatorChar(facesContext);
        UIComponent parent = component.getParent();
        StringBuilder sb = new StringBuilder();
        sb.append(component.getId());
        while (parent != null) {
            if (parent instanceof NamingContainer) {
                sb.insert(0, separatorChar);
                sb.insert(0, parent.getId());
            }
            parent = parent.getParent();
        }
        return sb.toString();
    }

    public static Object restoreInitialTagState(FaceletContext ctx, FaceletCompositionContext fcc, UIComponent parent, String uniqueId) {
        Object value = null;
        if (fcc.isUsingPSSOnThisView() && !fcc.isRefreshTransientBuildOnPSSPreserveState()) {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            FaceletState map = (FaceletState)root.getAttributes().get(FACELET_STATE_INSTANCE);
            value = map == null ? null : map.getState(uniqueId);
        }
        return value;
    }

    public static void saveInitialTagState(FaceletContext ctx, FaceletCompositionContext fcc, UIComponent parent, String uniqueId, Object value) {
        if (fcc.isUsingPSSOnThisView() && !fcc.isRefreshTransientBuildOnPSSPreserveState()) {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            FaceletState map = (FaceletState)root.getAttributes().get(FACELET_STATE_INSTANCE);
            if (map == null) {
                map = new FaceletState();
                root.getAttributes().put(FACELET_STATE_INSTANCE, map);
            }
            map.putState(uniqueId, value);
        }
    }
}

