/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.util.ArrayList;
import java.util.Collection;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletHandler;

public final class TagHandlerUtils {
    public static <T> T findFirstNextByType(FaceletHandler nextHandler, Class<T> type) {
        if (type.isAssignableFrom(nextHandler.getClass())) {
            return (T)nextHandler;
        }
        if (nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] faceletHandlerArray = ((CompositeFaceletHandler)nextHandler).getHandlers();
            int n = faceletHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FaceletHandler handler = faceletHandlerArray[n2];
                if (type.isAssignableFrom(handler.getClass())) {
                    return (T)handler;
                }
                ++n2;
            }
        }
        return null;
    }

    public static <T> Collection<T> findNextByType(FaceletHandler nextHandler, Class<T> type) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        if (type.isAssignableFrom(nextHandler.getClass())) {
            found.add(nextHandler);
        } else if (nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] faceletHandlerArray = ((CompositeFaceletHandler)nextHandler).getHandlers();
            int n = faceletHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FaceletHandler handler = faceletHandlerArray[n2];
                if (type.isAssignableFrom(handler.getClass())) {
                    found.add(handler);
                }
                ++n2;
            }
        }
        return found;
    }

    private TagHandlerUtils() {
    }

    public static Collection<FaceletHandler> findNextByType(FaceletHandler nextHandler, Class<?> ... type1) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        boolean isAssignable = false;
        int i = 0;
        while (i < type1.length && !isAssignable) {
            isAssignable = type1[i].isAssignableFrom(nextHandler.getClass());
            ++i;
        }
        if (isAssignable) {
            found.add(nextHandler);
        } else if (nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] faceletHandlerArray = ((CompositeFaceletHandler)nextHandler).getHandlers();
            int n = faceletHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FaceletHandler handler = faceletHandlerArray[n2];
                isAssignable = false;
                int i2 = 0;
                while (i2 < type1.length && !isAssignable) {
                    isAssignable = type1[i2].isAssignableFrom(handler.getClass());
                    ++i2;
                }
                if (isAssignable) {
                    found.add(handler);
                }
                ++n2;
            }
        }
        return found;
    }

    public static Collection<FaceletHandler> findNextByType(FaceletHandler nextHandler, Class<?> type1, Class<?> type2) {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        if (type1.isAssignableFrom(nextHandler.getClass()) || type2.isAssignableFrom(nextHandler.getClass())) {
            found.add(nextHandler);
        } else if (nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] faceletHandlerArray = ((CompositeFaceletHandler)nextHandler).getHandlers();
            int n = faceletHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                FaceletHandler handler = faceletHandlerArray[n2];
                if (type1.isAssignableFrom(handler.getClass()) || type2.isAssignableFrom(handler.getClass())) {
                    found.add(handler);
                }
                ++n2;
            }
        }
        return found;
    }
}

