/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.component;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.faces.render.Renderer;
import org.apache.myfaces.view.facelets.component.RepeatStatus;

public class UIRepeat
extends UIComponentBase
implements NamingContainer {
    public static final String COMPONENT_TYPE = "facelets.ui.Repeat";
    public static final String COMPONENT_FAMILY = "facelets";
    private static final DataModel<?> EMPTY_MODEL = new ListDataModel(Collections.emptyList());
    private static final Class<Object[]> OBJECT_ARRAY_CLASS = Object[].class;
    private static final Object[] LEAF_NO_STATE = new Object[2];
    private Object _initialDescendantComponentState = null;
    private Map<String, Collection<Object[]>> _rowStates = new HashMap<String, Collection<Object[]>>();
    private Map<String, DataModel> _dataModelMap = new HashMap<String, DataModel>();
    private boolean _isValidChilds = true;
    private int _end = -1;
    private int _count;
    private int _index = -1;
    private transient StringBuilder _clientIdBuffer;
    private transient Object _origValue;
    private transient Object _origVarStatus;
    private transient FacesContext _facesContext;

    public UIRepeat() {
        this.setRendererType(COMPONENT_TYPE);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public int getOffset() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.offset), 0);
    }

    public void setOffset(int offset) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.offset), offset);
    }

    public int getSize() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.size), -1);
    }

    public void setSize(int size) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.size), size);
    }

    public int getStep() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.step), 1);
    }

    public void setStep(int step) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.step), step);
    }

    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), var);
    }

    public String getVarStatus() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.varStatus));
    }

    public void setVarStatus(String varStatus) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.varStatus), varStatus);
    }

    protected DataModel getDataModel() {
        DataModel dataModel;
        String clientID = "";
        UIComponent parent = this.getParent();
        if (parent != null) {
            clientID = parent.getContainerClientId(this.getFacesContext());
        }
        if ((dataModel = this._dataModelMap.get(clientID)) == null) {
            dataModel = this.createDataModel();
            this._dataModelMap.put(clientID, dataModel);
        }
        return dataModel;
    }

    private DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel<Object>((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        return new ScalarDataModel<Object>(value);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModelMap.clear();
        } else if (name.equals("rowIndex")) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueExpression(name, binding);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
        this._dataModelMap.clear();
        this._rowStates.clear();
        this._isValidChilds = true;
    }

    @Override
    public String getContainerClientId(FacesContext context) {
        String clientId = super.getContainerClientId(context);
        int index = this.getIndex();
        if (index == -1) {
            return clientId;
        }
        StringBuilder bld = this._getBuffer();
        return bld.append(clientId).append(UINamingContainer.getSeparatorChar(context)).append(index).toString();
    }

    private RepeatStatus _getRepeatStatus() {
        return new RepeatStatus(this._count == 0, this._index + this.getStep() >= this.getDataModel().getRowCount(), this._count, this._index, this.getOffset(), this._end, this.getStep());
    }

    private void _captureScopeValues() {
        String varStatus;
        String var = this.getVar();
        if (var != null) {
            this._origValue = this.getFacesContext().getExternalContext().getRequestMap().get(var);
        }
        if ((varStatus = this.getVarStatus()) != null) {
            this._origVarStatus = this.getFacesContext().getExternalContext().getRequestMap().get(varStatus);
        }
    }

    private StringBuilder _getBuffer() {
        if (this._clientIdBuffer == null) {
            this._clientIdBuffer = new StringBuilder();
        }
        this._clientIdBuffer.setLength(0);
        return this._clientIdBuffer;
    }

    private boolean _isIndexAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    private void _restoreScopeValues() {
        String var = this.getVar();
        if (var != null) {
            Map<String, Object> attrs = this.getFacesContext().getExternalContext().getRequestMap();
            if (this._origValue != null) {
                attrs.put(var, this._origValue);
                this._origValue = null;
            } else {
                attrs.remove(var);
            }
        }
        String varStatus = this.getVarStatus();
        if (this.getVarStatus() != null) {
            Map<String, Object> attrs = this.getFacesContext().getExternalContext().getRequestMap();
            if (this._origVarStatus != null) {
                attrs.put(varStatus, this._origVarStatus);
                this._origVarStatus = null;
            } else {
                attrs.remove(varStatus);
            }
        }
    }

    private void restoreDescendantComponentStates(UIComponent parent, boolean iterateFacets, Object state, boolean restoreChildFacets) {
        Object[] object;
        int descendantStateIndex = -1;
        List stateCollection = null;
        if (iterateFacets && parent.getFacetCount() > 0) {
            for (UIComponent component : parent.getFacets().values()) {
                component.setId(component.getId());
                if (component.isTransient()) continue;
                if (descendantStateIndex == -1) {
                    stateCollection = (List)state;
                    int n = descendantStateIndex = stateCollection.isEmpty() ? -1 : 0;
                }
                if (descendantStateIndex != -1 && descendantStateIndex < stateCollection.size()) {
                    object = (Object[])stateCollection.get(descendantStateIndex);
                    if (object[0] != null && component instanceof EditableValueHolder) {
                        ((SavedState)object[0]).restoreState((EditableValueHolder)((Object)component));
                    }
                    if (object[1] != null) {
                        this.restoreDescendantComponentStates(component, restoreChildFacets, object[1], true);
                    } else {
                        this.restoreDescendantComponentWithoutRestoreState(component, restoreChildFacets, true);
                    }
                } else {
                    this.restoreDescendantComponentWithoutRestoreState(component, restoreChildFacets, true);
                }
                ++descendantStateIndex;
            }
        }
        if (parent.getChildCount() > 0) {
            int i = 0;
            while (i < parent.getChildCount()) {
                UIComponent component;
                component = parent.getChildren().get(i);
                component.setId(component.getId());
                if (!component.isTransient()) {
                    if (descendantStateIndex == -1) {
                        stateCollection = (List)state;
                        int n = descendantStateIndex = stateCollection.isEmpty() ? -1 : 0;
                    }
                    if (descendantStateIndex != -1 && descendantStateIndex < stateCollection.size()) {
                        object = (Object[])stateCollection.get(descendantStateIndex);
                        if (object[0] != null && component instanceof EditableValueHolder) {
                            ((SavedState)object[0]).restoreState((EditableValueHolder)((Object)component));
                        }
                        if (object[1] != null) {
                            this.restoreDescendantComponentStates(component, restoreChildFacets, object[1], true);
                        } else {
                            this.restoreDescendantComponentWithoutRestoreState(component, restoreChildFacets, true);
                        }
                    } else {
                        this.restoreDescendantComponentWithoutRestoreState(component, restoreChildFacets, true);
                    }
                    ++descendantStateIndex;
                }
                ++i;
            }
        }
    }

    private void restoreDescendantComponentWithoutRestoreState(UIComponent parent, boolean iterateFacets, boolean restoreChildFacets) {
        if (iterateFacets && parent.getFacetCount() > 0) {
            for (UIComponent component : parent.getFacets().values()) {
                component.setId(component.getId());
                if (component.isTransient()) continue;
                this.restoreDescendantComponentWithoutRestoreState(component, restoreChildFacets, true);
            }
        }
        if (parent.getChildCount() > 0) {
            int i = 0;
            while (i < parent.getChildCount()) {
                UIComponent component;
                component = parent.getChildren().get(i);
                component.setId(component.getId());
                if (!component.isTransient()) {
                    this.restoreDescendantComponentWithoutRestoreState(component, restoreChildFacets, true);
                }
                ++i;
            }
        }
    }

    private Collection<Object[]> saveDescendantComponentStates(UIComponent parent, boolean iterateFacets, boolean saveChildFacets) {
        int ci;
        ArrayList<Object[]> childStates = null;
        int childEmptyIndex = 0;
        int totalChildCount = 0;
        if (iterateFacets && parent.getFacetCount() > 0) {
            for (UIComponent child : parent.getFacets().values()) {
                if (!child.isTransient()) {
                    if (child instanceof EditableValueHolder) {
                        Object[] objectArray;
                        if (childStates == null) {
                            childStates = new ArrayList<Object[]>(parent.getFacetCount() + parent.getChildCount() - totalChildCount + childEmptyIndex);
                            int ci2 = 0;
                            while (ci2 < childEmptyIndex) {
                                childStates.add(LEAF_NO_STATE);
                                ++ci2;
                            }
                        }
                        if (child.getChildCount() > 0) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = new SavedState((EditableValueHolder)((Object)child));
                            objectArray = objectArray2;
                            objectArray2[1] = this.saveDescendantComponentStates(child, saveChildFacets, true);
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray = objectArray3;
                            objectArray3[0] = new SavedState((EditableValueHolder)((Object)child));
                        }
                        childStates.add(objectArray);
                    } else if (child.getChildCount() > 0 || saveChildFacets && child.getFacetCount() > 0) {
                        Collection<Object[]> descendantSavedState = this.saveDescendantComponentStates(child, saveChildFacets, true);
                        if (descendantSavedState == null) {
                            if (childStates == null) {
                                ++childEmptyIndex;
                            } else {
                                childStates.add(LEAF_NO_STATE);
                            }
                        } else {
                            if (childStates == null) {
                                childStates = new ArrayList(parent.getFacetCount() + parent.getChildCount() - totalChildCount + childEmptyIndex);
                                ci = 0;
                                while (ci < childEmptyIndex) {
                                    childStates.add(LEAF_NO_STATE);
                                    ++ci;
                                }
                            }
                            Object[] objectArray = new Object[2];
                            objectArray[1] = descendantSavedState;
                            childStates.add(objectArray);
                        }
                    } else if (childStates == null) {
                        ++childEmptyIndex;
                    } else {
                        childStates.add(LEAF_NO_STATE);
                    }
                }
                ++totalChildCount;
            }
        }
        if (parent.getChildCount() > 0) {
            int i = 0;
            while (i < parent.getChildCount()) {
                UIComponent child;
                child = parent.getChildren().get(i);
                if (!child.isTransient()) {
                    if (child instanceof EditableValueHolder) {
                        Object[] objectArray;
                        if (childStates == null) {
                            childStates = new ArrayList(parent.getFacetCount() + parent.getChildCount() - totalChildCount + childEmptyIndex);
                            int ci3 = 0;
                            while (ci3 < childEmptyIndex) {
                                childStates.add(LEAF_NO_STATE);
                                ++ci3;
                            }
                        }
                        if (child.getChildCount() > 0) {
                            Object[] objectArray4 = new Object[2];
                            objectArray4[0] = new SavedState((EditableValueHolder)((Object)child));
                            objectArray = objectArray4;
                            objectArray4[1] = this.saveDescendantComponentStates(child, saveChildFacets, true);
                        } else {
                            Object[] objectArray5 = new Object[2];
                            objectArray = objectArray5;
                            objectArray5[0] = new SavedState((EditableValueHolder)((Object)child));
                        }
                        childStates.add(objectArray);
                    } else if (child.getChildCount() > 0 || saveChildFacets && child.getFacetCount() > 0) {
                        Collection<Object[]> descendantSavedState = this.saveDescendantComponentStates(child, saveChildFacets, true);
                        if (descendantSavedState == null) {
                            if (childStates == null) {
                                ++childEmptyIndex;
                            } else {
                                childStates.add(LEAF_NO_STATE);
                            }
                        } else {
                            if (childStates == null) {
                                childStates = new ArrayList(parent.getFacetCount() + parent.getChildCount() - totalChildCount + childEmptyIndex);
                                ci = 0;
                                while (ci < childEmptyIndex) {
                                    childStates.add(LEAF_NO_STATE);
                                    ++ci;
                                }
                            }
                            Object[] objectArray = new Object[2];
                            objectArray[1] = descendantSavedState;
                            childStates.add(objectArray);
                        }
                    } else if (childStates == null) {
                        ++childEmptyIndex;
                    } else {
                        childStates.add(LEAF_NO_STATE);
                    }
                }
                ++totalChildCount;
                ++i;
            }
        }
        return childStates;
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public int getIndex() {
        return this._index;
    }

    private void _setIndex(int index) {
        Collection<Object[]> savedRowState;
        if (index < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this._index == index) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._index == -1) {
            if (this._initialDescendantComponentState == null) {
                this._initialDescendantComponentState = this.saveDescendantComponentStates(this, true, true);
            }
        } else if (this._initialDescendantComponentState != null && (savedRowState = this.saveDescendantComponentStates(this, true, true)) != null) {
            this._rowStates.put(this.getContainerClientId(facesContext), savedRowState);
        }
        this._index = index;
        DataModel localModel = this.getDataModel();
        localModel.setRowIndex(index);
        if (this._index != -1) {
            String varStatus;
            String var = this.getVar();
            if (var != null && localModel.isRowAvailable()) {
                this.getFacesContext().getExternalContext().getRequestMap().put(var, localModel.getRowData());
            }
            if ((varStatus = this.getVarStatus()) != null) {
                this.getFacesContext().getExternalContext().getRequestMap().put(varStatus, this._getRepeatStatus());
            }
        }
        if (this._index == -1) {
            if (this._initialDescendantComponentState != null) {
                this.restoreDescendantComponentStates(this, true, this._initialDescendantComponentState, true);
            } else {
                this.restoreDescendantComponentWithoutRestoreState(this, true, true);
            }
        } else {
            Collection<Object[]> rowState = this._rowStates.get(this.getContainerClientId(facesContext));
            if (rowState == null) {
                if (this._initialDescendantComponentState != null) {
                    this.restoreDescendantComponentStates(this, true, this._initialDescendantComponentState, true);
                } else {
                    this.restoreDescendantComponentWithoutRestoreState(this, true, true);
                }
            } else {
                this.restoreDescendantComponentStates(this, true, rowState, true);
            }
        }
    }

    private int _calculateCountForIndex(int index) {
        return (index - this.getOffset()) / this.getStep();
    }

    private void _validateAttributes() throws FacesException {
        int begin = this.getOffset();
        int end = this.getDataModel().getRowCount();
        int size = this.getSize();
        int step = this.getStep();
        boolean sizeIsEnd = false;
        if (size == -1) {
            size = end;
            sizeIsEnd = true;
        }
        if (end >= 0) {
            if (size < 0) {
                throw new FacesException("iteration size cannot be less than zero");
            }
            if (!sizeIsEnd && begin + size > end) {
                throw new FacesException("iteration size cannot be greater than collection size");
            }
        }
        if (size > -1 && begin > end) {
            throw new FacesException("iteration offset cannot be greater than collection size");
        }
        if (step == -1) {
            this.setStep(1);
        }
        if (step < 0) {
            throw new FacesException("iteration step size cannot be less than zero");
        }
        if (step == 0) {
            throw new FacesException("iteration step size cannot be equal to zero");
        }
        this._end = size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(FacesContext faces, PhaseId phase) {
        if (!this.isRendered()) {
            return;
        }
        this._validateAttributes();
        this._captureScopeValues();
        this._setIndex(-1);
        try {
            try {
                if (this.getChildCount() <= 0) return;
                int i = this.getOffset();
                int end = this.getSize();
                int step = this.getStep();
                end = end >= 0 ? i + end : 0x7FFFFFFE;
                String rendererType = this.getRendererType();
                Renderer renderer = null;
                if (rendererType != null) {
                    renderer = this.getRenderer(faces);
                }
                this._count = 0;
                this._setIndex(i);
                while (i <= end) {
                    if (!this._isIndexAvailable()) {
                        return;
                    }
                    if (PhaseId.RENDER_RESPONSE.equals(phase) && renderer != null) {
                        renderer.encodeChildren(faces, this);
                    } else {
                        int j = 0;
                        int childCount = this.getChildCount();
                        while (j < childCount) {
                            UIComponent child = this.getChildren().get(j);
                            if (PhaseId.APPLY_REQUEST_VALUES.equals(phase)) {
                                child.processDecodes(faces);
                            } else if (PhaseId.PROCESS_VALIDATIONS.equals(phase)) {
                                child.processValidators(faces);
                            } else if (PhaseId.UPDATE_MODEL_VALUES.equals(phase)) {
                                child.processUpdates(faces);
                            } else if (PhaseId.RENDER_RESPONSE.equals(phase)) {
                                child.encodeAll(faces);
                            }
                            ++j;
                        }
                    }
                    ++this._count;
                    this._setIndex(i += step);
                }
                return;
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
        }
        finally {
            this._setIndex(-1);
            this._restoreScopeValues();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (context == null) throw new NullPointerException();
        if (clientId == null) throw new NullPointerException();
        if (callback == null) {
            throw new NullPointerException();
        }
        String baseClientId = this.getClientId(context);
        boolean returnValue = baseClientId.equals(clientId);
        boolean isCachedFacesContext = this.isTemporalFacesContext();
        if (!isCachedFacesContext) {
            this.setTemporalFacesContext(context);
        }
        this.pushComponentToEL(context, this);
        try {
            block27: {
                Iterator<UIComponent> it;
                block26: {
                    if (returnValue) {
                        try {
                            callback.invokeContextCallback(context, this);
                            return true;
                        }
                        catch (Exception e) {
                            throw new FacesException(e);
                        }
                    }
                    if (this.getFacetCount() > 0) {
                        Iterator<UIComponent> it2 = this.getFacets().values().iterator();
                        while (!returnValue && it2.hasNext()) {
                            returnValue = it2.next().invokeOnComponent(context, clientId, callback);
                        }
                    }
                    if (returnValue) {
                        boolean bl = returnValue;
                        return bl;
                    }
                    if (!clientId.startsWith(baseClientId)) return returnValue;
                    char separator = UINamingContainer.getSeparatorChar(context);
                    String subId = clientId.substring(baseClientId.length() + 1);
                    if (clientId.charAt(baseClientId.length()) == separator && subId.matches("[0-9]+" + separator + ".*")) {
                        String clientRow = subId.substring(0, subId.indexOf(separator));
                        int prevIndex = this._index;
                        int prevCount = this._count;
                        try {
                            int invokeIndex = Integer.parseInt(clientRow);
                            this._captureScopeValues();
                            if (invokeIndex != -1) {
                                this._count = this._calculateCountForIndex(invokeIndex);
                            }
                            this._setIndex(invokeIndex);
                            if (!this._isIndexAvailable()) {
                                return false;
                            }
                            Iterator<UIComponent> it1 = this.getChildren().iterator();
                            while (!returnValue) {
                                if (!it1.hasNext()) {
                                    return returnValue;
                                }
                                returnValue = it1.next().invokeOnComponent(context, clientId, callback);
                            }
                            return returnValue;
                        }
                        finally {
                            this._count = prevCount;
                            this._setIndex(prevIndex);
                            this._restoreScopeValues();
                        }
                    }
                    if (this.getChildCount() <= 0) return returnValue;
                    it = this.getChildren().iterator();
                    if (!true) break block26;
                    if (returnValue) return returnValue;
                    if (!it.hasNext()) break block27;
                }
                do {
                    returnValue = it.next().invokeOnComponent(context, clientId, callback);
                    if (returnValue) return returnValue;
                } while (it.hasNext());
            }
            return returnValue;
        }
        finally {
            this.popComponentFromEL(context);
            if (!isCachedFacesContext) {
                this.setTemporalFacesContext(null);
            }
        }
    }

    @Override
    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return super.getFacesContext();
        }
        return this._facesContext;
    }

    private boolean isTemporalFacesContext() {
        return this._facesContext != null;
    }

    private void setTemporalFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }

    @Override
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        Boolean skipIterationHint = context.getHints().contains((Object)VisitHint.SKIP_ITERATION);
        if (skipIterationHint != null && skipIterationHint.booleanValue()) {
            return super.visitTree(context, callback);
        }
        if (!this.isVisitable(context)) {
            return false;
        }
        int prevIndex = this._index;
        int prevCount = this._count;
        this._validateAttributes();
        this._captureScopeValues();
        this._setIndex(-1);
        this.pushComponentToEL(context.getFacesContext(), this);
        try {
            boolean doVisitChildren;
            VisitResult res = context.invokeVisitCallback(this, callback);
            switch (res) {
                case COMPLETE: {
                    return true;
                }
                case REJECT: {
                    return false;
                }
            }
            Collection<String> subtreeIdsToVisit = context.getSubtreeIdsToVisit(this);
            boolean bl = doVisitChildren = subtreeIdsToVisit != null && !subtreeIdsToVisit.isEmpty();
            if (doVisitChildren) {
                if (this.getFacetCount() > 0) {
                    for (UIComponent facet : this.getFacets().values()) {
                        if (!facet.visitTree(context, callback)) continue;
                        return true;
                    }
                }
                if (this.getChildCount() > 0) {
                    int i = this.getOffset();
                    int end = this.getSize();
                    int step = this.getStep();
                    end = end >= 0 ? i + end : 0x7FFFFFFE;
                    this._count = 0;
                    this._setIndex(i);
                    while (i <= end && this._isIndexAvailable()) {
                        int j = 0;
                        int childCount = this.getChildCount();
                        while (j < childCount) {
                            UIComponent child = this.getChildren().get(j);
                            if (child.visitTree(context, callback)) {
                                return true;
                            }
                            ++j;
                        }
                        ++this._count;
                        this._setIndex(i += step);
                    }
                }
            }
            return false;
        }
        finally {
            this.popComponentFromEL(context.getFacesContext());
            this._count = prevCount;
            this._setIndex(prevIndex);
            this._restoreScopeValues();
        }
    }

    @Override
    public void processDecodes(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.process(faces, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(faces);
    }

    @Override
    public void processUpdates(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.process(faces, PhaseId.UPDATE_MODEL_VALUES);
        if (faces.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    @Override
    public void processValidators(FacesContext faces) {
        if (!this.isRendered()) {
            return;
        }
        this.process(faces, PhaseId.PROCESS_VALIDATIONS);
        if (faces.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof IndexedEvent) {
            IndexedEvent idxEvent = (IndexedEvent)event;
            int prevIndex = this._index;
            int prevCount = this._count;
            try {
                this._captureScopeValues();
                if (idxEvent.getIndex() != -1) {
                    this._count = this._calculateCountForIndex(idxEvent.getIndex());
                }
                this._setIndex(idxEvent.getIndex());
                if (!this._isIndexAvailable()) return;
                FacesEvent target = idxEvent.getTarget();
                FacesContext facesContext = this.getFacesContext();
                UIComponent targetComponent = target.getComponent();
                UIComponent compositeParent = UIComponent.getCompositeComponentParent(targetComponent);
                if (compositeParent != null) {
                    this.pushComponentToEL(facesContext, compositeParent);
                }
                this.pushComponentToEL(facesContext, targetComponent);
                try {
                    targetComponent.broadcast(target);
                    return;
                }
                finally {
                    this.popComponentFromEL(facesContext);
                    if (compositeParent != null) {
                        this.popComponentFromEL(facesContext);
                    }
                }
            }
            finally {
                this._count = prevCount;
                this._setIndex(prevIndex);
                this._restoreScopeValues();
            }
        } else {
            super.broadcast(event);
        }
    }

    @Override
    public void queueEvent(FacesEvent event) {
        super.queueEvent(new IndexedEvent(this, event, this._index));
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this._initialDescendantComponentState = null;
        if (this._isValidChilds && !this.hasErrorMessages(context)) {
            this._dataModelMap.clear();
            this._rowStates.clear();
        }
        super.encodeBegin(context);
    }

    private boolean hasErrorMessages(FacesContext context) {
        Iterator<FacesMessage> iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo(message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void encodeChildren(FacesContext faces) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.process(faces, PhaseId.RENDER_RESPONSE);
    }

    @Override
    public boolean getRendersChildren() {
        Renderer renderer;
        if (this.getRendererType() != null && (renderer = this.getRenderer(this.getFacesContext())) != null) {
            return renderer.getRendersChildren();
        }
        return true;
    }

    private final class IndexedEvent
    extends FacesEvent {
        private final FacesEvent _target;
        private final int _index;

        public IndexedEvent(UIRepeat owner, FacesEvent target, int index) {
            super(owner);
            this._target = target;
            this._index = index;
        }

        @Override
        public PhaseId getPhaseId() {
            return this._target.getPhaseId();
        }

        @Override
        public void setPhaseId(PhaseId phaseId) {
            this._target.setPhaseId(phaseId);
        }

        @Override
        public boolean isAppropriateListener(FacesListener listener) {
            return this._target.isAppropriateListener(listener);
        }

        @Override
        public void processListener(FacesListener listener) {
            UIRepeat owner = (UIRepeat)this.getComponent();
            int prevIndex = owner._index;
            int prevCount = owner._count;
            try {
                owner._captureScopeValues();
                if (this._index != -1) {
                    UIRepeat.this._count = UIRepeat.this._calculateCountForIndex(this._index);
                }
                owner._setIndex(this._index);
                if (owner._isIndexAvailable()) {
                    this._target.processListener(listener);
                }
            }
            finally {
                owner._count = prevCount;
                owner._setIndex(prevIndex);
                owner._restoreScopeValues();
            }
        }

        public int getIndex() {
            return this._index;
        }

        public FacesEvent getTarget() {
            return this._target;
        }
    }

    static enum PropertyKeys {
        value,
        var,
        size,
        varStatus,
        offset,
        step;

    }

    private static final class SavedState
    implements Serializable {
        private boolean _localValueSet;
        private Object _submittedValue;
        private boolean _valid = true;
        private Object _value;
        private static final long serialVersionUID = 2920252657338389849L;

        public SavedState(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._localValueSet = evh.isLocalValueSet();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
        }

        Object getSubmittedValue() {
            return this._submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this._submittedValue = submittedValue;
        }

        boolean isValid() {
            return this._valid;
        }

        void setValid(boolean valid) {
            this._valid = valid;
        }

        Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        boolean isLocalValueSet() {
            return this._localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this._localValueSet = localValueSet;
        }

        public String toString() {
            return "submittedValue: " + this._submittedValue + " value: " + this._value + " localValueSet: " + this._localValueSet;
        }

        public void restoreState(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
            evh.setLocalValueSet(this._localValueSet);
        }

        public void populate(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
            this._localValueSet = evh.isLocalValueSet();
        }

        public void apply(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
            evh.setLocalValueSet(this._localValueSet);
        }
    }
}

