/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageStrategy;

public class ViewDeclarationLanguageFactoryImpl
extends ViewDeclarationLanguageFactory {
    public static final String PARAM_DISABLE_JSF_FACELET = "javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER";
    private static final String FACELETS_1_VIEW_HANDLER = "com.sun.facelets.FaceletViewHandler";
    private static final Logger LOGGER = Logger.getLogger(ViewDeclarationLanguageFactoryImpl.class.getName());
    private volatile boolean _initialized = false;
    private volatile ViewDeclarationLanguageStrategy[] _supportedLanguages;

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage(String viewId) {
        if (!this._initialized) {
            this.initialize();
        }
        ViewDeclarationLanguageStrategy[] viewDeclarationLanguageStrategyArray = this._supportedLanguages;
        int n = this._supportedLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            ViewDeclarationLanguageStrategy strategy = viewDeclarationLanguageStrategyArray[n2];
            if (strategy.handles(viewId)) {
                return strategy.getViewDeclarationLanguage();
            }
            ++n2;
        }
        throw new FacesException("Cannot find a valid PDL for view id " + viewId);
    }

    private synchronized void initialize() {
        if (!this._initialized) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (this.isFacelets2Enabled(context)) {
                this.logWarningIfLegacyFaceletViewHandlerIsPresent(context);
                if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isSupportJSPAndFacesEL()) {
                    this._supportedLanguages = new ViewDeclarationLanguageStrategy[1];
                    this._supportedLanguages[0] = new FaceletViewDeclarationLanguageStrategy();
                } else {
                    this._supportedLanguages = new ViewDeclarationLanguageStrategy[1];
                    this._supportedLanguages[0] = new FaceletViewDeclarationLanguageStrategy();
                }
            } else {
                this._supportedLanguages = new ViewDeclarationLanguageStrategy[0];
            }
            this._initialized = true;
        }
    }

    private boolean isFacelets2Enabled(FacesContext context) {
        String param = context.getExternalContext().getInitParameter(PARAM_DISABLE_JSF_FACELET);
        boolean facelets2ParamDisabled = param != null && Boolean.parseBoolean(param.toLowerCase());
        return !facelets2ParamDisabled;
    }

    private void logWarningIfLegacyFaceletViewHandlerIsPresent(FacesContext context) {
        boolean facelets1ViewHandlerPresent = context.getApplication().getViewHandler().getClass().getName().equals(FACELETS_1_VIEW_HANDLER);
        if (facelets1ViewHandlerPresent && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Your faces-config.xml contains the com.sun.facelets.FaceletViewHandler class.\nYou need to remove it since you have not disabled the \"new\" Facelets-2 version with the javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER context parameter");
        }
    }
}

