/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import org.apache.myfaces.util._ValidationUtils;

public final class ExternalSpecifications {
    private static final Logger log = Logger.getLogger(ExternalSpecifications.class.getName());
    private static volatile Boolean beanValidationAvailable;
    private static volatile Boolean unifiedELAvailable;

    public static boolean isBeanValidationAvailable() {
        if (beanValidationAvailable == null) {
            try {
                try {
                    beanValidationAvailable = Class.forName("javax.validation.Validation") != null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    beanValidationAvailable = Boolean.FALSE;
                }
                if (beanValidationAvailable.booleanValue()) {
                    try {
                        _ValidationUtils.tryBuildDefaultValidatorFactory();
                    }
                    catch (Throwable throwable) {
                        beanValidationAvailable = false;
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.FINE, "Error loading class (could be normal)", t);
                beanValidationAvailable = false;
            }
            log.info("MyFaces Bean Validation support " + (beanValidationAvailable != false ? "enabled" : "disabled"));
        }
        return beanValidationAvailable;
    }

    public static boolean isUnifiedELAvailable() {
        if (unifiedELAvailable == null) {
            try {
                unifiedELAvailable = Class.forName("javax.el.ValueReference") != null && Class.forName("javax.el.ValueExpression").getMethod("getValueReference", ELContext.class) != null;
            }
            catch (Throwable throwable) {
                unifiedELAvailable = false;
            }
            log.info("MyFaces Unified EL support " + (unifiedELAvailable != false ? "enabled" : "disabled"));
        }
        return unifiedELAvailable;
    }

    private ExternalSpecifications() {
    }
}

