/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ResourceLoaderUtils {
    private static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String[] HTTP_REQUEST_DATE_HEADER = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMMM d HH:mm:ss yyyy"};
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static String formatDateHeader(long value) {
        SimpleDateFormat format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
        format.setTimeZone(GMT);
        return format.format(new Date(value));
    }

    public static Long parseDateHeader(String value) {
        Date date = null;
        int i = 0;
        while (date == null && i < HTTP_REQUEST_DATE_HEADER.length) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(HTTP_REQUEST_DATE_HEADER[i], Locale.US);
                format.setTimeZone(GMT);
                date = format.parse(value);
            }
            catch (ParseException parseException) {}
            ++i;
        }
        if (date == null) {
            return null;
        }
        return new Long(date.getTime());
    }

    public static long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return ResourceLoaderUtils.getResourceLastModified(url.openConnection());
    }

    public static long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            catch (Throwable throwable) {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                jarFileConnection.getInputStream().close();
            }
            catch (Exception exception) {}
        } else {
            modified = connection.getLastModified();
        }
        return modified;
    }
}

