/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import java.beans.FeatureDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.VariableResolver;
import org.apache.myfaces.el.VariableResolverImpl;

public final class VariableResolverToELResolver
extends ELResolver {
    private static final ThreadLocal<Collection<String>> propertyGuardThreadLocal = new ThreadLocal();
    private VariableResolver variableResolver;
    private boolean isDefaultLegacyVariableResolver;

    private static Collection<String> getPropertyGuard() {
        Collection<String> propertyGuard = propertyGuardThreadLocal.get();
        if (propertyGuard == null) {
            propertyGuard = new HashSet<String>();
            propertyGuardThreadLocal.set(propertyGuard);
        }
        return propertyGuard;
    }

    public VariableResolverToELResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
        this.isDefaultLegacyVariableResolver = this.variableResolver instanceof VariableResolverImpl;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new javax.el.PropertyNotFoundException();
        }
        context.setPropertyResolved(true);
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = (String)property;
        Collection<String> propertyGuard = VariableResolverToELResolver.getPropertyGuard();
        Object result = null;
        try {
            try {
                if (!propertyGuard.contains(strProperty)) {
                    propertyGuard.add(strProperty);
                    result = this.variableResolver.resolveVariable(VariableResolverToELResolver.facesContext(context), strProperty);
                }
            }
            catch (PropertyNotFoundException e) {
                context.setPropertyResolved(false);
                throw new javax.el.PropertyNotFoundException(e.getMessage(), (Throwable)e);
            }
            catch (EvaluationException e) {
                context.setPropertyResolved(false);
                throw new ELException(e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                context.setPropertyResolved(false);
                throw e;
            }
        }
        catch (Throwable throwable) {
            propertyGuard.remove(strProperty);
            if (propertyGuard.isEmpty()) {
                propertyGuardThreadLocal.remove();
            }
            context.setPropertyResolved(result != null);
            throw throwable;
        }
        propertyGuard.remove(strProperty);
        if (propertyGuard.isEmpty()) {
            propertyGuardThreadLocal.remove();
        }
        context.setPropertyResolved(result != null);
        return result;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        if (base != null) {
            return null;
        }
        return String.class;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, javax.el.PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return;
        }
        if (base == null && property == null) {
            throw new javax.el.PropertyNotFoundException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return false;
        }
        if (base == null && property == null) {
            throw new javax.el.PropertyNotFoundException();
        }
        return false;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        if (base == null && property == null) {
            throw new javax.el.PropertyNotFoundException();
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        return null;
    }
}

