/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.ReleaseableFacesContextFactory;
import org.apache.myfaces.context.servlet.FacesContextImplBase;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.shared.util.NullIterator;

public class FacesContextImpl
extends FacesContextImplBase {
    private static final String METHOD_RESPONSEWRITER = "responseWriter";
    static final String RE_SPLITTER = "[\\s\\t\\r\\n]*\\,[\\s\\t\\r\\n]*";
    private Map<String, List<FacesMessage>> _messages = null;
    private List<FacesMessage> _orderedMessages = null;
    private PhaseId _currentPhaseId;
    private ResponseStream _responseStream = null;
    private ResponseWriter _responseWriter = null;
    private FacesMessage.Severity _maximumSeverity = null;
    private boolean _renderResponse = false;
    private boolean _responseComplete = false;
    private boolean _validationFailed = false;
    private PartialViewContext _partialViewContext = null;
    private ReleaseableFacesContextFactory _facesContextFactory = null;
    private PartialViewContextFactory _partialViewContextFactory = null;
    private RenderKitFactory _renderKitFactory = null;

    public FacesContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        this(new ServletExternalContextImpl(servletContext, servletRequest, servletResponse));
    }

    private FacesContextImpl(ServletExternalContextImpl externalContext) {
        this(externalContext, externalContext, null);
    }

    public FacesContextImpl(ExternalContext externalContext, ReleaseableExternalContext defaultExternalContext, ReleaseableFacesContextFactory facesContextFactory) {
        super(externalContext, defaultExternalContext);
        this._facesContextFactory = facesContextFactory;
    }

    public FacesContextImpl(ExternalContext externalContext, ReleaseableExternalContext defaultExternalContext, ReleaseableFacesContextFactory facesContextFactory, ApplicationFactory applicationFactory, RenderKitFactory renderKitFactory, PartialViewContextFactory partialViewContextFactory) {
        super(externalContext, defaultExternalContext, applicationFactory, renderKitFactory);
        this._facesContextFactory = facesContextFactory;
        this._renderKitFactory = renderKitFactory;
        this._partialViewContextFactory = partialViewContextFactory;
    }

    @Override
    public final void release() {
        this.assertNotReleased();
        this._messages = null;
        this._orderedMessages = null;
        this._currentPhaseId = null;
        this._responseStream = null;
        this._responseWriter = null;
        this._maximumSeverity = null;
        this._partialViewContext = null;
        this._renderKitFactory = null;
        this._partialViewContextFactory = null;
        if (this._facesContextFactory != null) {
            this._facesContextFactory.release();
            this._facesContextFactory = null;
        }
        super.release();
    }

    @Override
    public final FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        return this._maximumSeverity;
    }

    @Override
    public final void addMessage(String clientId, FacesMessage message) {
        List<FacesMessage> lst;
        this.assertNotReleased();
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this._messages == null) {
            this._messages = new LinkedHashMap<String, List<FacesMessage>>();
            this._orderedMessages = new ArrayList<FacesMessage>();
        }
        if ((lst = this._messages.get(clientId)) == null) {
            lst = new ArrayList<FacesMessage>();
            this._messages.put(clientId, lst);
        }
        lst.add(message);
        this._orderedMessages.add(message);
        FacesMessage.Severity serSeverity = message.getSeverity();
        if (serSeverity != null) {
            if (this._maximumSeverity == null) {
                this._maximumSeverity = serSeverity;
            } else if (serSeverity.compareTo(this._maximumSeverity) > 0) {
                this._maximumSeverity = serSeverity;
            }
        }
    }

    @Override
    public List<FacesMessage> getMessageList() {
        this.assertNotReleased();
        if (this._messages == null) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        return Collections.unmodifiableList(this._orderedMessages);
    }

    @Override
    public List<FacesMessage> getMessageList(String clientId) {
        this.assertNotReleased();
        if (this._messages == null || !this._messages.containsKey(clientId)) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
        return this._messages.get(clientId);
    }

    @Override
    public final Iterator<FacesMessage> getMessages() {
        this.assertNotReleased();
        if (this._messages == null) {
            return NullIterator.instance();
        }
        return this._orderedMessages.iterator();
    }

    @Override
    public final Iterator<FacesMessage> getMessages(String clientId) {
        this.assertNotReleased();
        if (this._messages == null || !this._messages.containsKey(clientId)) {
            return NullIterator.instance();
        }
        return this._messages.get(clientId).iterator();
    }

    @Override
    public final Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        if (this._messages == null || this._messages.isEmpty()) {
            return NullIterator.instance();
        }
        return this._messages.keySet().iterator();
    }

    @Override
    public PhaseId getCurrentPhaseId() {
        this.assertNotReleased();
        return this._currentPhaseId;
    }

    @Override
    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        this.assertNotReleased();
        this._currentPhaseId = currentPhaseId;
    }

    @Override
    public PartialViewContext getPartialViewContext() {
        this.assertNotReleased();
        if (this._partialViewContext == null) {
            if (this._partialViewContextFactory == null) {
                this._partialViewContextFactory = (PartialViewContextFactory)FactoryFinder.getFactory("javax.faces.context.PartialViewContextFactory");
            }
            this._partialViewContext = this._partialViewContextFactory.getPartialViewContext(FacesContext.getCurrentInstance());
        }
        return this._partialViewContext;
    }

    @Override
    public final boolean getRenderResponse() {
        this.assertNotReleased();
        return this._renderResponse;
    }

    @Override
    public final void renderResponse() {
        this.assertNotReleased();
        this._renderResponse = true;
    }

    @Override
    public final boolean getResponseComplete() {
        this.assertNotReleased();
        return this._responseComplete;
    }

    @Override
    public final void responseComplete() {
        this.assertNotReleased();
        this._responseComplete = true;
    }

    @Override
    public final void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        if (responseStream == null) {
            throw new NullPointerException("responseStream");
        }
        this._responseStream = responseStream;
    }

    @Override
    public final ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this._responseStream;
    }

    @Override
    public final void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        if (responseWriter == null) {
            throw new NullPointerException(METHOD_RESPONSEWRITER);
        }
        this._responseWriter = responseWriter;
    }

    @Override
    public final ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this._responseWriter;
    }

    @Override
    public boolean isPostback() {
        this.assertNotReleased();
        RenderKit renderKit = this.getRenderKit();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (renderKit == null) {
            String renderKitId = facesContext.getApplication().getViewHandler().calculateRenderKitId(facesContext);
            if (this._renderKitFactory == null) {
                this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
            }
            renderKit = this._renderKitFactory.getRenderKit(facesContext, renderKitId);
        }
        return renderKit.getResponseStateManager().isPostback(facesContext);
    }

    @Override
    public void validationFailed() {
        this.assertNotReleased();
        this._validationFailed = true;
    }

    @Override
    public boolean isValidationFailed() {
        this.assertNotReleased();
        return this._validationFailed;
    }
}

