/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.util.AbstractAttributeMap;

public final class CookieMap
extends AbstractAttributeMap<Object> {
    private static final Cookie[] EMPTY_ARRAY = new Cookie[0];
    private final HttpServletRequest _httpServletRequest;

    CookieMap(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear HttpRequest Cookies");
    }

    @Override
    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Cookie[] cookies = this._httpServletRequest.getCookies();
        if (cookies == null) {
            return false;
        }
        int i = 0;
        int len = cookies.length;
        while (i < len) {
            if (findValue.equals(cookies[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        return cookies == null || cookies.length == 0;
    }

    @Override
    public int size() {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        return cookies == null ? 0 : cookies.length;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getAttribute(String key) {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        int i = 0;
        int len = cookies.length;
        while (i < len) {
            if (cookies[i].getName().equals(key)) {
                return cookies[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("Cannot set HttpRequest Cookies");
    }

    @Override
    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove HttpRequest Cookies");
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        return cookies == null ? new CookieNameEnumeration(EMPTY_ARRAY) : new CookieNameEnumeration(cookies);
    }

    private static class CookieNameEnumeration
    implements Enumeration<String> {
        private final Cookie[] _cookies;
        private final int _length;
        private int _index;

        public CookieNameEnumeration(Cookie[] cookies) {
            this._cookies = cookies;
            this._length = cookies.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this._index < this._length;
        }

        @Override
        public String nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this._cookies[this._index++].getName();
        }
    }
}

