/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.DataInput;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class _ClassByteCodeAnnotationFilter {
    private static final Logger log = Logger.getLogger(_ClassByteCodeAnnotationFilter.class.getName());
    private static final int CP_INFO_CLASS = 7;
    private static final int CP_INFO_FIELD_REF = 9;
    private static final int CP_INFO_METHOD_REF = 10;
    private static final int CP_INFO_INTERFACE_REF = 11;
    private static final int CP_INFO_STRING = 8;
    private static final int CP_INFO_INTEGER = 3;
    private static final int CP_INFO_FLOAT = 4;
    private static final int CP_INFO_LONG = 5;
    private static final int CP_INFO_DOUBLE = 6;
    private static final int CP_INFO_NAME_AND_TYPE = 12;
    private static final int CP_INFO_UTF8 = 1;

    _ClassByteCodeAnnotationFilter() {
    }

    public boolean couldContainAnnotationsOnClassDef(DataInput in, Set<String> byteCodeAnnotationsNames) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            return false;
        }
        in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        if (majorVersion < 49) {
            return false;
        }
        int constantsPoolCount = in.readUnsignedShort();
        int i = 1;
        while (i < constantsPoolCount) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 1: {
                    String name = in.readUTF();
                    if (!byteCodeAnnotationsNames.contains(name)) break;
                    return true;
                }
                case 7: {
                    in.readUnsignedShort();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    break;
                }
                case 8: {
                    in.readUnsignedShort();
                    break;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    break;
                }
                case 5: 
                case 6: {
                    in.readInt();
                    in.readInt();
                    ++i;
                    break;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    break;
                }
                default: {
                    if (log.isLoggable(Level.WARNING)) {
                        log.warning("Unknown tag in constants pool: " + tag);
                    }
                    i = constantsPoolCount;
                }
            }
            ++i;
        }
        return false;
    }
}

